<?php
// routes/web.php

use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('welcome');
});

Auth::routes();

Route::middleware(['auth'])->group(function () {
    Route::get('/dashboard', function () {
        return view('home');
    })->name('dashboard');

    // Include route files in logical order
    require __DIR__.'/customers.php';
    require __DIR__.'/shipments.php';
    require __DIR__.'/vendors.php';
    require __DIR__.'/services.php';
    require __DIR__.'/finance.php';
});

// Public currency rate endpoint
Route::get('/currencies/rate/{code}', function ($code) {
    $currency = \App\Models\Currency::where('code', strtoupper($code))->firstOrFail();
    return response()->json([
        'code' => $currency->code,
        'selling_exchange_rate' => $currency->selling_exchange_rate
    ]);
});