<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Vendors\ServiceProviderController;
use App\Http\Controllers\Vendors\SupplierPaymentController;
use App\Http\Controllers\Vendors\ServiceProviderReportController;


/**
 * =========================================
 * SERVICE PROVIDERS (COURIERS / VENDORS)
 * =========================================
 */
Route::resource('service-providers', ServiceProviderController::class);

Route::prefix('service-providers')->name('service-providers.')->group(function () {

    // Create with type parameter (service_provider or supplier)
    Route::get('/create/{type}', [ServiceProviderController::class, 'create'])
        ->name('create.type')
        ->where('type', 'service_provider|supplier');

    // Toggle active/inactive
    Route::post('/{serviceProvider}/toggle-status', [ServiceProviderController::class, 'toggleStatus'])
        ->name('toggle-status');

    // Set default provider
    Route::post('/{serviceProvider}/set-default', [ServiceProviderController::class, 'setDefault'])
        ->name('set-default');

    // Routes management
    Route::post('/{serviceProvider}/routes', [ServiceProviderController::class, 'storeRoute'])
        ->name('routes.store');
    Route::put('/routes/{route}', [ServiceProviderController::class, 'updateRoute'])
        ->name('routes.update');
    Route::delete('/routes/{route}', [ServiceProviderController::class, 'destroyRoute'])
        ->name('routes.destroy');

    // Weight bands
    Route::post('/routes/{route}/weight-bands', [ServiceProviderController::class, 'storeWeightBand'])
        ->name('weight-bands.store');
    Route::put('/weight-bands/{weightBand}', [ServiceProviderController::class, 'updateWeightBand'])
        ->name('weight-bands.update');
    Route::delete('/weight-bands/{weightBand}', [ServiceProviderController::class, 'destroyWeightBand'])
        ->name('weight-bands.destroy');

    // Divisors for weight types (e.g. 6000, 50000, 1,000,000)
    Route::get('/weight-types/divisors', [ServiceProviderController::class, 'getWeightDivisors'])
        ->name('weight-types.divisors');

    // Payments
    Route::get('/{serviceProvider}/payments', [ServiceProviderController::class, 'paymentIndex'])
        ->name('payments.index');
    Route::post('/{serviceProvider}/payments', [ServiceProviderController::class, 'paymentStore'])
        ->name('payments.store');
    Route::get('/{serviceProvider}/payments/create', [ServiceProviderController::class, 'paymentCreate'])
        ->name('payments.create');
    Route::get('/{serviceProvider}/payments/{payment}', [ServiceProviderController::class, 'paymentShow'])
        ->name('payments.show');

    // Settlement
    Route::get('/{serviceProvider}/settlement', [ServiceProviderController::class, 'settlementIndex'])
        ->name('settlement.index');
    Route::get('/{serviceProvider}/settlement/generate', [ServiceProviderController::class, 'settlementGenerate'])
        ->name('settlement.generate');

    // API endpoints (for JS / AJAX)
    Route::prefix('api')->name('api.')->group(function () {
        Route::get('/search', [ServiceProviderController::class, 'search'])
            ->name('search');
        Route::get('/{serviceProvider}/routes', [ServiceProviderController::class, 'getRoutes'])
            ->name('routes');
        Route::post('/calculate-rates', [ServiceProviderController::class, 'calculateRates'])
            ->name('calculate-rates');
        Route::get('/weight-methods', [ServiceProviderController::class, 'getWeightMethods'])
            ->name('weight-methods');
    });
});

/**
 * =========================================
 * SUPPLIER PAYMENTS
 * =========================================
 */
Route::resource('supplier-payments', SupplierPaymentController::class)->except(['create', 'store']);

Route::prefix('supplier-payments')->name('supplier-payments.')->group(function () {
    Route::post('/export', [SupplierPaymentController::class, 'export'])
        ->name('export');
});

/**
 * =========================================
 * REPORTS
 * =========================================
 */
Route::prefix('reports/service-providers')->name('reports.service-providers.')->group(function () {
    Route::get('/', [ServiceProviderReportController::class, 'index'])->name('index');
    Route::get('/generate', [ServiceProviderReportController::class, 'generate'])->name('generate');
    Route::get('/route-performance', [ServiceProviderReportController::class, 'routePerformance'])->name('route-performance');
});

Route::get('/reports/supplier-payments', [ServiceProviderReportController::class, 'payments'])
    ->name('reports.supplier-payments');
