<?php
// routes/shipments.php

use App\Http\Controllers\ShipmentController;
use App\Http\Controllers\ShipmentRouteController;
use App\Http\Controllers\ShipmentFormController;

Route::middleware(['auth'])->group(function () {
    // Shipments
    Route::resource('shipments', ShipmentController::class)->except(['show']);
    
    // Additional shipment routes
    Route::prefix('shipments')->group(function () {
        Route::post('/preview', [ShipmentController::class, 'preview'])
            ->name('shipments.preview');
        
        Route::get('/{shipment}/summary', [ShipmentController::class, 'summary'])
            ->name('shipments.summary');
        
        Route::get('/{shipment}/labels', [ShipmentController::class, 'printLabels'])
            ->name('shipments.labels');
        
        Route::get('/{shipment}/track', [ShipmentController::class, 'track'])
            ->name('shipments.track');
        
        Route::post('/calculate-chargeable', [ShipmentFormController::class, 'calculateChargeable'])
            ->name('shipments.calculate-chargeable');
        
        Route::post('/get-route-rates', [ShipmentFormController::class, 'getRouteRates'])
            ->name('shipments.get-route-rates');
    });

    // Shipment Routes
    Route::resource('shipment-routes', ShipmentRouteController::class);
    Route::prefix('shipment-routes')->group(function () {
        Route::post('/find-route', [ShipmentRouteController::class, 'findRoute'])
            ->name('shipment-routes.find-route');
        
        Route::post('/breakdown', [ShipmentRouteController::class, 'breakdown'])
            ->name('shipment-routes.breakdown');
        
        Route::post('/history', [ShipmentRouteController::class, 'history'])
            ->name('shipment-routes.history');
    });
});