<?php

use App\Http\Controllers\CurrencyController;
use App\Http\Controllers\ServiceProviderReportController;

Route::middleware(['auth'])->group(function () {
    // Currencies
    Route::resource('currencies', CurrencyController::class)->except(['show']);

    // Service Provider Reports
    Route::prefix('reports')->group(function () {
        Route::get('/service-providers', [ServiceProviderReportController::class, 'index'])
            ->name('reports.service-providers.index');
        
        Route::get('/service-providers/generate', [ServiceProviderReportController::class, 'generate'])
            ->name('reports.service-providers.generate');
        
        Route::get('/supplier-payments', [ServiceProviderReportController::class, 'payments'])
            ->name('reports.supplier-payments');
        
        Route::get('/route-performance', [ServiceProviderReportController::class, 'routePerformance'])
            ->name('reports.route-performance');
    });
});