<?php
// routes/customers.php

use App\Http\Controllers\CustomerController;
use App\Http\Controllers\CustomerReportController;

Route::middleware(['auth'])->group(function () {
    // Customers Resource Routes
    Route::resource('customers', CustomerController::class);
    
    // Customer AJAX routes - SINGLE DEFINITION
    Route::prefix('customer-ajax')->name('customer.ajax.')->group(function () {
        Route::get('/search', [CustomerController::class, 'searchByPhone'])
            ->name('search');
        
        Route::post('/store', [CustomerController::class, 'storeApi'])
            ->name('store');
    });

    // Customer Reports Routes
    Route::prefix('customer-reports')->name('customer-reports.')->group(function () {
        Route::get('/', [CustomerReportController::class, 'index'])
            ->name('index');
        
        Route::get('/revenue', [CustomerReportController::class, 'revenueReport'])
            ->name('revenue');
        
        Route::get('/activity', [CustomerReportController::class, 'customerActivity'])
            ->name('activity');
        
        Route::get('/high-value', [CustomerReportController::class, 'highValueCustomers'])
            ->name('high-value');
        
        Route::get('/lifetime-value', [CustomerReportController::class, 'customerLifetimeValue'])
            ->name('lifetime-value');
    });
});