<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CustomerController;

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// Customer API Routes - use web auth for compatibility
Route::middleware(['auth:web'])->group(function () {
    // Search customer by phone
    Route::get('/customers/search', [CustomerController::class, 'searchByPhone'])
        ->name('api.customers.search');
    
    // Create new customer via API
    Route::post('/customers', [CustomerController::class, 'storeApi'])
        ->name('api.customers.store');
});