<tbody id="serviceProvidersTable">
    @forelse($serviceProviders as $provider)
        <tr>
            <td>{{ $provider->id }}</td>

            <td>
                <a href="{{ route('vendors.service-providers.show', $provider) }}">
                    {{ $provider->name }}
                </a>
            </td>

            <td>{{ ucfirst($provider->type) }}</td>

            <td>
                @if($provider->status === 'active')
                    <span class="badge bg-success">Active</span>
                @else
                    <span class="badge bg-danger">Inactive</span>
                @endif
            </td>

            <td class="text-end">
                <a href="{{ route('vendors.service-providers.edit', $provider) }}" class="btn btn-sm btn-info">
                    Edit
                </a>

                <form action="{{ route('vendors.service-providers.destroy', $provider) }}" method="POST" style="display:inline-block;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-sm btn-danger"
                            onclick="return confirm('Delete this provider?')">
                        Delete
                    </button>
                </form>
            </td>
        </tr>
    @empty
        <tr>
            <td colspan="5" class="text-center">No service providers found.</td>
        </tr>
    @endforelse
</tbody>
