@extends('layouts.clivax')

@section('title', 'Vendors Dashboard')

@section('content')
<div class="row mb-4">
    <div class="col-12 d-flex justify-content-between align-items-center">
        <h4 class="page-title">Vendors Dashboard</h4>

        <!-- Toggle: Service Providers / Suppliers -->
        <div>
            <button class="btn btn-primary me-2" id="toggleServiceProviders">Service Providers</button>
            <button class="btn btn-outline-secondary" id="toggleSuppliers">Suppliers</button>
        </div>
    </div>
</div>

<!-- DASHBOARD WRAPPER -->
<div id="vendors-dashboard">
    <!-- Service Providers Dashboard -->
    <div id="serviceProvidersSection">
        @include('vendor.service-providers.partials.stats')
        @include('vendor.service-providers.partials.table')
    </div>

    <!-- Suppliers Dashboard -->
    <div id="suppliersSection" class="d-none">
        @include('vendor.service-providers.partials.suppliers-stats')
        @include('vendor.service-providers.partials.suppliers-table')
    </div>
</div>

<!-- Global Modals -->
@include('vendor.service-providers.partials.modals.add-provider')
@include('vendor.service-providers.partials.modals.export')
@include('vendor.service-providers.partials.modals.search')
@endsection
