@extends('layouts.clivax')

@section('content')
<div class="row">
  <div class="col-12">
    <h4>Shipment Routes</h4>
    <a href="{{ route('shipment-routes.create') }}" class="btn btn-primary mb-3">+ New Route</a>

    <table class="table table-bordered table-striped">
      <thead>
        <tr>
          <th>Route</th>
          <th>Mode</th>
          <th>Measure</th>
          <th>Category</th>
          <th>Unit Type</th>
          <th>Rate/Unit</th>
          <th>Min Weight</th>
          <th>Flat Rate</th>
          <th>Currency</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
        @forelse($routes as $r)
          <tr>
            <td>{{ $r->originCountry?->code ?? '-' }} → {{ $r->destinationCountry?->code ?? '-' }}</td>
            <td>{{ $r->shipmentMode?->name ?? '-' }}</td>
            <td>{{ $r->shipmentMode?->measure?->code ?? '-' }}</td>
            <td>{{ $r->cargoCategory?->name ?? '-' }}</td>
            <td>{{ strtoupper($r->unit_type ?? '-') }}</td>
            <td>{{ number_format($r->rate_per_unit, 2) ?? '-' }}</td>
            <td>{{ number_format($r->minimum_weight, 2) ?? '-' }}</td>
            <td>{{ number_format($r->flat_rate, 2) ?? '-' }}</td>
            <td>{{ $r->currency?->code ?? '-' }}</td>
            <td>
              <a href="{{ route('shipment-routes.edit', $r) }}" class="btn btn-sm btn-warning">Edit</a>
              <form action="{{ route('shipment-routes.destroy', $r) }}" method="POST" class="d-inline">
                @csrf @method('DELETE')
                <button class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
              </form>
            </td>
          </tr>
        @empty
          <tr>
            <td colspan="10" class="text-center text-muted">No shipment routes defined yet.</td>
          </tr>
        @endforelse
      </tbody>
    </table>
  </div>
</div>
@endsection
