@extends('layouts.clivax')

@section('content')
<div class="row">
  <div class="col-6">
    <h4>Edit Service</h4>
    <form action="{{ route('services.update', $service) }}" method="POST">
      @csrf
      @method('PUT')

      <div class="mb-3">
        <label>Name</label>
        <input name="name" value="{{ $service->name }}" class="form-control" required>
      </div>

      <div class="mb-3">
        <label>Cost Currency</label>
        <select name="cost_currency_id" class="form-control" required>
          @foreach($currencies as $c)
            <option value="{{ $c->id }}" @if($service->cost_currency_id == $c->id) selected @endif>{{ $c->code }}</option>
          @endforeach
        </select>
      </div>

      <div class="mb-3">
        <label>Charge Currency</label>
        <select name="charge_currency_id" class="form-control" required>
          @foreach($currencies as $c)
            <option value="{{ $c->id }}" @if($service->charge_currency_id == $c->id) selected @endif>{{ $c->code }}</option>
          @endforeach
        </select>
      </div>

      <div class="mb-3">
        <label>Cost Amount</label>
        <input type="number" name="cost_amount" value="{{ $service->cost_amount }}" class="form-control" step="0.01" required>
      </div>

      <div class="mb-3">
        <label>Selling Price</label>
        <input type="number" name="selling_price" value="{{ $service->selling_price }}" class="form-control" step="0.01" required>
      </div>

      <div class="mb-3">
        <label>Profit Margin</label>
        <input type="number" name="profit_margin" value="{{ $service->profit_margin }}" class="form-control" step="0.01" required>
      </div>

      <button class="btn btn-primary">Update</button>
      <a href="{{ route('services.index') }}" class="btn btn-secondary">Cancel</a>
    </form>
  </div>
</div>
@endsection
