<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    {{-- CSS should be loaded here --}}
    @include('partials.head-css')

    <title>{{ $title ?? 'Smart Shipping System' }}</title>
</head>
<body>
    @include('partials.topbar')

    <div id="layout-wrapper">
        @include('partials.sidebar')

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    @yield('content')
                </div>
            </div>

            @include('partials.footer')
        </div>
    </div>

    {{-- Scripts should be loaded AFTER DOM --}}
    @include('partials.vendor-scripts')
    
    @stack('scripts')
    <!-- Helpers first -->
<script src="{{ asset('js/suppliers/utils/helpers.js') }}"></script>

<!-- Modules -->
<script src="{{ asset('js/suppliers/modules/dashboard.js') }}"></script>
<script src="{{ asset('js/suppliers/modules/search-manager.js') }}"></script>
<script src="{{ asset('js/suppliers/modules/export-manager.js') }}"></script>
<script src="{{ asset('js/suppliers/modules/modal-manager.js') }}"></script>
<script src="{{ asset('js/suppliers/modules/vendor-manager.js') }}"></script>
<script src="{{ asset('js/suppliers/modules/app-shell.js') }}"></script>

<!-- Entrypoint -->
<script src="{{ asset('js/suppliers/suppliers.js') }}"></script>

</body>
</html>
