@extends('layouts.clivax')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h4 class="mb-0">Customer Revenue Report</h4>
            <div>
                <a href="{{ route('customer-reports.index') }}" class="btn btn-secondary me-2">
                    <i class="ri-arrow-left-line"></i> Back to Reports
                </a>
                <a href="{{ route('customers.index') }}" class="btn btn-primary">
                    <i class="ri-user-line"></i> Customers
                </a>
            </div>
        </div>

        <!-- Filters -->
        <div class="card mb-4">
            <div class="card-body">
                <form method="GET" class="row g-3">
                    <div class="col-md-3">
                        <label class="form-label">Start Date</label>
                        <input type="date" name="start_date" class="form-control" value="{{ $startDate }}">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">End Date</label>
                        <input type="date" name="end_date" class="form-control" value="{{ $endDate }}">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Customer Type</label>
                        <select name="customer_type" class="form-select">
                            <option value="">All Types</option>
                            <option value="individual">Individual</option>
                            <option value="business">Business</option>
                            <option value="corporate">Corporate</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary">Generate Report</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Revenue Summary -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card bg-primary text-white">
                    <div class="card-body text-center">
                        <h6>Total Revenue</h6>
                        <h3>${{ number_format($customers->sum('recent_revenue'), 2) }}</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-success text-white">
                    <div class="card-body text-center">
                        <h6>Active Customers</h6>
                        <h3>{{ $customers->where('recent_shipments_count', '>', 0)->count() }}</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-info text-white">
                    <div class="card-body text-center">
                        <h6>Avg. Revenue/Customer</h6>
                        <h3>${{ number_format($customers->avg('recent_revenue'), 2) }}</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-warning text-white">
                    <div class="card-body text-center">
                        <h6>Total Shipments</h6>
                        <h3>{{ $customers->sum('recent_shipments_count') }}</h3>
                    </div>
                </div>
            </div>
        </div>

        <!-- Revenue Table -->
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>Customer</th>
                                <th>Type</th>
                                <th>Recent Revenue</th>
                                <th>Recent Shipments</th>
                                <th>Total Revenue</th>
                                <th>Avg. Shipment Value</th>
                                <th>Last Shipment</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($customers as $customer)
                            <tr>
                                <td>
                                    <strong>{{ $customer->name }}</strong>
                                    @if($customer->company_name)
                                        <br><small class="text-muted">{{ $customer->company_name }}</small>
                                    @endif
                                    <br><small class="text-muted">{{ $customer->phone }}</small>
                                </td>
                                <td>
                                    <span class="badge bg-{{ $customer->customer_type == 'business' ? 'info' : ($customer->customer_type == 'corporate' ? 'primary' : 'secondary') }}">
                                        {{ ucfirst($customer->customer_type) }}
                                    </span>
                                </td>
                                <td class="text-success">
                                    <strong>${{ number_format($customer->recent_revenue, 2) }}</strong>
                                </td>
                                <td>
                                    <span class="badge bg-light text-dark">{{ $customer->recent_shipments_count }}</span>
                                </td>
                                <td class="text-primary">
                                    <strong>${{ number_format($customer->total_revenue, 2) }}</strong>
                                </td>
                                <td>
                                    ${{ number_format($customer->average_shipment_value, 2) }}
                                </td>
                                <td>
                                    {{ $customer->last_shipment_date ? $customer->last_shipment_date->format('M d, Y') : 'Never' }}
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection