@extends('layouts.clivax')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h4 class="mb-0">Customer Activity Report</h4>
            <div>
                <a href="{{ route('customer-reports.index') }}" class="btn btn-secondary me-2">
                    <i class="ri-arrow-left-line"></i> Back to Reports
                </a>
                <a href="{{ route('customers.index') }}" class="btn btn-primary">
                    <i class="ri-user-line"></i> Customers
                </a>
            </div>
        </div>

        <!-- Filters -->
        <div class="card mb-4">
            <div class="card-body">
                <form method="GET" class="row g-3">
                    <div class="col-md-4">
                        <label class="form-label">Customer</label>
                        <select name="customer_id" class="form-select">
                            <option value="">All Customers</option>
                            @foreach($customers as $customer)
                                <option value="{{ $customer->id }}" {{ request('customer_id') == $customer->id ? 'selected' : '' }}>
                                    {{ $customer->name }} - {{ $customer->phone }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Activity Period</label>
                        <select name="days" class="form-select">
                            <option value="7" {{ $days == 7 ? 'selected' : '' }}>Last 7 Days</option>
                            <option value="30" {{ $days == 30 ? 'selected' : '' }}>Last 30 Days</option>
                            <option value="90" {{ $days == 90 ? 'selected' : '' }}>Last 90 Days</option>
                            <option value="365" {{ $days == 365 ? 'selected' : '' }}>Last Year</option>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary">Generate Report</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Activity Summary -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card bg-primary text-white">
                    <div class="card-body text-center">
                        <h6>Active Customers</h6>
                        <h3>{{ $customers->where('activities_count', '>', 0)->count() }}</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-success text-white">
                    <div class="card-body text-center">
                        <h6>Total Activities</h6>
                        <h3>{{ $customers->sum('activities_count') }}</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-info text-white">
                    <div class="card-body text-center">
                        <h6>Avg. Activities/Customer</h6>
                        <h3>{{ number_format($customers->avg('activities_count'), 1) }}</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-warning text-white">
                    <div class="card-body text-center">
                        <h6>Most Active</h6>
                        <h6>{{ $customers->sortByDesc('activities_count')->first()->name ?? 'N/A' }}</h6>
                    </div>
                </div>
            </div>
        </div>

        <!-- Activity Table -->
        <div class="card">
            <div class="card-body">
                @if(request('customer_id'))
                    <!-- Single Customer Detailed View -->
                    @php $customer = $customers->firstWhere('id', request('customer_id')); @endphp
                    @if($customer)
                    <div class="mb-4 p-3 border rounded bg-light">
                        <h5>Customer: {{ $customer->name }}</h5>
                        <div class="row">
                            <div class="col-md-3"><strong>Phone:</strong> {{ $customer->phone }}</div>
                            <div class="col-md-3"><strong>Email:</strong> {{ $customer->email ?? 'N/A' }}</div>
                            <div class="col-md-3"><strong>Type:</strong> {{ ucfirst($customer->customer_type) }}</div>
                            <div class="col-md-3"><strong>Status:</strong> {{ ucfirst($customer->status) }}</div>
                        </div>
                    </div>

                    <h6 class="mb-3">Recent Activities ({{ $customer->activities->count() }})</h6>
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Date & Time</th>
                                    <th>Activity Type</th>
                                    <th>Description</th>
                                    <th>Performed By</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($customer->activities as $activity)
                                <tr>
                                    <td>{{ $activity->performed_at->format('M d, Y H:i') }}</td>
                                    <td>
                                        <span class="badge bg-{{ $activity->activity_type == 'shipment_created' ? 'success' : ($activity->activity_type == 'payment_received' ? 'info' : 'secondary') }}">
                                            {{ str_replace('_', ' ', ucfirst($activity->activity_type)) }}
                                        </span>
                                    </td>
                                    <td>{{ $activity->description }}</td>
                                    <td>{{ $activity->performer->name ?? 'System' }}</td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="4" class="text-center text-muted py-4">
                                        No activities found for this period
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    @endif
                @else
                    <!-- All Customers Summary View -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Customer</th>
                                    <th>Contact</th>
                                    <th>Activities Count</th>
                                    <th>Last Activity</th>
                                    <th>Total Revenue</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($customers as $customer)
                                <tr>
                                    <td>
                                        <strong>{{ $customer->name }}</strong>
                                        @if($customer->company_name)
                                            <br><small class="text-muted">{{ $customer->company_name }}</small>
                                        @endif
                                    </td>
                                    <td>
                                        {{ $customer->phone }}<br>
                                        <small class="text-muted">{{ $customer->email ?? 'N/A' }}</small>
                                    </td>
                                    <td>
                                        <span class="badge bg-{{ $customer->activities_count > 0 ? 'success' : 'secondary' }}">
                                            {{ $customer->activities_count }} activities
                                        </span>
                                    </td>
                                    <td>
                                        @if($customer->activities->count() > 0)
                                            {{ $customer->activities->first()->performed_at->format('M d, Y') }}
                                            <br><small class="text-muted">{{ $customer->activities->first()->activity_type }}</small>
                                        @else
                                            <span class="text-muted">No activities</span>
                                        @endif
                                    </td>
                                    <td class="text-success">
                                        <strong>${{ number_format($customer->total_revenue, 2) }}</strong>
                                    </td>
                                    <td>
                                        <a href="{{ route('customer-reports.activity', ['customer_id' => $customer->id, 'days' => $days]) }}" 
                                           class="btn btn-sm btn-info">
                                            <i class="ri-eye-line"></i> View Details
                                        </a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection