@extends('layouts.clivax')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h4 class="mb-0">Customers</h4>
            <div>
                <a href="{{ route('customer-reports.index') }}" class="btn btn-info me-2">
                    <i class="ri-bar-chart-line"></i> Reports
                </a>
                <a href="{{ route('customers.create') }}" class="btn btn-primary">
                    <i class="ri-user-add-line"></i> New Customer
                </a>
            </div>
        </div>

        <!-- Customer Stats -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card bg-primary text-white">
                    <div class="card-body">
                        <h6 class="card-title">Total Customers</h6>
                        <h3>{{ $customers->count() }}</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-success text-white">
                    <div class="card-body">
                        <h6 class="card-title">Active Customers</h6>
                        <h3>{{ $customers->where('status', 'active')->count() }}</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-info text-white">
                    <div class="card-body">
                        <h6 class="card-title">Total Revenue</h6>
                        <h3>${{ number_format($customers->sum('total_revenue'), 2) }}</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-warning text-white">
                    <div class="card-body">
                        <h6 class="card-title">Avg. Value</h6>
                        <h3>${{ number_format($customers->avg('total_revenue'), 2) }}</h3>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters -->
        <div class="card mb-4">
            <div class="card-body">
                <form method="GET" class="row g-3">
                    <div class="col-md-3">
                        <label class="form-label">Customer Type</label>
                        <select name="customer_type" class="form-select">
                            <option value="">All Types</option>
                            <option value="individual" {{ request('customer_type') == 'individual' ? 'selected' : '' }}>Individual</option>
                            <option value="business" {{ request('customer_type') == 'business' ? 'selected' : '' }}>Business</option>
                            <option value="corporate" {{ request('customer_type') == 'corporate' ? 'selected' : '' }}>Corporate</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-select">
                            <option value="">All Status</option>
                            <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                            <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                            <option value="blocked" {{ request('status') == 'blocked' ? 'selected' : '' }}>Blocked</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Search</label>
                        <input type="text" name="search" class="form-control" placeholder="Name or Phone..." value="{{ request('search') }}">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary">Filter</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Customers Table -->
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>Name</th>
                                <th>Phone</th>
                                <th>Email</th>
                                <th>Type</th>
                                <th>Revenue</th>
                                <th>Shipments</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($customers as $customer)
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="avatar-sm bg-primary rounded-circle text-white d-flex align-items-center justify-content-center me-2" style="width: 32px; height: 32px;">
                                            {{ strtoupper(substr($customer->name, 0, 1)) }}
                                        </div>
                                        <div>
                                            <strong>{{ $customer->name }}</strong>
                                            @if($customer->company_name)
                                                <br><small class="text-muted">{{ $customer->company_name }}</small>
                                            @endif
                                        </div>
                                    </div>
                                </td>
                                <td>{{ $customer->phone }}</td>
                                <td>{{ $customer->email ?? 'N/A' }}</td>
                                <td>
                                    <span class="badge bg-{{ $customer->customer_type == 'business' ? 'info' : ($customer->customer_type == 'corporate' ? 'primary' : 'secondary') }}">
                                        {{ ucfirst($customer->customer_type) }}
                                    </span>
                                </td>
                                <td>
                                    <strong class="text-success">${{ number_format($customer->total_revenue, 2) }}</strong>
                                    @if($customer->total_shipments > 0)
                                        <br><small class="text-muted">Avg: ${{ number_format($customer->average_shipment_value, 2) }}</small>
                                    @endif
                                </td>
                                <td>
                                    <span class="badge bg-light text-dark">{{ $customer->total_shipments }}</span>
                                    @if($customer->last_shipment_date)
                                        <br><small class="text-muted">Last: {{ $customer->last_shipment_date->format('M d, Y') }}</small>
                                    @endif
                                </td>
                                <td>
                                    <span class="badge bg-{{ $customer->status == 'active' ? 'success' : ($customer->status == 'blocked' ? 'danger' : 'warning') }}">
                                        {{ ucfirst($customer->status) }}
                                    </span>
                                </td>
                                <td>
                                    <div class="btn-group">
                                        <a href="{{ route('customers.edit', $customer) }}" class="btn btn-sm btn-warning">
                                            <i class="ri-edit-line"></i> Edit
                                        </a>
                                        <a href="{{ route('customer-reports.activity', ['customer_id' => $customer->id]) }}" class="btn btn-sm btn-info">
                                            <i class="ri-history-line"></i> Activity
                                        </a>
                                        <form action="{{ route('customers.destroy', $customer) }}" method="POST" class="d-inline">
                                            @csrf 
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="8" class="text-center text-muted py-4">
                                    <i class="ri-user-search-line display-4"></i>
                                    <p class="mt-2">No customers found</p>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                @if($customers->hasPages())
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div class="text-muted">
                        Showing {{ $customers->firstItem() }} to {{ $customers->lastItem() }} of {{ $customers->total() }} entries
                    </div>
                    {{ $customers->links() }}
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.avatar-sm {
    font-size: 14px;
    font-weight: bold;
}
</style>
@endpush