// public/js/suppliers/suppliers.js
// Entrypoint: initialize SuppliersApp when DOM is ready.
(function (global) {
    document.addEventListener('DOMContentLoaded', function () {
        if (typeof SuppliersHelpers === 'undefined') {
            console.error('SuppliersHelpers not loaded. Ensure utils/helpers.js is included first.');
            return;
        }
        if (typeof SuppliersApp === 'undefined') {
            console.error('SuppliersApp (app-shell) not loaded. Ensure modules/app-shell.js is included.');
            return;
        }

        try {
            global.suppliersApp = new SuppliersApp();
            console.log('SuppliersApp started.');
        } catch (err) {
            console.error('Failed to start SuppliersApp', err);
        }
    });
})(window);
