// public/js/suppliers/modules/dashboard.js
// Small module to render dashboard stats. Attaches DashboardModule to window.

(function (global) {
    class DashboardModule {
        constructor(app) {
            this.app = app;
        }

        init() {
            // initial hydration if server injected stats JSON
            this.hydrateFromServer();
            // listen for server-provided stats refresh events
            document.addEventListener('suppliers:statsUpdated', (e) => {
                this.render(e.detail || {});
            });
        }

        hydrateFromServer() {
            const el = document.getElementById('vendor-stats-data');
            if (!el) return;
            try {
                const data = JSON.parse(el.textContent || '{}');
                this.render(data);
            } catch (err) {
                console.warn('DashboardModule: invalid stats JSON');
            }
        }

        render(data = {}) {
            // default structure
            const stats = Object.assign({
                total_service_providers: 0,
                active_service_providers: 0,
                total_routes: 0,
                pending_payments: 0
            }, data);

            // Create or update stats cards container #vendor-stats
            let container = document.getElementById('vendor-stats');
            if (!container) {
                container = document.createElement('div');
                container.id = 'vendor-stats';
                container.className = 'row mb-4';
                const main = document.querySelector('.page-content .container-fluid') || document.body;
                main.prepend(container);
            }

            container.innerHTML = `
                <div class="col-xl-3 col-md-6">
                    <div class="card vendor-stats-card">
                        <div class="card-body">
                            <p class="mb-1 text-muted">Total Providers</p>
                            <h4 data-stat="total_service_providers">${stats.total_service_providers}</h4>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6">
                    <div class="card vendor-stats-card">
                        <div class="card-body">
                            <p class="mb-1 text-muted">Active Providers</p>
                            <h4 data-stat="active_service_providers">${stats.active_service_providers}</h4>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6">
                    <div class="card vendor-stats-card">
                        <div class="card-body">
                            <p class="mb-1 text-muted">Total Routes</p>
                            <h4 data-stat="total_routes">${stats.total_routes}</h4>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6">
                    <div class="card vendor-stats-card">
                        <div class="card-body">
                            <p class="mb-1 text-muted">Pending Payments</p>
                            <h4 data-stat="pending_payments">${stats.pending_payments}</h4>
                        </div>
                    </div>
                </div>
            `;
        }
    }

    global.DashboardModule = DashboardModule;
})(window);
