class ModalManager {
    constructor(shipmentForm) {
        this.shipmentForm = shipmentForm;
    }

    init() {
        this.setupModalEventListeners();
    }

    setupModalEventListeners() {
        // Customer modal focus
        const customerModal = document.getElementById('newCustomerModal');
        if (customerModal) {
            customerModal.addEventListener('shown.bs.modal', () => {
                const nameInput = document.getElementById('new_customer_name');
                if (nameInput) nameInput.focus();
            });
        }

        // Manual rate modal
        const manualRateModal = document.getElementById('manualRateModal');
        if (manualRateModal) {
            manualRateModal.addEventListener('shown.bs.modal', () => {
                // Pre-fill modal with current values if pricing manager exists
                const pricingManager = this.shipmentForm.getModule('pricingManager');
                if (pricingManager && pricingManager.openManualRateModal) {
                    pricingManager.openManualRateModal();
                }
            });
        }

        // OTP modal
        const otpModal = document.getElementById('otpModal');
        if (otpModal) {
            otpModal.addEventListener('shown.bs.modal', () => {
                const otpInput = document.getElementById('modalOtpCode');
                if (otpInput) otpInput.focus();
            });
        }
    }

    // Method to open specific modals if needed
    openCustomerModal() {
        const modal = new bootstrap.Modal(document.getElementById('newCustomerModal'));
        modal.show();
    }

    openManualRateModal() {
        const modal = new bootstrap.Modal(document.getElementById('manualRateModal'));
        modal.show();
    }

    openOtpModal() {
        const modal = new bootstrap.Modal(document.getElementById('otpModal'));
        modal.show();
    }
}