<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CargoCategorySeeder extends Seeder
{
    public function run(): void
    {
        $categories = [
            ['code' => 'NDG', 'name' => 'Non-Dangerous Goods'],
            ['code' => 'DG', 'name' => 'Dangerous Goods'],
        ];

        foreach ($categories as $category) {
            DB::table('cargo_categories')->updateOrInsert(
                ['code' => $category['code']],
                $category
            );
        }
    }
}
