<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('shipment_routes', function (Blueprint $table) {
            $table->id();

            $table->foreignId('origin_country_id')->constrained('countries');
            $table->foreignId('destination_country_id')->constrained('countries');
            $table->foreignId('shipment_mode_id')->constrained('shipment_modes');
            $table->foreignId('cargo_category_id')->constrained('cargo_categories');
            $table->foreignId('currency_id')->constrained('currencies');

            $table->decimal('rate_per_unit', 10, 2)->nullable();
            $table->decimal('flat_rate', 10, 2)->nullable();
            $table->decimal('minimum_weight', 8, 2)->nullable();

            $table->string('unit_type');
            $table->string('weight_basis');

            $table->timestamps();
        });
    }

    public function down(): void {
        Schema::dropIfExists('shipment_routes');
    }
};
