<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('shipment_modes', function (Blueprint $table) {
            $table->id();
            $table->string('code')->unique();
            $table->string('name');
            $table->integer('volumetric_divisor')->default(6000); // default divisor
            $table->timestamps();
        });
    }

    public function down(): void {
        Schema::dropIfExists('shipment_modes');
    }
};
