<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
    Schema::create('routes', function (Blueprint $table) {
        $table->id();
        $table->foreignId('origin_country_id')->constrained('countries');
        $table->foreignId('destination_country_id')->constrained('countries');
        $table->enum('shipping_mode', ['air_consolidated', 'sea_consolidated']);
        $table->decimal('rate_per_kg', 10, 2)->nullable();
        $table->decimal('rate_per_cbm', 10, 2)->nullable();
        $table->foreignId('currency_id')->constrained('currencies');
        $table->timestamps();
    });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('routes');
    }
};
