<?php
namespace App\Services;

use App\Models\Package;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class PackageService
{
    public function __construct(
        protected FreightCalculator $freightCalculator,
        protected LabelService $labelService
    ) {}

    public function processPackage($pkg, $index, $shipment, $request): array
    {
        $volume = ($pkg['length'] * $pkg['width'] * $pkg['height']) / 1000000; // m3
        $cuft = $volume * 35.315;

        $freight = $this->freightCalculator->calculate(
            $pkg['weight'],
            $volume,
            $cuft,
            $request->route_id,
            $shipment->mode,
            $shipment->category_id
        );

        $tracking = generateTrackingNumber($shipment->origin_country_id, $index + 1);

        $package = Package::create([
            'shipment_id' => $shipment->id,
            'origin_tracking' => $pkg['origin_tracking'] ?? null,
            'length' => $pkg['length'],
            'width' => $pkg['width'],
            'height' => $pkg['height'],
            'weight' => $pkg['weight'],
            'description' => $pkg['description'],
            'tracking_no' => $tracking,
            'freight_cost' => $freight,
            'chargeable_weight' => $freight['chargeable'],
        ]);

        if (!empty($pkg['images'])) {
            foreach ($pkg['images'] as $img) {
                $path = $img->store('packages', 'public');
                $package->images()->create(['path' => $path]);
            }
        }

        $this->labelService->generate($package, $shipment->customer);

        return ['freight_cost' => $freight['total']];
    }
}