<?php
namespace App\Services;

use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Storage;

class LabelService
{
    public function generate($package, $customer)
    {
        $pdf = Pdf::loadView('labels.package', [
            'package' => $package,
            'customer' => $customer
        ]);

        $filename = $package->tracking_no . '.pdf';
        $path = 'labels/' . $filename;
        Storage::disk('public')->put($path, $pdf->output());
        $package->update(['label_path' => $path]);
    }
}