<?php
// app/Rules/ValidWeightForMode.php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class ValidWeightForMode implements Rule
{
    protected $mode;
    
    public function __construct($mode)
    {
        $this->mode = $mode;
    }
    
    public function passes($attribute, $value)
    {
        if (str_contains($this->mode, 'air') && $value > 100) {
            return false;
        }
        return true;
    }
    
    public function message()
    {
        return 'The weight exceeds maximum allowed for this shipment mode.';
    }
}