<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;

class AuthServiceProvider extends ServiceProvider
{
    protected $policies = [
        // 'App\Models\Model' => 'App\Policies\ModelPolicy',
    ];

    public function boot(): void
    {
        $this->registerPolicies();

        // Vendor Management Gates
        Gate::define('view_vendors', function ($user) {
            return $user->hasPermission('view_vendors');
        });

        Gate::define('create_vendors', function ($user) {
            return $user->hasPermission('create_vendors');
        });

        Gate::define('edit_vendors', function ($user) {
            return $user->hasPermission('edit_vendors');
        });

        Gate::define('delete_vendors', function ($user) {
            return $user->hasPermission('delete_vendors');
        });

        // Fallback to role-based permissions if permission system not available
        Gate::define('manage_vendors', function ($user) {
            return $user->hasRole('admin') || $user->hasRole('manager');
        });
    }
}