<?php

namespace App\Models\Vendors;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ServiceProviderWeightBand extends Model
{
    use HasFactory;

    protected $fillable = [
        'route_id',
        'min_weight',
        'max_weight',
        'rate'
    ];

    protected $casts = [
        'min_weight' => 'decimal:2',
        'max_weight' => 'decimal:2',
        'rate' => 'decimal:2'
    ];

    // Relationships
    public function route(): BelongsTo
    {
        return $this->belongsTo(ServiceProviderRoute::class, 'route_id');
    }
}