<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ShipmentService extends Model
{
    use HasFactory;

    protected $fillable = [
        'shipment_id',
        'service_id',
        'cost_currency_id',
        'cost_amount',
        'selling_price',
        'charge_currency_id',
    ];

    public function shipment()
    {
        return $this->belongsTo(Shipment::class);
    }

    public function service()
    {
        return $this->belongsTo(Service::class);
    }

    public function costCurrency()
    {
        return $this->belongsTo(Currency::class, 'cost_currency_id');
    }

    public function chargeCurrency()
    {
        return $this->belongsTo(Currency::class, 'charge_currency_id');
    }
}
