<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Shipment extends Model
{
    use HasFactory;

    protected $fillable = [
        'customer_id',
        'origin_country_id',
        'destination_country_id',
        'shipment_mode_id', // ✅ correct
        'package_count',
        'charge_currency_id',
    ];

    // Relationships
    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function originCountry()
    {
        return $this->belongsTo(Country::class, 'origin_country_id');
    }

    public function destinationCountry()
    {
        return $this->belongsTo(Country::class, 'destination_country_id');
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class, 'charge_currency_id');
    }

    public function packages()
    {
        return $this->hasMany(Package::class);
    }

    public function services()
    {
        return $this->hasMany(ShipmentService::class);
    }
    public function shipmentMode()
{
    return $this->belongsTo(ShipmentMode::class);
}

}
