<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Gate;

class StoreServiceProviderRequest extends FormRequest
{
    public function authorize(): bool
    {
        // Use Gate::allows instead of can() method
        return Gate::allows('create_vendors');
    }

    public function rules(): array
    {
        return [
            'name' => 'required|string|max:255',
            'type' => 'required|in:supplier,service_provider',
            'onboarding_date' => 'required|date|before_or_equal:today',
            'open_balance' => 'required|numeric|min:0|max:1000000',
            'balance_type' => 'required|in:credit,debit',
            'contact_person' => 'nullable|string|max:255',
            'email' => 'nullable|email|unique:service_providers,email',
            'phone' => 'nullable|string|max:20',
            'address' => 'nullable|string|max:500',
            'account_number' => 'nullable|string|max:50',
            'status' => 'required|in:active,inactive',
            'shipping_methods' => 'nullable|array',
            'shipping_methods.*' => 'in:air,sea,land,rail',
            'notes' => 'nullable|string|max:1000',
            'is_default' => 'sometimes|boolean',
        ];
    }

    public function messages(): array
    {
        return [
            'onboarding_date.before_or_equal' => 'The onboarding date cannot be in the future.',
            'open_balance.max' => 'The open balance cannot exceed 1,000,000.',
        ];
    }
}