<?php

namespace App\Http\Controllers\Vendors;

use App\Http\Controllers\Controller;
use App\Models\Vendors\ServiceProvider;
use Illuminate\Http\Request;

class ServiceProviderController extends Controller
{
    public function index()
    {
        $serviceProviders = ServiceProvider::all();
        return view('vendor.service-providers.index', compact('serviceProviders'));
    }

    public function show(ServiceProvider $serviceProvider)
    {
        return view('vendor.service-providers.show', compact('serviceProvider'));
    }

    public function edit(ServiceProvider $serviceProvider)
    {
        return view('vendor.service-providers.edit', compact('serviceProvider'));
    }

    public function destroy(ServiceProvider $serviceProvider)
    {
        $serviceProvider->delete();
        return redirect()->route('vendors.service-providers.index')->with('success', 'Provider deleted.');
    }
}
