<?php
use App\Models\ShipmentRoute;
use App\Models\Currency;
use Illuminate\Http\Request;

public function getRate(Request $request)
{
    $data = $request->validate([
        'origin_country_id' => 'required|integer',
        'destination_country_id' => 'required|integer',
        'mode' => 'required|string',
        'category_id' => 'required|integer',
        'chargeable_weight' => 'required|numeric',
        'input_currency' => 'nullable|string',
        'manual_rate' => 'nullable|numeric',
    ]);

    $route = ShipmentRoute::where([
        'origin_country_id' => $data['origin_country_id'],
        'destination_country_id' => $data['destination_country_id'],
        'mode' => $data['mode'],
        'category_id' => $data['category_id'],
    ])->first();

    $baseCurrency = Currency::base();

    if ($route) {
        // Calculate rate based on chargeable weight
        $freight = $data['chargeable_weight'] * $route->rate_per_unit;

        return response()->json([
            'rate' => $route->rate_per_unit,
            'unit' => $route->unit,
            'freight' => round($freight, 2),
            'currency' => $baseCurrency->code,
            'manual' => false
        ]);
    } else {
        // Manual fallback
        if (isset($data['manual_rate']) && isset($data['input_currency'])) {
            $manualCurrency = Currency::where('code', $data['input_currency'])->first();
            $freight = $data['chargeable_weight'] * $data['manual_rate'];

            // Convert to base currency
            $converted = $freight * $manualCurrency->selling_exchange_rate;

            return response()->json([
                'rate' => $data['manual_rate'],
                'unit' => 'manual',
                'freight' => round($converted, 2),
                'currency' => $baseCurrency->code,
                'manual' => true
            ]);
        }

        return response()->json([
            'error' => 'No route found and manual rate not provided.'
        ], 422);
    }
}
