@extends('layouts.app')

@section('title', 'User Details: ' . $user->name)

@section('content')
<div class="page-wrapper">
    <div class="page-content">
        <!-- Start breadcrumb -->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Users</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item"><a href="{{ route('users.index') }}">User Management</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ $user->name }}</li>
                    </ol>
                </nav>
            </div>
        </div>
        <!-- End breadcrumb -->

        <div class="row">
            <!-- Left Column: User Info -->
            <div class="col-md-4">
                <div class="card radius-10">
                    <div class="card-body text-center">
                        <div class="mb-3">
                            <img src="{{ $user->profile_image_url }}" 
                                 class="rounded-circle" width="150" height="150"
                                 onerror="this.src='{{ asset('assets/images/default-avatar.png') }}'">
                        </div>
                        <h4 class="mb-1">{{ $user->name }}</h4>
                        <p class="text-muted">{{ $user->position ?? 'No position specified' }}</p>
                        
                        <div class="d-flex justify-content-center gap-2 mb-3">
                            @foreach($user->roles as $role)
                            <span class="badge bg-{{ \App\Helpers\RoleHelper::getColor($role->name) }}">
                                <i class="bx bx-{{ \App\Helpers\RoleHelper::getIcon($role->name) }}"></i>
                                {{ ucfirst($role->name) }}
                            </span>
                            @endforeach
                        </div>

                        <div class="row mt-4">
                            <div class="col-6">
                                <div class="border rounded p-2">
                                    <h6 class="mb-0">{{ $statistics['total_sales'] ?? 0 }}</h6>
                                    <small>Sales</small>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="border rounded p-2">
                                    <h6 class="mb-0">{{ $statistics['total_purchases'] ?? 0 }}</h6>
                                    <small>Purchases</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Contact Info Card -->
                <div class="card radius-10 mt-3">
                    <div class="card-body">
                        <h6 class="mb-3 text-primary">Contact Information</h6>
                        <div class="list-group list-group-flush">
                            <div class="list-group-item d-flex align-items-center border-0">
                                <i class="bx bx-envelope me-2"></i>
                                <span>{{ $user->email }}</span>
                            </div>
                            @if($user->phone)
                            <div class="list-group-item d-flex align-items-center border-0">
                                <i class="bx bx-phone me-2"></i>
                                <span>{{ $user->phone }}</span>
                            </div>
                            @endif
                            @if($user->address)
                            <div class="list-group-item d-flex align-items-center border-0">
                                <i class="bx bx-home me-2"></i>
                                <span>{{ $user->address }}</span>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>

                <!-- User Actions Card -->
                <div class="card radius-10 mt-3">
                    <div class="card-body">
                        <h6 class="mb-3 text-primary">Actions</h6>
                        <div class="d-grid gap-2">
                            @can('edit users')
                            <a href="{{ route('users.edit', $user) }}" class="btn btn-primary">
                                <i class="bx bx-edit"></i> Edit User
                            </a>
                            @endcan
                            
                            @can('delete users')
                                @if($user->id != auth()->id())
                                <form action="{{ route('users.destroy', $user) }}" method="POST" 
                                      onsubmit="return confirm('Are you sure you want to delete this user?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger w-100">
                                        <i class="bx bx-trash"></i> Delete User
                                    </button>
                                </form>
                                @endif
                            @endcan
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Column: User Details -->
            <div class="col-md-8">
                <!-- User Details Card -->
                <div class="card radius-10">
                    <div class="card-body">
                        <h6 class="mb-3 text-primary">User Details</h6>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Employee ID</label>
                                <p class="form-control-plaintext">{{ $user->employee_id ?? 'Not assigned' }}</p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Status</label>
                                <p>
                                    <span class="badge bg-{{ $user->is_active ? 'success' : 'danger' }}">
                                        {{ $user->is_active ? 'Active' : 'Inactive' }}
                                    </span>
                                </p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Department</label>
                                <p class="form-control-plaintext">{{ $user->department ?? 'Not assigned' }}</p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Position</label>
                                <p class="form-control-plaintext">{{ $user->position ?? 'Not assigned' }}</p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Gender</label>
                                <p class="form-control-plaintext">{{ ucfirst($user->gender) ?? 'Not specified' }}</p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Date of Birth</label>
                                <p class="form-control-plaintext">{{ $user->date_of_birth ? $user->date_of_birth->format('M d, Y') : 'Not specified' }}</p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Hire Date</label>
                                <p class="form-control-plaintext">{{ $user->hire_date ? $user->hire_date->format('M d, Y') : 'Not specified' }}</p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Last Login</label>
                                <p class="form-control-plaintext">
                                    @if($user->last_login_at)
                                        {{ $user->last_login_at->format('M d, Y h:i A') }}
                                        @if($user->last_login_ip)
                                            <br><small class="text-muted">IP: {{ $user->last_login_ip }}</small>
                                        @endif
                                    @else
                                        Never logged in
                                    @endif
                                </p>
                            </div>
                            <div class="col-12 mb-3">
                                <label class="form-label">Notes</label>
                                <p class="form-control-plaintext">{{ $user->notes ?? 'No notes' }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Permissions Card -->
                <div class="card radius-10 mt-3">
                    <div class="card-body">
                        <h6 class="mb-3 text-primary">Permissions</h6>
                        <div class="row">
                            @foreach($permissions as $permission)
                            <div class="col-md-4 mb-2">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" checked disabled>
                                    <label class="form-check-label">{{ ucwords(str_replace(['-', '_'], ' ', $permission->name)) }}</label>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection