@extends('layouts.app')

@section('style')
    <style>
        .unit-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 10px;
            padding: 30px;
            margin-bottom: 30px;
        }
        .unit-badge-large {
            font-size: 1.2em;
            padding: 0.5em 1em;
        }
        .info-card {
            border-left: 4px solid #667eea;
            background: #f8f9fa;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 15px;
        }
        .conversion-box {
            background: white;
            border: 2px solid #e9ecef;
            border-radius: 10px;
            padding: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        .related-unit {
            transition: all 0.3s;
        }
        .related-unit:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .stat-card {
            text-align: center;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        .stat-card .number {
            font-size: 2.5em;
            font-weight: bold;
            line-height: 1;
        }
        .stat-card .label {
            font-size: 0.9em;
            color: #6c757d;
            margin-top: 10px;
        }
    </style>
@endsection

@section('content')
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Units</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item"><a href="{{ route('units.index') }}">Units</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ $unit->name }}</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <a href="{{ route('units.edit', $unit) }}" class="btn btn-warning">
                    <i class="bx bx-edit"></i> Edit
                </a>
                <a href="{{ route('units.index') }}" class="btn btn-outline-secondary">
                    <i class="bx bx-arrow-back"></i> Back
                </a>
            </div>
        </div>
        <!--end breadcrumb-->

        <!-- Unit Header -->
        <div class="unit-header">
            <div class="row align-items-center">
                <div class="col-md-8">
                    <h1 class="display-5 mb-2">{{ $unit->name }}</h1>
                    <div class="d-flex align-items-center gap-3 mb-3">
                        <span class="badge bg-light text-dark unit-badge-large">
                            {{ $unit->abbreviation }}
                        </span>
                        <span class="badge bg-{{ $unit->status == 'active' ? 'success' : 'danger' }} unit-badge-large">
                            {{ ucfirst($unit->status) }}
                        </span>
                        @if($unit->is_base_unit)
                            <span class="badge bg-info unit-badge-large">
                                <i class="bx bx-star"></i> Base Unit
                            </span>
                        @endif
                    </div>
                    @if($unit->description)
                        <p class="lead mb-0">{{ $unit->description }}</p>
                    @endif
                </div>
                <div class="col-md-4 text-end">
                    <div class="conversion-box">
                        <h5 class="mb-3">Conversion Rate</h5>
                        <div class="display-4 mb-2">{{ number_format($unit->conversion_rate, 4) }}</div>
                        <p class="mb-0 text-muted">
                            @if($unit->is_base_unit)
                                1 {{ $unit->abbreviation }} = 1 {{ $unit->abbreviation }}
                            @else
                                1 {{ $unit->baseUnit->abbreviation }} = {{ number_format($unit->conversion_rate, 4) }} {{ $unit->abbreviation }}
                            @endif
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Left Column: Unit Details -->
            <div class="col-md-8">
                <!-- Unit Information -->
                <div class="card mb-4">
                    <div class="card-header bg-light">
                        <h5 class="mb-0"><i class="bx bx-info-circle"></i> Unit Information</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="info-card">
                                    <h6 class="text-muted mb-2">Type</h6>
                                    <h4 class="mb-0">
                                        @if($unit->is_base_unit)
                                            <span class="badge bg-info">Base Unit</span>
                                        @else
                                            <span class="badge bg-secondary">Derived Unit</span>
                                        @endif
                                    </h4>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-card">
                                    <h6 class="text-muted mb-2">Base Unit</h6>
                                    <h4 class="mb-0">
                                        @if($unit->baseUnit)
                                            <a href="{{ route('units.show', $unit->baseUnit) }}" class="text-decoration-none">
                                                {{ $unit->baseUnit->name }} ({{ $unit->baseUnit->abbreviation }})
                                            </a>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </h4>
                                </div>
                            </div>
                        </div>
                        
                        <div class="info-card">
                            <h6 class="text-muted mb-2">Full Conversion Formula</h6>
                            <div class="display-6 text-center">
                                @if($unit->is_base_unit)
                                    1 {{ $unit->abbreviation }} ≡ 1 {{ $unit->abbreviation }}
                                @else
                                    1 {{ $unit->baseUnit->abbreviation }} = {{ number_format($unit->conversion_rate, 4) }} {{ $unit->abbreviation }}
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Related Units -->
                @if($relatedUnits->count() > 0)
                    <div class="card mb-4">
                        <div class="card-header bg-light">
                            <h5 class="mb-0"><i class="bx bx-layer"></i> Related Units</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                @foreach($relatedUnits as $relatedUnit)
                                    <div class="col-md-6 mb-3">
                                        <div class="card related-unit">
                                            <div class="card-body">
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <h6 class="mb-1">{{ $relatedUnit->name }}</h6>
                                                        <small class="text-muted">{{ $relatedUnit->abbreviation }}</small>
                                                    </div>
                                                    <div class="text-end">
                                                        <div class="badge bg-secondary">
                                                            {{ number_format($relatedUnit->conversion_rate, 4) }}
                                                        </div>
                                                        <br>
                                                        <small class="text-muted">
                                                            1 {{ $unit->abbreviation }} = {{ number_format(1/$relatedUnit->conversion_rate, 4) }} {{ $relatedUnit->abbreviation }}
                                                        </small>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-footer bg-transparent">
                                                <a href="{{ route('units.show', $relatedUnit) }}" class="btn btn-sm btn-outline-primary">
                                                    <i class="bx bx-show"></i> View
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                @endif

                <!-- Products using this unit -->
                @if($unit->products->count() > 0)
                    <div class="card">
                        <div class="card-header bg-light">
                            <h5 class="mb-0"><i class="bx bx-package"></i> Products using this Unit</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Product</th>
                                            <th>SKU</th>
                                            <th>Stock</th>
                                            <th>Price</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($unit->products as $product)
                                            <tr>
                                                <td>
                                                    <a href="{{ route('products.show', $product) }}" class="text-decoration-none">
                                                        {{ $product->name }}
                                                    </a>
                                                </td>
                                                <td>{{ $product->sku }}</td>
                                                <td>
                                                    <span class="badge bg-{{ $product->stock > 0 ? 'success' : 'danger' }}">
                                                        {{ $product->stock }}
                                                    </span>
                                                </td>
                                                <td>${{ number_format($product->sale_price, 2) }}</td>
                                                <td>
                                                    <span class="badge bg-{{ $product->status == 'active' ? 'success' : 'danger' }}">
                                                        {{ ucfirst($product->status) }}
                                                    </span>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            @if($unit->products->count() > 10)
                                <div class="text-center mt-3">
                                    <a href="{{ route('products.index', ['unit_id' => $unit->id]) }}" class="btn btn-outline-primary">
                                        View All {{ $unit->products->count() }} Products
                                    </a>
                                </div>
                            @endif
                        </div>
                    </div>
                @endif
            </div>

            <!-- Right Column: Statistics & Actions -->
            <div class="col-md-4">
                <!-- Statistics -->
                <div class="card mb-4">
                    <div class="card-header bg-light">
                        <h5 class="mb-0"><i class="bx bx-stats"></i> Statistics</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-6 mb-3">
                                <div class="stat-card bg-primary bg-opacity-10">
                                    <div class="number text-primary">{{ $unit->products->count() }}</div>
                                    <div class="label">Products</div>
                                </div>
                            </div>
                            <div class="col-6 mb-3">
                                <div class="stat-card bg-success bg-opacity-10">
                                    <div class="number text-success">
                                        {{ $unit->products->where('status', 'active')->count() }}
                                    </div>
                                    <div class="label">Active Products</div>
                                </div>
                            </div>
                        </div>
                        @if(!$unit->is_base_unit)
                            <div class="info-card">
                                <h6 class="text-muted mb-2">Inverse Conversion</h6>
                                <h4 class="mb-0">
                                    1 {{ $unit->abbreviation }} = {{ number_format(1/$unit->conversion_rate, 6) }} {{ $unit->baseUnit->abbreviation }}
                                </h4>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Unit Actions -->
                <div class="card mb-4">
                    <div class="card-header bg-light">
                        <h5 class="mb-0"><i class="bx bx-cog"></i> Quick Actions</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <a href="{{ route('units.edit', $unit) }}" class="btn btn-warning">
                                <i class="bx bx-edit"></i> Edit Unit
                            </a>
                            <a href="{{ route('units.index') }}" class="btn btn-outline-secondary">
                                <i class="bx bx-list-ul"></i> View All Units
                            </a>
                            <button type="button" class="btn btn-outline-danger" 
                                    onclick="deleteUnit({{ $unit->id }}, '{{ $unit->name }}')">
                                <i class="bx bx-trash"></i> Delete Unit
                            </button>
                        </div>
                    </div>
                </div>

                <!-- System Information -->
                <div class="card">
                    <div class="card-header bg-light">
                        <h5 class="mb-0"><i class="bx bx-time"></i> System Information</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <small class="text-muted">Created</small>
                            <div>{{ $unit->created_at->format('M d, Y H:i') }}</div>
                        </div>
                        <div class="mb-3">
                            <small class="text-muted">Last Updated</small>
                            <div>{{ $unit->updated_at->format('M d, Y H:i') }}</div>
                        </div>
                        @if($unit->deleted_at)
                            <div class="alert alert-warning">
                                <i class="bx bx-error"></i>
                                <small>This unit was deleted on {{ $unit->deleted_at->format('M d, Y') }}</small>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Script -->
<script>
function deleteUnit(id, name) {
    Swal.fire({
        title: 'Delete Unit?',
        html: `Are you sure you want to delete <strong>${name}</strong>?`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: `/units/${id}`,
                type: 'DELETE',
                data: {
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    Swal.fire('Deleted!', response.message || 'Unit deleted successfully.', 'success')
                        .then(() => {
                            window.location.href = '{{ route('units.index') }}';
                        });
                },
                error: function(xhr) {
                    Swal.fire('Error!', xhr.responseJSON?.message || 'Failed to delete unit.', 'error');
                }
            });
        }
    });
}
</script>
@endsection