{{-- resources/views/taxes/index.blade.php --}}
@extends('layouts.app')

@section('content')
<div class="page-wrapper">
    <div class="page-content">
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">
                <i class="bx bx-percent"></i> Tax/VAT Rates
            </div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">Tax Rates</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <a href="{{ route('taxes.create') }}" class="btn btn-primary">
                    <i class="bx bx-plus"></i> Add Tax Rate
                </a>
            </div>
        </div>

        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Tax Name</th>
                                <th>Code</th>
                                <th class="text-end">Rate (%)</th>
                                <th>Status</th>
                                <th>Default</th>
                                <th>Description</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($taxes as $tax)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>
                                    <strong>{{ $tax->name }}</strong>
                                </td>
                                <td>
                                    <code>{{ $tax->code }}</code>
                                </td>
                                <td class="text-end">
                                    <span class="badge bg-primary">{{ $tax->rate }}%</span>
                                </td>
                                <td>
                                    <span class="badge bg-{{ $tax->is_active ? 'success' : 'danger' }}">
                                        {{ $tax->is_active ? 'Active' : 'Inactive' }}
                                    </span>
                                </td>
                                <td>
                                    @if($tax->is_default)
                                        <span class="badge bg-warning">Default</span>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>
                                    <small class="text-muted">{{ $tax->description ?? 'No description' }}</small>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <a href="{{ route('taxes.edit', $tax) }}" class="btn btn-outline-primary">
                                            <i class="bx bx-edit"></i>
                                        </a>
                                        @if(!$tax->is_default)
                                            <button class="btn btn-outline-success" 
                                                    onclick="setDefaultTax({{ $tax->id }})"
                                                    title="Set as Default">
                                                <i class="bx bx-star"></i>
                                            </button>
                                        @endif
                                        <button class="btn btn-outline-{{ $tax->is_active ? 'warning' : 'success' }}"
                                                onclick="toggleTaxStatus({{ $tax->id }})"
                                                title="{{ $tax->is_active ? 'Deactivate' : 'Activate' }}">
                                            <i class="bx bx-{{ $tax->is_active ? 'x' : 'check' }}"></i>
                                        </button>
                                        @if(!$tax->is_default)
                                            <button class="btn btn-outline-danger" 
                                                    onclick="deleteTax({{ $tax->id }})"
                                                    title="Delete">
                                                <i class="bx bx-trash"></i>
                                            </button>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script>
function setDefaultTax(taxId) {
    if (confirm('Set this as the default tax rate for new products?')) {
        $.ajax({
            url: `/taxes/${taxId}/set-default`,
            method: 'POST',
            data: {
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                toastr.success(response.message || 'Default tax rate updated.');
                setTimeout(() => location.reload(), 1500);
            },
            error: function() {
                toastr.error('Failed to set default tax rate.');
            }
        });
    }
}

function toggleTaxStatus(taxId) {
    $.ajax({
        url: `/taxes/${taxId}/toggle-status`,
        method: 'POST',
        data: {
            _token: '{{ csrf_token() }}'
        },
        success: function(response) {
            toastr.success(response.message || 'Tax status updated.');
            setTimeout(() => location.reload(), 1500);
        },
        error: function() {
            toastr.error('Failed to update tax status.');
        }
    });
}

function deleteTax(taxId) {
    if (confirm('Are you sure you want to delete this tax rate? This action cannot be undone.')) {
        $.ajax({
            url: `/taxes/${taxId}`,
            method: 'DELETE',
            data: {
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                toastr.success(response.message || 'Tax rate deleted.');
                setTimeout(() => location.reload(), 1500);
            },
            error: function() {
                toastr.error('Failed to delete tax rate.');
            }
        });
    }
}
</script>
@endsection