@extends('layouts.app')

@section('style')
    <style>
        .supplier-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            border-radius: 10px;
            margin-bottom: 30px;
        }
        .stat-card {
            background: white;
            border-radius: 10px;
            padding: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .info-label {
            color: #6c757d;
            font-size: 0.875rem;
            margin-bottom: 5px;
        }
        .info-value {
            font-size: 1rem;
            font-weight: 500;
            color: #495057;
        }
        .timeline {
            position: relative;
            padding-left: 20px;
        }
        .timeline-item {
            position: relative;
            padding-bottom: 20px;
            padding-left: 30px;
        }
        .timeline-marker {
            position: absolute;
            left: 0;
            top: 0;
            width: 12px;
            height: 12px;
            border-radius: 50%;
            background: #dee2e6;
        }
        .timeline-content {
            padding-top: 3px;
        }
        .timeline-marker.bg-success { background: #28a745 !important; }
        .timeline-marker.bg-info { background: #17a2b8 !important; }
    </style>
@endsection

@section('content')
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Suppliers</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item"><a href="{{ route('suppliers.index') }}">Suppliers</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ $supplier->name }}</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                    <a href="{{ route('suppliers.edit', $supplier) }}" class="btn btn-primary">
                        <i class="bx bx-edit"></i> Edit
                    </a>
                    <button type="button" class="btn btn-primary split-bg-primary dropdown-toggle dropdown-toggle-split" 
                            data-bs-toggle="dropdown">
                        <span class="visually-hidden">Toggle Dropdown</span>
                    </button>
                    <div class="dropdown-menu dropdown-menu-right dropdown-menu-lg-end">
                        <a class="dropdown-item" href="{{ route('purchases.create') }}?supplier_id={{ $supplier->id }}">
                            <i class="bx bx-cart-add"></i> New Purchase
                        </a>
                        <a class="dropdown-item" href="mailto:{{ $supplier->email }}">
                            <i class="bx bx-envelope"></i> Send Email
                        </a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item text-danger" href="#" onclick="confirmDelete()">
                            <i class="bx bx-trash"></i> Delete Supplier
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <!--end breadcrumb-->

        @if(session('success'))
            <div class="alert alert-success border-0 bg-success alert-dismissible fade show py-2">
                <div class="d-flex align-items-center">
                    <div class="font-35 text-white">
                        <i class="bx bxs-check-circle"></i>
                    </div>
                    <div class="ms-3">
                        <h6 class="mb-0 text-white">Success</h6>
                        <div class="text-white">{{ session('success') }}</div>
                    </div>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        @if(session('error'))
            <div class="alert alert-danger border-0 bg-danger alert-dismissible fade show py-2">
                <div class="d-flex align-items-center">
                    <div class="font-35 text-white">
                        <i class="bx bxs-message-square-x"></i>
                    </div>
                    <div class="ms-3">
                        <h6 class="mb-0 text-white">Error</h6>
                        <div class="text-white">{{ session('error') }}</div>
                    </div>
                </div>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        <!-- Supplier Header -->
        <div class="supplier-header">
            <div class="row align-items-center">
                <div class="col-auto">
                    <div class="avatar avatar-xl">
                        <img src="https://ui-avatars.com/api/?name={{ urlencode($supplier->name) }}&background=fff&color=667eea&size=128" 
                             alt="{{ $supplier->name }}" class="rounded-circle">
                    </div>
                </div>
                <div class="col">
                    <h2 class="mb-1">{{ $supplier->name }}</h2>
                    <p class="mb-2 opacity-75">
                        <i class="bx bx-envelope"></i> {{ $supplier->email ?? 'No email' }}
                        <span class="mx-2">|</span>
                        <i class="bx bx-phone"></i> {{ $supplier->phone ?? 'No phone' }}
                    </p>
                    <div>
                        @if($supplier->status == 'active')
                            <span class="badge bg-success">
                                <i class="bx bx-check-circle"></i> Active
                            </span>
                        @else
                            <span class="badge bg-secondary">
                                <i class="bx bx-time"></i> Inactive
                            </span>
                        @endif
                        <span class="badge bg-info ms-2">
                            {{ $supplier->purchases_count ?? 0 }} Purchases
                        </span>
                    </div>
                </div>
                <div class="col-auto">
                    <div class="btn-group">
                        <button type="button" class="btn btn-light" onclick="window.print()">
                            <i class="bx bx-printer"></i> Print
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Left Column: Supplier Details -->
            <div class="col-md-8">
                <div class="row">
                    <!-- Statistics Cards -->
                    <div class="col-md-4">
                        <div class="stat-card">
                            <div class="info-label">Total Purchases</div>
                            <div class="info-value h4">{{ $purchaseStats['total_purchases'] }}</div>
                            <small class="text-muted">All time orders</small>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="stat-card">
                            <div class="info-label">Total Spent</div>
                            <div class="info-value h4">${{ number_format($purchaseStats['total_spent'], 2) }}</div>
                            <small class="text-muted">Lifetime value</small>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="stat-card">
                            <div class="info-label">Avg Order Value</div>
                            <div class="info-value h4">${{ number_format($purchaseStats['avg_order_value'], 2) }}</div>
                            <small class="text-muted">Per purchase</small>
                        </div>
                    </div>

                    <!-- Supplier Information -->
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title mb-4">Supplier Information</h5>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="info-label">Contact Person</label>
                                        <p class="info-value">{{ $supplier->contact_person ?? 'Not specified' }}</p>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="info-label">Payment Terms</label>
                                        <p class="info-value">{{ $supplier->payment_terms ?? 'Not specified' }}</p>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="info-label">Tax ID</label>
                                        <p class="info-value">{{ $supplier->tax_id ?? 'Not specified' }}</p>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="info-label">Website</label>
                                        <p class="info-value">
                                            @if($supplier->website)
                                                <a href="{{ $supplier->website }}" target="_blank">
                                                    {{ $supplier->website }}
                                                </a>
                                            @else
                                                Not specified
                                            @endif
                                        </p>
                                    </div>
                                    <div class="col-12 mb-3">
                                        <label class="info-label">Address</label>
                                        <p class="info-value">{{ $supplier->address ?? 'Not specified' }}</p>
                                    </div>
                                    <div class="col-12">
                                        <label class="info-label">Notes</label>
                                        <p class="info-value">
                                            @if($supplier->notes)
                                                {{ $supplier->notes }}
                                            @else
                                                No additional notes
                                            @endif
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Recent Purchases -->
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <h5 class="card-title mb-0">Recent Purchases</h5>
                                    <a href="{{ route('purchases.create') }}?supplier_id={{ $supplier->id }}" 
                                       class="btn btn-sm btn-primary">
                                        <i class="bx bx-plus"></i> New Purchase
                                    </a>
                                </div>
                                
                                @if($purchases->count() > 0)
                                    <div class="table-responsive">
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Invoice #</th>
                                                    <th>Date</th>
                                                    <th>Total</th>
                                                    <th>Tax</th>
                                                    <th>Grand Total</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($purchases as $purchase)
                                                <tr>
                                                    <td>
                                                        <strong>#{{ $purchase->invoice_no ?? 'N/A' }}</strong>
                                                    </td>
                                                    <td>{{ $purchase->created_at->format('M d, Y') }}</td>
                                                    <td>${{ number_format($purchase->total, 2) }}</td>
                                                    <td>${{ number_format($purchase->tax_total, 2) }}</td>
                                                    <td><strong>${{ number_format($purchase->grand_total, 2) }}</strong></td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                    
                                    <!-- Pagination -->
                                    <div class="d-flex justify-content-center mt-3">
                                        {{ $purchases->links() }}
                                    </div>
                                @else
                                    <div class="text-center py-5">
                                        <div class="mb-3">
                                            <i class="bx bx-cart bx-lg text-muted"></i>
                                        </div>
                                        <h5 class="text-muted">No purchases found</h5>
                                        <p class="text-muted mb-4">This supplier hasn't made any purchases yet.</p>
                                        <a href="{{ route('purchases.create') }}?supplier_id={{ $supplier->id }}" 
                                           class="btn btn-primary">
                                            <i class="bx bx-cart-add"></i> Create First Purchase
                                        </a>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Column: Timeline & Activity -->
            <div class="col-md-4">
                <!-- Timeline -->
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title mb-4">Activity Timeline</h5>
                        <div class="timeline">
                            <div class="timeline-item">
                                <div class="timeline-marker"></div>
                                <div class="timeline-content">
                                    <h6 class="mb-1">Supplier Created</h6>
                                    <p class="text-muted mb-0">{{ $supplier->created_at->format('M d, Y \a\t h:i A') }}</p>
                                </div>
                            </div>
                            @if($purchaseStats['last_purchase'])
                            <div class="timeline-item">
                                <div class="timeline-marker bg-success"></div>
                                <div class="timeline-content">
                                    <h6 class="mb-1">Last Purchase</h6>
                                    <p class="text-muted mb-0">{{ $purchaseStats['last_purchase'] }}</p>
                                </div>
                            </div>
                            @endif
                            <div class="timeline-item">
                                <div class="timeline-marker bg-info"></div>
                                <div class="timeline-content">
                                    <h6 class="mb-1">Last Updated</h6>
                                    <p class="text-muted mb-0">{{ $supplier->updated_at->format('M d, Y \a\t h:i A') }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title mb-4">Quick Actions</h5>
                        <div class="d-grid gap-2">
                            <a href="mailto:{{ $supplier->email }}" class="btn btn-outline-primary">
                                <i class="bx bx-envelope"></i> Send Email
                            </a>
                            <a href="tel:{{ $supplier->phone }}" class="btn btn-outline-success">
                                <i class="bx bx-phone"></i> Call Supplier
                            </a>
                            <a href="{{ route('suppliers.edit', $supplier) }}" class="btn btn-outline-warning">
                                <i class="bx bx-edit"></i> Edit Details
                            </a>
                            <button type="button" class="btn btn-outline-danger" onclick="confirmDelete()">
                                <i class="bx bx-trash"></i> Delete Supplier
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Hidden Delete Form -->
<form action="{{ route('suppliers.destroy', $supplier) }}" method="POST" id="deleteForm" style="display: none;">
    @csrf
    @method('DELETE')
</form>
@endsection

@section('script')
<script src="{{ asset('assets/plugins/sweetalert/sweetalert2.min.js') }}"></script>
<script>
    function confirmDelete() {
        Swal.fire({
            title: 'Delete Supplier?',
            html: `Are you sure you want to delete <strong>{{ $supplier->name }}</strong>?<br>This action cannot be undone!`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                // Show loading
                Swal.fire({
                    title: 'Deleting...',
                    text: 'Please wait while we delete the supplier.',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });
                
                // Submit the form
                document.getElementById('deleteForm').submit();
            }
        });
    }

    $(document).ready(function() {
        // Initialize tooltips
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
    });
</script>
@endsection