@extends('layouts.app')

@section('style')
    <!-- SweetAlert2 CDN -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <link href="{{ asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css') }}" rel="stylesheet" />
    <style>
        .supplier-card {
            transition: transform 0.2s;
        }
        .supplier-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .status-badge {
            font-size: 0.75rem;
            padding: 0.25rem 0.5rem;
        }
        .delete-form {
            display: inline;
        }
        /* Style for delete button when SweetAlert is not available */
        .delete-btn-confirm {
            cursor: pointer;
        }
    </style>
@endsection

@section('content')
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Suppliers</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">Suppliers</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                    <a href="{{ route('suppliers.create') }}" class="btn btn-primary">
                        <i class="bx bx-plus"></i> Add New Supplier
                    </a>
                    <button type="button" class="btn btn-primary split-bg-primary dropdown-toggle dropdown-toggle-split" 
                            data-bs-toggle="dropdown">
                        <span class="visually-hidden">Toggle Dropdown</span>
                    </button>
                    <div class="dropdown-menu dropdown-menu-right dropdown-menu-lg-end">
                        <a class="dropdown-item" href="{{ route('suppliers.export') }}">
                            <i class="bx bx-download"></i> Export to CSV
                        </a>
                        <a class="dropdown-item" href="#" id="bulkDeleteBtn">
                            <i class="bx bx-trash"></i> Bulk Delete
                        </a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item" href="#">
                            <i class="bx bx-printer"></i> Print List
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <!--end breadcrumb-->

        <!-- Statistics Cards -->
        <div class="row row-cols-1 row-cols-md-3 row-cols-xl-3 mb-4">
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-info">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Total Suppliers</p>
                                <h4 class="my-1 text-info">{{ $stats['total'] ?? 0 }}</h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-scooter text-white ms-auto">
                                <i class='bx bxs-group'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-success">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">Active Suppliers</p>
                                <h4 class="my-1 text-success">{{ $stats['with_purchases'] ?? 0 }}</h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-ohhappiness text-white ms-auto">
                                <i class='bx bxs-check-circle'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col">
                <div class="card radius-10 border-start border-0 border-3 border-warning">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div>
                                <p class="mb-0 text-secondary">New This Month</p>
                                <h4 class="my-1 text-warning">{{ $stats['active_this_month'] ?? 0 }}</h4>
                            </div>
                            <div class="widgets-icons-2 rounded-circle bg-gradient-burning text-white ms-auto">
                                <i class='bx bxs-bar-chart-alt-2'></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Search and Filter -->
        <div class="card mb-4">
            <div class="card-body">
                <form method="GET" action="{{ route('suppliers.index') }}" id="searchForm">
                    <div class="row g-3">
                        <div class="col-md-4">
                            <div class="input-group">
                                <input type="text" class="form-control" name="search" 
                                       placeholder="Search suppliers..." 
                                       value="{{ request('search') }}">
                                <button class="btn btn-outline-secondary" type="submit">
                                    <i class="bx bx-search"></i>
                                </button>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <select class="form-select" name="filter" onchange="document.getElementById('searchForm').submit()">
                                <option value="">All Suppliers</option>
                                <option value="active" {{ request('filter') == 'active' ? 'selected' : '' }}>
                                    With Purchases
                                </option>
                                <option value="inactive" {{ request('filter') == 'inactive' ? 'selected' : '' }}>
                                    No Purchases
                                </option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <select class="form-select" name="sort_by" onchange="document.getElementById('searchForm').submit()">
                                <option value="created_at" {{ request('sort_by') == 'created_at' ? 'selected' : '' }}>
                                    Sort by Date
                                </option>
                                <option value="name" {{ request('sort_by') == 'name' ? 'selected' : '' }}>
                                    Sort by Name
                                </option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <a href="{{ route('suppliers.index') }}" class="btn btn-outline-secondary w-100">
                                <i class="bx bx-refresh"></i> Reset
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Main Content -->
        <div class="card">
            <div class="card-body">
                @if(session('success'))
                    <div class="alert alert-success border-0 bg-success alert-dismissible fade show py-2">
                        <div class="d-flex align-items-center">
                            <div class="font-35 text-white">
                                <i class="bx bxs-check-circle"></i>
                            </div>
                            <div class="ms-3">
                                <h6 class="mb-0 text-white">Success</h6>
                                <div class="text-white">{{ session('success') }}</div>
                            </div>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                @if(session('error'))
                    <div class="alert alert-danger border-0 bg-danger alert-dismissible fade show py-2">
                        <div class="d-flex align-items-center">
                            <div class="font-35 text-white">
                                <i class="bx bxs-message-square-x"></i>
                            </div>
                            <div class="ms-3">
                                <h6 class="mb-0 text-white">Error</h6>
                                <div class="text-white">{{ session('error') }}</div>
                            </div>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                @if($errors->any())
                    <div class="alert alert-danger border-0 bg-danger alert-dismissible fade show py-2">
                        <div class="d-flex align-items-center">
                            <div class="font-35 text-white">
                                <i class="bx bxs-error"></i>
                            </div>
                            <div class="ms-3">
                                <h6 class="mb-0 text-white">Validation Errors</h6>
                                <ul class="text-white mb-0">
                                    @foreach($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                @if($suppliers->count() > 0)
                    <div class="table-responsive">
                        <table id="suppliersTable" class="table table-striped table-bordered" style="width:100%">
                            <thead class="table-light">
                                <tr>
                                    <th width="50">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="selectAll">
                                        </div>
                                    </th>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Contact</th>
                                    <th>Phone</th>
                                    <th>Purchases</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($suppliers as $supplier)
                                <tr>
                                    <td>
                                        <div class="form-check">
                                            <input class="form-check-input select-item" type="checkbox" 
                                                   value="{{ $supplier->id }}"
                                                   @if($supplier->purchases_count > 0) disabled @endif>
                                        </div>
                                    </td>
                                    <td>#{{ str_pad($supplier->id, 5, '0', STR_PAD_LEFT) }}</td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="recent-product-img">
                                                <img src="https://ui-avatars.com/api/?name={{ urlencode($supplier->name) }}&background=random" alt="" width="32">
                                            </div>
                                            <div class="ms-2">
                                                <h6 class="mb-1 font-14">{{ $supplier->name }}</h6>
                                                <p class="mb-0 font-12 text-muted">{{ $supplier->email ?? 'No email' }}</p>
                                            </div>
                                        </div>
                                    </td>
                                    <td>{{ $supplier->contact_person ?? 'N/A' }}</td>
                                    <td>{{ $supplier->phone ?? 'N/A' }}</td>
                                    <td>
                                        <span class="badge bg-light-info text-info">
                                            {{ $supplier->purchases_count ?? 0 }} orders
                                        </span>
                                    </td>
                                    <td>
                                        @if($supplier->is_active)
                                            <span class="badge bg-light-success text-success status-badge">
                                                <i class="bx bx-check-circle"></i> Active
                                            </span>
                                        @else
                                            <span class="badge bg-light-secondary text-secondary status-badge">
                                                <i class="bx bx-time"></i> Inactive
                                            </span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="d-flex order-actions">
                                            <a href="{{ route('suppliers.show', $supplier) }}" 
                                            class="btn btn-sm btn-outline-info" 
                                            data-bs-toggle="tooltip" 
                                            title="View Details">
                                                <i class="bx bx-show"></i>
                                            </a>
                                            <a href="{{ route('suppliers.edit', $supplier) }}" 
                                            class="btn btn-sm btn-outline-primary ms-2"
                                            data-bs-toggle="tooltip"
                                            title="Edit">
                                                <i class="bx bx-edit"></i>
                                            </a>
                                            @if(route('purchases.create'))
                                            <a href="{{ route('purchases.create') }}?supplier_id={{ $supplier->id }}" 
                                            class="btn btn-sm btn-outline-success ms-2"
                                            data-bs-toggle="tooltip"
                                            title="New Purchase">
                                                <i class="bx bx-cart-add"></i>
                                            </a>
                                            @endif
                                            <!-- Delete Button with multiple fallback options -->
                                            <form action="{{ route('suppliers.destroy', $supplier) }}" 
                                                method="POST" 
                                                class="delete-form ms-2">
                                                @csrf
                                                @method('DELETE')
                                                <button type="button" 
                                                        class="btn btn-sm btn-outline-danger delete-btn-confirm"
                                                        data-bs-toggle="tooltip"
                                                        title="Delete"
                                                        data-supplier-id="{{ $supplier->id }}"
                                                        data-supplier-name="{{ $supplier->name }}">
                                                    <i class="bx bx-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Pagination -->
                    <div class="d-flex justify-content-between align-items-center mt-3">
                        <div>
                            Showing {{ $suppliers->firstItem() }} to {{ $suppliers->lastItem() }} 
                            of {{ $suppliers->total() }} entries
                        </div>
                        <div>
                            {{ $suppliers->links() }}
                        </div>
                    </div>
                @else
                    <div class="text-center py-5">
                        <div class="mb-3">
                            <i class="bx bx-truck bx-lg text-muted"></i>
                        </div>
                        <h5 class="text-muted">No suppliers found</h5>
                        <p class="text-muted mb-4">
                            @if(request()->has('search') || request()->has('filter'))
                                Try changing your search criteria
                            @else
                                Get started by adding your first supplier
                            @endif
                        </p>
                        <a href="{{ route('suppliers.create') }}" class="btn btn-primary">
                            <i class="bx bx-plus"></i> Add New Supplier
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
    <script src="{{ asset('assets/plugins/datatable/js/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js') }}"></script>
    <!-- SweetAlert2 CDN with fallback -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        // Check if SweetAlert2 is loaded, fallback to browser confirm
        function showConfirmation(options) {
            if (typeof Swal !== 'undefined' && Swal.fire) {
                return Swal.fire(options);
            } else {
                // Fallback to browser's native confirm
                const confirmed = confirm(options.text || 'Are you sure?');
                if (confirmed) {
                    return Promise.resolve({ isConfirmed: true });
                } else {
                    return Promise.resolve({ isConfirmed: false });
                }
            }
        }

        $(document).ready(function() {
            // Initialize DataTable
            $('#suppliersTable').DataTable({
                paging: false,
                searching: false,
                info: false,
                order: [],
                columnDefs: [
                    { orderable: false, targets: [0, 7] }
                ],
                language: {
                    emptyTable: "No suppliers found"
                }
            });

            // Initialize tooltips
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });

            // Select all functionality
            $('#selectAll').change(function() {
                $('.select-item:not(:disabled)').prop('checked', this.checked);
            });

            // Delete confirmation for individual suppliers
            $('.delete-btn-confirm').click(function(e) {
                e.preventDefault();
                var supplierId = $(this).data('supplier-id');
                var supplierName = $(this).data('supplier-name');
                var form = $(this).closest('form');
                
                showConfirmation({
                    title: 'Delete Supplier?',
                    html: `Are you sure you want to delete <strong>${supplierName}</strong>?<br>This action cannot be undone!`,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Yes, delete it!',
                    cancelButtonText: 'Cancel'
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Add loading state
                        $(this).html('<i class="bx bx-loader bx-spin"></i>');
                        $(this).prop('disabled', true);
                        
                        form.submit();
                    }
                });
            });

            // Bulk delete
            $('#bulkDeleteBtn').click(function(e) {
                e.preventDefault();
                var selectedIds = [];
                $('.select-item:checked:not(:disabled)').each(function() {
                    selectedIds.push($(this).val());
                });
                
                if (selectedIds.length === 0) {
                    showConfirmation({
                        title: 'No Selection',
                        text: 'Please select at least one supplier to delete.',
                        icon: 'warning',
                        confirmButtonColor: '#3085d6',
                    });
                    return;
                }
                
                showConfirmation({
                    title: 'Delete Selected Suppliers?',
                    html: `You are about to delete <strong>${selectedIds.length}</strong> supplier(s).<br>This action cannot be undone!`,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Yes, delete them!',
                    cancelButtonText: 'Cancel'
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Show loading if SweetAlert is available
                        if (typeof Swal !== 'undefined' && Swal.fire) {
                            Swal.fire({
                                title: 'Processing...',
                                text: 'Please wait while we delete the suppliers.',
                                allowOutsideClick: false,
                                didOpen: () => {
                                    Swal.showLoading();
                                }
                            });
                        }
                        
                        $.ajax({
                            url: '{{ route("suppliers.bulk-delete") }}',
                            type: 'POST',
                            data: {
                                _token: '{{ csrf_token() }}',
                                ids: selectedIds
                            },
                            success: function(response) {
                                if (typeof Swal !== 'undefined' && Swal.fire) {
                                    Swal.close();
                                }
                                if (response.success) {
                                    showConfirmation({
                                        title: 'Deleted!',
                                        text: response.message,
                                        icon: 'success',
                                        confirmButtonColor: '#3085d6',
                                    }).then(() => {
                                        location.reload();
                                    });
                                } else {
                                    showConfirmation({
                                        title: 'Error!',
                                        text: response.message,
                                        icon: 'error',
                                        confirmButtonColor: '#3085d6',
                                    });
                                }
                            },
                            error: function(xhr) {
                                if (typeof Swal !== 'undefined' && Swal.fire) {
                                    Swal.close();
                                }
                                let message = 'An error occurred while deleting suppliers.';
                                if (xhr.responseJSON && xhr.responseJSON.message) {
                                    message = xhr.responseJSON.message;
                                }
                                showConfirmation({
                                    title: 'Error!',
                                    text: message,
                                    icon: 'error',
                                    confirmButtonColor: '#3085d6',
                                });
                            }
                        });
                    }
                });
            });

            // Quick search with debounce
            var searchTimer;
            $('input[name="search"]').on('keyup', function() {
                clearTimeout(searchTimer);
                searchTimer = setTimeout(function() {
                    $('#searchForm').submit();
                }, 500);
            });
        });
    </script>
@endsection