@extends('layouts.app')

@section('title', 'System Information')

@section('content')
<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Settings</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('settings.index') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">System Information</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <button type="button" class="btn btn-primary" onclick="window.location.reload()">
                    <i class="bx bx-refresh mr-1"></i>Refresh
                </button>
            </div>
        </div>
        <!--end breadcrumb-->

        <!-- System Information Cards -->
        <div class="row row-cols-1 row-cols-lg-2 g-3 mb-4">
            <!-- PHP Information -->
            <div class="col">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-3">
                            <div class="bg-primary bg-gradient p-3 rounded me-3">
                                <i class="bx bxl-php text-white" style="font-size: 1.5rem;"></i>
                            </div>
                            <div>
                                <h5 class="mb-0">PHP Configuration</h5>
                                <p class="text-muted mb-0">Server & PHP Settings</p>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-borderless table-sm mb-0">
                                <tbody>
                                    <tr>
                                        <td width="50%"><strong>PHP Version</strong></td>
                                        <td class="text-end"><code>{{ phpversion() }}</code></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Server Software</strong></td>
                                        <td class="text-end">{{ $_SERVER['SERVER_SOFTWARE'] ?? 'N/A' }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Max Execution Time</strong></td>
                                        <td class="text-end">{{ ini_get('max_execution_time') }}s</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Memory Limit</strong></td>
                                        <td class="text-end">{{ ini_get('memory_limit') }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Upload Max Filesize</strong></td>
                                        <td class="text-end">{{ ini_get('upload_max_filesize') }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>PHP SAPI</strong></td>
                                        <td class="text-end">{{ php_sapi_name() }}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Laravel Information -->
            <div class="col">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-3">
                            <div class="bg-danger bg-gradient p-3 rounded me-3">
                                <i class="bx bxl-laravel text-white" style="font-size: 1.5rem;"></i>
                            </div>
                            <div>
                                <h5 class="mb-0">Laravel Configuration</h5>
                                <p class="text-muted mb-0">Framework Settings</p>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-borderless table-sm mb-0">
                                <tbody>
                                    <tr>
                                        <td width="50%"><strong>Laravel Version</strong></td>
                                        <td class="text-end"><code>{{ app()->version() }}</code></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Environment</strong></td>
                                        <td class="text-end">
                                            <span class="badge bg-{{ app()->environment('production') ? 'success' : 'warning' }}">
                                                {{ app()->environment() }}
                                            </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><strong>Debug Mode</strong></td>
                                        <td class="text-end">
                                            <span class="badge bg-{{ config('app.debug') ? 'danger' : 'success' }}">
                                                {{ config('app.debug') ? 'Enabled' : 'Disabled' }}
                                            </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><strong>Timezone</strong></td>
                                        <td class="text-end">{{ config('app.timezone') }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Cache Driver</strong></td>
                                        <td class="text-end">{{ config('cache.default') }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Session Driver</strong></td>
                                        <td class="text-end">{{ config('session.driver') }}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Database Information -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-3">
                            <div class="bg-success bg-gradient p-3 rounded me-3">
                                <i class="bx bx-data text-white" style="font-size: 1.5rem;"></i>
                            </div>
                            <div>
                                <h5 class="mb-0">Database Information</h5>
                                <p class="text-muted mb-0">Storage & Statistics</p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <div class="card border">
                                    <div class="card-body text-center">
                                        <h6 class="text-muted mb-1">Database Driver</h6>
                                        <h4 class="mb-0">{{ strtoupper(config('database.default')) }}</h4>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4 mb-3">
                                <div class="card border">
                                    <div class="card-body text-center">
                                        <h6 class="text-muted mb-1">Database Size</h6>
                                        <h4 class="mb-0">
                                            @php
                                                $size = DB::select('SELECT SUM(data_length + index_length) / 1024 / 1024 as size FROM information_schema.TABLES WHERE table_schema = ?', [config('database.connections.mysql.database')]);
                                                $size = $size[0]->size ?? 0;
                                            @endphp
                                            {{ round($size, 2) }} MB
                                        </h4>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4 mb-3">
                                <div class="card border">
                                    <div class="card-body text-center">
                                        <h6 class="text-muted mb-1">Table Count</h6>
                                        <h4 class="mb-0">
                                            @php
                                                $tables = DB::select('SHOW TABLES');
                                            @endphp
                                            {{ count($tables) }}
                                        </h4>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <tbody>
                                    <tr>
                                        <td width="30%"><strong>Store Information</strong></td>
                                        <td>
                                            @php
                                                $hasStore = \App\Models\StoreInformation::exists();
                                            @endphp
                                            <span class="badge bg-{{ $hasStore ? 'success' : 'warning' }}">
                                                {{ $hasStore ? 'Configured' : 'Using Fallback' }}
                                            </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><strong>Users</strong></td>
                                        <td>{{ \App\Models\User::count() }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Products</strong></td>
                                        <td>{{ \App\Models\Product::count() }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Customers</strong></td>
                                        <td>{{ \App\Models\Customer::count() }}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Server Information -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-3">
                            <div class="bg-info bg-gradient p-3 rounded me-3">
                                <i class="bx bx-server text-white" style="font-size: 1.5rem;"></i>
                            </div>
                            <div>
                                <h5 class="mb-0">Server Information</h5>
                                <p class="text-muted mb-0">Operating System & Environment</p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="table-responsive">
                                    <table class="table table-sm mb-0">
                                        <tbody>
                                            <tr>
                                                <td width="50%"><strong>Operating System</strong></td>
                                                <td class="text-end">{{ php_uname('s') }}</td>
                                            </tr>
                                            <tr>
                                                <td><strong>Host Name</strong></td>
                                                <td class="text-end">{{ php_uname('n') }}</td>
                                            </tr>
                                            <tr>
                                                <td><strong>Release Name</strong></td>
                                                <td class="text-end">{{ php_uname('r') }}</td>
                                            </tr>
                                            <tr>
                                                <td><strong>Machine Type</strong></td>
                                                <td class="text-end">{{ php_uname('m') }}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="table-responsive">
                                    <table class="table table-sm mb-0">
                                        <tbody>
                                            <tr>
                                                <td width="50%"><strong>Zend Engine</strong></td>
                                                <td class="text-end">{{ zend_version() }}</td>
                                            </tr>
                                            <tr>
                                                <td><strong>Extensions</strong></td>
                                                <td class="text-end">{{ count(get_loaded_extensions()) }}</td>
                                            </tr>
                                            <tr>
                                                <td><strong>Document Root</strong></td>
                                                <td class="text-end text-truncate" style="max-width: 200px;" title="{{ $_SERVER['DOCUMENT_ROOT'] ?? 'N/A' }}">
                                                    {{ $_SERVER['DOCUMENT_ROOT'] ?? 'N/A' }}
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><strong>Server Protocol</strong></td>
                                                <td class="text-end">{{ $_SERVER['SERVER_PROTOCOL'] ?? 'N/A' }}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer bg-transparent">
                        <div class="d-flex justify-content-between align-items-center">
                            <small class="text-muted">
                                Last updated: {{ now()->format('Y-m-d H:i:s') }}
                            </small>
                            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="copySystemInfo()">
                                <i class="bx bx-copy mr-1"></i>Copy Info
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title mb-3">
                            <i class="bx bx-bolt mr-2"></i>Quick Actions
                        </h5>
                        <div class="d-flex flex-wrap gap-2">
                            <button type="button" class="btn btn-outline-primary" onclick="clearCache()">
                                <i class="bx bx-trash mr-1"></i>Clear Cache
                            </button>
                            <button type="button" class="btn btn-outline-success" onclick="optimizeApp()">
                                <i class="bx bx-bolt mr-1"></i>Optimize
                            </button>
                            <button type="button" class="btn btn-outline-info" onclick="viewRoutes()">
                                <i class="bx bx-navigation mr-1"></i>View Routes
                            </button>
                            <button type="button" class="btn btn-outline-danger" onclick="checkHealth()">
                                <i class="bx bx-heart mr-1"></i>Health Check
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--end page wrapper -->

<!-- Health Check Modal -->
<div class="modal fade" id="healthModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="bx bx-heart mr-2"></i>System Health Check</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div id="healthCheckResults"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection