@extends('layouts.app')

@section('title', 'Settings')

@section('content')
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Settings</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">Settings Dashboard</li>
                    </ol>
                </nav>
            </div>
        </div>
        <!--end breadcrumb-->

        <div class="card">
            <div class="card-body">
                <h5 class="card-title mb-3">
                    <i class="bx bx-cog me-2"></i>System Settings
                </h5>
                <p class="card-text text-muted mb-4">Manage your system settings and configurations</p>
                
                <!-- Settings Cards -->
                <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4">
                    <!-- General Settings -->
                    <div class="col">
                        <div class="card border shadow-none">
                            <div class="card-body text-center p-4">
                                <div class="mb-3">
                                    <div class="icon-box bg-light-primary text-primary rounded-circle p-3 mb-3">
                                        <i class="bx bx-slider fs-4"></i>
                                    </div>
                                </div>
                                <h6 class="card-title mb-2">General Settings</h6>
                                <p class="card-text text-muted small mb-3">Configure application name, timezone, currency, and display settings.</p>
                                <a href="{{ route('settings.general') }}" class="btn btn-primary btn-sm">
                                    <i class="bx bx-edit me-1"></i> Configure
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- Store Information -->
                    <div class="col">
                        <div class="card border shadow-none">
                            <div class="card-body text-center p-4">
                                <div class="mb-3">
                                    <div class="icon-box bg-light-success text-success rounded-circle p-3 mb-3">
                                        <i class="bx bx-store fs-4"></i>
                                    </div>
                                </div>
                                <h6 class="card-title mb-2">Store Information</h6>
                                <p class="card-text text-muted small mb-3">Manage store details, contact information, and business settings.</p>
                                <a href="{{ route('settings.store-information.index') }}" class="btn btn-success btn-sm">
                                    <i class="bx bx-store me-1"></i> Manage Store
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- Tax Settings -->
                    @role('admin')
                    <div class="col">
                        <div class="card border shadow-none">
                            <div class="card-body text-center p-4">
                                <div class="mb-3">
                                    <div class="icon-box bg-light-info text-info rounded-circle p-3 mb-3">
                                        <i class="bx bx-receipt fs-4"></i>
                                    </div>
                                </div>
                                <h6 class="card-title mb-2">Tax Settings</h6>
                                <p class="card-text text-muted small mb-3">Configure VAT rates, tax settings, and eTIMS integration.</p>
                                <a href="{{ route('taxes.index') }}" class="btn btn-info btn-sm">
                                    <i class="bx bx-receipt me-1"></i> Configure Taxes
                                </a>
                            </div>
                        </div>
                    </div>
                    @endrole

                    <!-- Backup & Restore -->
                    <div class="col">
                        <div class="card border shadow-none">
                            <div class="card-body text-center p-4">
                                <div class="mb-3">
                                    <div class="icon-box bg-light-warning text-warning rounded-circle p-3 mb-3">
                                        <i class="bx bx-data fs-4"></i>
                                    </div>
                                </div>
                                <h6 class="card-title mb-2">Backup & Restore</h6>
                                <p class="card-text text-muted small mb-3">Create backups of your data or restore from previous backups.</p>
                                <a href="{{ route('settings.backup') }}" class="btn btn-warning btn-sm">
                                    <i class="bx bx-hdd me-1"></i> Manage Backup
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- System Logs -->
                    <div class="col">
                        <div class="card border shadow-none">
                            <div class="card-body text-center p-4">
                                <div class="mb-3">
                                    <div class="icon-box bg-light-danger text-danger rounded-circle p-3 mb-3">
                                        <i class="bx bx-file fs-4"></i>
                                    </div>
                                </div>
                                <h6 class="card-title mb-2">System Logs</h6>
                                <p class="card-text text-muted small mb-3">View system logs, activity logs, and error reports.</p>
                                <a href="{{ route('settings.logs') }}" class="btn btn-danger btn-sm">
                                    <i class="bx bx-file me-1"></i> View Logs
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- System Information -->
                    <div class="col">
                        <div class="card border shadow-none">
                            <div class="card-body text-center p-4">
                                <div class="mb-3">
                                    <div class="icon-box bg-light-secondary text-secondary rounded-circle p-3 mb-3">
                                        <i class="bx bx-info-circle fs-4"></i>
                                    </div>
                                </div>
                                <h6 class="card-title mb-2">System Information</h6>
                                <p class="card-text text-muted small mb-3">View system information, PHP configuration, and server details.</p>
                                <a href="{{ route('settings.system') }}" class="btn btn-secondary btn-sm">
                                    <i class="bx bx-server me-1"></i> System Info
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <!--end row-->

                <hr class="my-5">

                <!-- Quick Statistics -->
                <div class="row">
                    <div class="col-12">
                        <div class="card border shadow-none">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-3">
                                    <h6 class="mb-0">
                                        <i class="bx bx-bar-chart me-2"></i>Quick Statistics
                                    </h6>
                                    <div class="ms-auto">
                                        <button type="button" class="btn btn-outline-primary btn-sm" onclick="window.location.reload()">
                                            <i class="bx bx-refresh me-1"></i> Refresh
                                        </button>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-3 col-sm-6 mb-3">
                                        <div class="d-flex align-items-center">
                                            <div class="icon-box bg-primary bg-opacity-10 text-primary rounded-circle p-3 me-3">
                                                <i class="bx bx-user"></i>
                                            </div>
                                            <div>
                                                <h6 class="mb-0 text-muted small">Total Users</h6>
                                                <h5 class="mb-0 fw-bold">{{ \App\Models\User::count() }}</h5>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-3 col-sm-6 mb-3">
                                        <div class="d-flex align-items-center">
                                            <div class="icon-box bg-success bg-opacity-10 text-success rounded-circle p-3 me-3">
                                                <i class="bx bx-store"></i>
                                            </div>
                                            <div>
                                                <h6 class="mb-0 text-muted small">Store Info</h6>
                                                <h5 class="mb-0 fw-bold">
                                                    @if(\App\Models\StoreInformation::exists())
                                                        <span class="text-success">Configured</span>
                                                    @else
                                                        <span class="text-warning">Not Set</span>
                                                    @endif
                                                </h5>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-3 col-sm-6 mb-3">
                                        <div class="d-flex align-items-center">
                                            <div class="icon-box bg-info bg-opacity-10 text-info rounded-circle p-3 me-3">
                                                <i class="bx bx-cog"></i>
                                            </div>
                                            <div>
                                                <h6 class="mb-0 text-muted small">Active Settings</h6>
                                                <h5 class="mb-0 fw-bold">{{ \App\Models\Setting::count() }}</h5>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-3 col-sm-6 mb-3">
                                        <div class="d-flex align-items-center">
                                            <div class="icon-box bg-warning bg-opacity-10 text-warning rounded-circle p-3 me-3">
                                                <i class="bx bx-data"></i>
                                            </div>
                                            <div>
                                                <h6 class="mb-0 text-muted small">Database Size</h6>
                                                <h5 class="mb-0 fw-bold">
                                                    @php
                                                        try {
                                                            $size = \DB::select('SELECT SUM(data_length + index_length) / 1024 / 1024 as size FROM information_schema.TABLES WHERE table_schema = ?', [config('database.connections.mysql.database')]);
                                                            echo round($size[0]->size ?? 0, 2) . ' MB';
                                                        } catch (\Exception $e) {
                                                            echo 'N/A';
                                                        }
                                                    @endphp
                                                </h5>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="text-end mt-3">
                                    <small class="text-muted">
                                        Last updated: {{ now()->format('Y-m-d H:i:s') }}
                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.icon-box {
    width: 60px;
    height: 60px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.card.border.shadow-none {
    border: 1px solid #e0e0e0 !important;
    transition: all 0.3s ease;
}

.card.border.shadow-none:hover {
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    transform: translateY(-2px);
    border-color: #c5c5c5 !important;
}

.bg-opacity-10 {
    background-opacity: 0.1 !important;
}

.bg-light-primary { background-color: rgba(var(--bs-primary-rgb), 0.1) !important; }
.bg-light-success { background-color: rgba(var(--bs-success-rgb), 0.1) !important; }
.bg-light-info { background-color: rgba(var(--bs-info-rgb), 0.1) !important; }
.bg-light-warning { background-color: rgba(var(--bs-warning-rgb), 0.1) !important; }
.bg-light-danger { background-color: rgba(var(--bs-danger-rgb), 0.1) !important; }
.bg-light-secondary { background-color: rgba(var(--bs-secondary-rgb), 0.1) !important; }

.page-breadcrumb {
    background: #f8f9fa;
    padding: 1rem;
    border-radius: 0.375rem;
    margin-bottom: 1.5rem !important;
}

.card-title {
    font-weight: 600;
}

.btn-sm {
    padding: 0.25rem 0.75rem;
    font-size: 0.875rem;
}
</style>
@endpush

@push('scripts')
<script>
$(document).ready(function() {
    console.log('Settings dashboard loaded');
    
    // Add any custom JavaScript for settings dashboard here
});
</script>
@endpush