@extends('layouts.print') {{-- minimal, print-friendly layout --}}
@section('content')
<style>
  body{ font-family: Arial, sans-serif; font-size:12px; }
  .receipt { width: 300px; margin: 0 auto; }
  .line { display:flex; justify-content:space-between; }
  .center { text-align:center; }
</style>

<div class="receipt">
  <div class="center">
    <h4>{{ \App\Helpers\System::setting('shop_name') }}</h4>
    <div>{{ \App\Helpers\System::setting('shop_location') }}</div>
    <div>Receipt: {{ $sale->receipt_no }}</div>
    <div>{{ $sale->created_at->format('Y-m-d H:i') }}</div>
  </div>

  <hr>

  @foreach($sale->items as $item)
    <div class="line">
      <div>{{ \Str::limit($item->product->name ?? $item->product_id, 24) }} x{{ $item->qty }}</div>
      <div>{{ \App\Helpers\System::currency($item->total) }}</div>
    </div>
    <div class="line">
      <small>Unit: {{ \App\Helpers\System::currency($item->price) }} 
        @if($item->tax_rate && $item->tax_amount > 0)
          | VAT {{ number_format($item->tax_rate,2) }}% ({{ \App\Helpers\System::currency($item->tax_amount) }})
        @endif
      </small>
      <small></small>
    </div>
  @endforeach

  <hr>
  <div class="line"><strong>Subtotal</strong><strong>{{ \App\Helpers\System::currency($sale->subtotal) }}</strong></div>
  <div class="line"><strong>VAT</strong><strong>{{ \App\Helpers\System::currency($sale->tax_total) }}</strong></div>
  <div class="line"><strong>Total</strong><strong>{{ \App\Helpers\System::currency($sale->grand_total) }}</strong></div>

  <hr>

  {{-- VAT breakdown by rate --}}
  @php
    // compute grouping: rate => sum(tax_amount)
    $vatGroups = $sale->items->groupBy('tax_rate')->map(function($group,$rate){
        return $group->sum('tax_amount');
    })->filter(fn($v,$k) => $k !== null && $v>0);
  @endphp

  @if($vatGroups->isNotEmpty())
    <div><strong>VAT Breakdown</strong></div>
    @foreach($vatGroups as $rate => $amount)
      <div class="line">
        <div>VAT {{ number_format($rate,2) }}%</div>
        <div>{{ \App\Helpers\System::currency($amount) }}</div>
      </div>
    @endforeach
    <hr>
  @endif

  <div class="center">
    <div>{!! \SimpleSoftwareIO\QrCode\Facades\QrCode::size(120)->generate(json_encode(['receipt'=>$sale->receipt_no,'total'=>$sale->grand_total,'date'=>$sale->created_at])) !!}</div>
    <div style="margin-top:8px">{{ \App\Helpers\System::setting('receipt_footer') }}</div>
  </div>
</div>
@endsection
