<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Purchase Order - {{ $purchase->invoice_no }}</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 100%;
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 2px solid #333;
        }
        .company-info {
            flex: 1;
        }
        .company-info h2 {
            margin: 0;
            color: #333;
            font-size: 24px;
        }
        .document-info {
            text-align: right;
        }
        .document-info h1 {
            margin: 0 0 10px 0;
            color: #333;
            font-size: 28px;
        }
        .status-badge {
            display: inline-block;
            padding: 5px 15px;
            background-color: #f8f9fa;
            border: 1px solid #dee2e6;
            border-radius: 4px;
            font-weight: bold;
            text-transform: uppercase;
        }
        .supplier-info, .purchase-info {
            margin-bottom: 30px;
        }
        .info-box {
            background-color: #f8f9fa;
            padding: 15px;
            border-radius: 4px;
            border-left: 4px solid #007bff;
        }
        .info-box h3 {
            margin-top: 0;
            color: #007bff;
        }
        .table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }
        .table th {
            background-color: #f8f9fa;
            border: 1px solid #dee2e6;
            padding: 10px;
            text-align: left;
            font-weight: bold;
        }
        .table td {
            border: 1px solid #dee2e6;
            padding: 10px;
        }
        .table tfoot td {
            font-weight: bold;
            background-color: #f8f9fa;
        }
        .totals {
            float: right;
            width: 300px;
        }
        .totals-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
            padding-bottom: 5px;
            border-bottom: 1px solid #dee2e6;
        }
        .totals-row.total {
            font-weight: bold;
            font-size: 16px;
            border-bottom: 2px solid #333;
            margin-top: 10px;
            padding-top: 10px;
        }
        .footer {
            margin-top: 50px;
            padding-top: 20px;
            border-top: 1px solid #dee2e6;
            clear: both;
        }
        .signature-section {
            display: flex;
            justify-content: space-between;
            margin-top: 50px;
        }
        .signature-box {
            text-align: center;
            width: 45%;
            padding-top: 50px;
            border-top: 1px solid #333;
        }
        .print-button {
            position: fixed;
            top: 20px;
            right: 20px;
            padding: 10px 20px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            z-index: 1000;
        }
        .print-button:hover {
            background-color: #0056b3;
        }
        @media print {
            .print-button {
                display: none;
            }
            body {
                font-size: 11px;
            }
            .container {
                padding: 10px;
            }
        }
        .row {
            display: flex;
            flex-wrap: wrap;
            margin-right: -15px;
            margin-left: -15px;
        }
        .col-6 {
            flex: 0 0 50%;
            max-width: 50%;
            padding: 0 15px;
        }
        .col-12 {
            flex: 0 0 100%;
            max-width: 100%;
            padding: 0 15px;
        }
    </style>
</head>
<body>
    <button class="print-button" onclick="window.print()">Print Purchase Order</button>
    
    <div class="container">
        <div class="header">
            <div class="company-info">
                <h2>{{ $company['name'] }}</h2>
                <p>{{ $company['address'] }}</p>
                <p>Phone: {{ $company['phone'] }} | Email: {{ $company['email'] }}</p>
                <p>Website: {{ $company['website'] }} | Tax ID: {{ $company['tax_id'] }}</p>
            </div>
            <div class="document-info">
                <h1>PURCHASE ORDER</h1>
                <p><strong>PO Number:</strong> {{ $purchase->invoice_no }}</p>
                <p><strong>Date:</strong> {{ $purchase->purchase_date->format('F d, Y') }}</p>
                <p><strong>Status:</strong> <span class="status-badge">{{ strtoupper($purchase->status) }}</span></p>
            </div>
        </div>

        <div class="row">
            <div class="col-6">
                <div class="info-box">
                    <h3>Supplier Information</h3>
                    <p><strong>{{ $purchase->supplier->name }}</strong></p>
                    <p>{{ $purchase->supplier->address ?? 'No address provided' }}</p>
                    <p>Phone: {{ $purchase->supplier->phone ?? 'N/A' }}</p>
                    <p>Email: {{ $purchase->supplier->email ?? 'N/A' }}</p>
                    @if($purchase->supplier->tax_number)
                        <p>Tax Number: {{ $purchase->supplier->tax_number }}</p>
                    @endif
                </div>
            </div>
            <div class="col-6">
                <div class="info-box">
                    <h3>Order Details</h3>
                    <p><strong>Purchase Date:</strong> {{ $purchase->purchase_date->format('F d, Y') }}</p>
                    @if($purchase->expected_delivery_date)
                        <p><strong>Expected Delivery:</strong> {{ $purchase->expected_delivery_date->format('F d, Y') }}</p>
                    @endif
                    @if($purchase->reference_number)
                        <p><strong>Reference:</strong> {{ $purchase->reference_number }}</p>
                    @endif
                    <p><strong>Payment Status:</strong> {{ ucfirst($purchase->payment_status) }}</p>
                    @if($purchase->payment_method)
                        <p><strong>Payment Method:</strong> {{ ucfirst($purchase->payment_method) }}</p>
                    @endif
                </div>
            </div>
        </div>

        <table class="table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Item Description</th>
                    <th>Type</th>
                    <th>Quantity</th>
                    <th>Unit Price</th>
                    <th>Tax %</th>
                    <th>Tax Amount</th>
                    <th>Total</th>
                </tr>
            </thead>
            <tbody>
                @foreach($purchase->items as $index => $item)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>
                        @if($item->item_type === 'product')
                            {{ $item->product->name ?? 'Product #' . $item->product_id }}
                            @if($item->batch_number)
                                <br><small>Batch: {{ $item->batch_number }}</small>
                            @endif
                            @if($item->expiry_date)
                                <br><small>Expires: {{ $item->expiry_date->format('M d, Y') }}</small>
                            @endif
                        @else
                            {{ $item->description }}
                        @endif
                    </td>
                    <td>{{ ucfirst($item->item_type) }}</td>
                    <td>{{ $item->quantity }}</td>
                    <td>KES {{ number_format($item->unit_price, 2) }}</td>
                    <td>{{ $item->tax_percent }}%</td>
                    <td>KES {{ number_format($item->tax_amount, 2) }}</td>
                    <td>KES {{ number_format($item->total, 2) }}</td>
                </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="6" style="text-align: right;"><strong>Subtotal:</strong></td>
                    <td colspan="2"><strong>KES {{ number_format($purchase->subtotal, 2) }}</strong></td>
                </tr>
                <tr>
                    <td colspan="6" style="text-align: right;"><strong>Tax:</strong></td>
                    <td colspan="2"><strong>KES {{ number_format($purchase->tax_amount, 2) }}</strong></td>
                </tr>
                @if($purchase->discount_amount > 0)
                <tr>
                    <td colspan="6" style="text-align: right;"><strong>Discount:</strong></td>
                    <td colspan="2"><strong>KES {{ number_format($purchase->discount_amount, 2) }}</strong></td>
                </tr>
                @endif
                <tr>
                    <td colspan="6" style="text-align: right;"><strong>Grand Total:</strong></td>
                    <td colspan="2"><strong>KES {{ number_format($purchase->grand_total, 2) }}</strong></td>
                </tr>
                @if($purchase->paid_amount > 0)
                <tr>
                    <td colspan="6" style="text-align: right;"><strong>Amount Paid:</strong></td>
                    <td colspan="2"><strong>KES {{ number_format($purchase->paid_amount, 2) }}</strong></td>
                </tr>
                <tr>
                    <td colspan="6" style="text-align: right;"><strong>Balance Due:</strong></td>
                    <td colspan="2"><strong>KES {{ number_format($purchase->grand_total - $purchase->paid_amount, 2) }}</strong></td>
                </tr>
                @endif
            </tfoot>
        </table>

        @if($purchase->notes || $purchase->terms_conditions)
        <div class="notes-section">
            @if($purchase->notes)
            <div style="margin-bottom: 20px;">
                <h3>Notes</h3>
                <p>{{ $purchase->notes }}</p>
            </div>
            @endif
            
            @if($purchase->terms_conditions)
            <div style="margin-bottom: 20px;">
                <h3>Terms & Conditions</h3>
                <p>{{ $purchase->terms_conditions }}</p>
            </div>
            @endif
        </div>
        @endif

        <div class="signature-section">
            <div class="signature-box">
                <p><strong>Prepared By:</strong></p>
                <p>{{ $purchase->creator->name ?? 'N/A' }}</p>
                <p>Date: {{ $purchase->created_at->format('M d, Y') }}</p>
            </div>
            
            @if($purchase->approved_at)
            <div class="signature-box">
                <p><strong>Approved By:</strong></p>
                <p>{{ $purchase->approver->name ?? 'N/A' }}</p>
                <p>Date: {{ $purchase->approved_at->format('M d, Y') }}</p>
            </div>
            @endif
        </div>

        <div class="footer">
            <p style="text-align: center; color: #666; font-size: 10px;">
                This is a computer generated purchase order. No signature required.<br>
                {{ $company['name'] }} | {{ $company['address'] }} | {{ $company['phone'] }}
            </p>
        </div>
    </div>

    <script>
        window.onload = function() {
            // Auto-print option (uncomment to enable)
            // window.print();
        };
    </script>
</body>
</html>