@extends('layouts.app')

@section('content')
<div class="page-wrapper">
    <div class="page-content">
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">
                <i class="bx bx-money me-1"></i> Record Payment
            </div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item"><a href="{{ route('purchases.index') }}">Purchases</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('purchases.show', $purchase) }}">{{ $purchase->invoice_no }}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Record Payment</li>
                    </ol>
                </nav>
            </div>
        </div>

        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <h4 class="mb-3">Record Payment for Purchase #{{ $purchase->invoice_no }}</h4>
                
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">Purchase Summary</h5>
                                <p class="mb-1"><strong>Supplier:</strong> {{ $purchase->supplier->name }}</p>
                                <p class="mb-1"><strong>Grand Total:</strong> KES {{ number_format($purchase->grand_total, 2) }}</p>
                                <p class="mb-1"><strong>Paid Amount:</strong> KES {{ number_format($purchase->paid_amount, 2) }}</p>
                                <p class="mb-0"><strong>Balance Due:</strong> KES {{ number_format($purchase->grand_total - $purchase->paid_amount, 2) }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <form action="{{ route('purchases.record-payment', $purchase) }}" method="POST">
                    @csrf
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Payment Amount *</label>
                                <div class="input-group">
                                    <span class="input-group-text">KES</span>
                                    <input type="number" name="amount" class="form-control" 
                                           min="0.01" max="{{ $purchase->grand_total - $purchase->paid_amount }}"
                                           step="0.01" required 
                                           value="{{ $purchase->grand_total - $purchase->paid_amount }}">
                                </div>
                                <small class="text-muted">Maximum: KES {{ number_format($purchase->grand_total - $purchase->paid_amount, 2) }}</small>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Payment Method *</label>
                                <select name="method" class="form-select" required>
                                    <option value="">Select Method</option>
                                    <option value="cash">Cash</option>
                                    <option value="bank">Bank Transfer</option>
                                    <option value="mpesa">M-Pesa</option>
                                    <option value="cheque">Cheque</option>
                                    <option value="credit">Credit</option>
                                </select>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">Payment Notes (Optional)</label>
                                <textarea name="notes" class="form-control" rows="3" placeholder="Payment reference, transaction ID, etc..."></textarea>
                            </div>
                        </div>
                    </div>
                    
                    <div class="d-flex justify-content-between">
                        <a href="{{ route('purchases.show', $purchase) }}" class="btn btn-secondary">
                            <i class="bx bx-x"></i> Cancel
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="bx bx-check"></i> Record Payment
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection