<div class="row">
    <div class="col-md-6">
        <h6 class="text-muted">Purchase Information</h6>
        <table class="table table-sm">
            <tr>
                <th width="40%">Invoice No:</th>
                <td>{{ $purchase->invoice_no }}</td>
            </tr>
            <tr>
                <th>Date:</th>
                <td>{{ $purchase->purchase_date->format('M d, Y h:i A') }}</td>
            </tr>
            <tr>
                <th>Reference:</th>
                <td>{{ $purchase->reference_number ?? 'N/A' }}</td>
            </tr>
            <tr>
                <th>Status:</th>
                <td>
                    <span class="badge bg-{{ $purchase->status == 'completed' ? 'success' : ($purchase->status == 'pending' ? 'warning' : 'danger') }}">
                        {{ ucfirst($purchase->status) }}
                    </span>
                </td>
            </tr>
            <tr>
                <th>Inventory Status:</th>
                <td>
                    @if($purchase->status == 'completed')
                        <span class="badge bg-success">
                            <i class="bx bx-check"></i> Added to Stock
                        </span>
                    @elseif($purchase->status == 'pending')
                        <span class="badge bg-warning">
                            <i class="bx bx-time"></i> Not Added to Stock
                        </span>
                    @else
                        <span class="badge bg-secondary">
                            <i class="bx bx-x"></i> Cancelled
                        </span>
                    @endif
                </td>
            </tr>
            @if($purchase->is_credit_purchase)
            <tr>
                <th>Credit Purchase:</th>
                <td>
                    <span class="badge bg-info">Yes</span>
                    @if($purchase->due_date)
                        <br><small>Due: {{ \Carbon\Carbon::parse($purchase->due_date)->format('M d, Y') }}</small>
                    @endif
                </td>
            </tr>
            @endif
        </table>
    </div>
    
    <div class="col-md-6">
        <h6 class="text-muted">Supplier Information</h6>
        <table class="table table-sm">
            <tr>
                <th width="40%">Supplier:</th>
                <td>{{ $purchase->supplier->name ?? 'N/A' }}</td>
            </tr>
            <tr>
                <th>Phone:</th>
                <td>{{ $purchase->supplier->phone ?? 'N/A' }}</td>
            </tr>
            <tr>
                <th>Email:</th>
                <td>{{ $purchase->supplier->email ?? 'N/A' }}</td>
            </tr>
            <tr>
                <th>Address:</th>
                <td>{{ $purchase->supplier->address ?? 'N/A' }}</td>
            </tr>
        </table>
    </div>
</div>

<!-- Payment Information -->
<div class="row mt-3">
    <div class="col-md-6">
        <h6 class="text-muted">Payment Information</h6>
        <table class="table table-sm">
            <tr>
                <th width="40%">Payment Status:</th>
                <td>
                    <span class="badge bg-{{ $purchase->payment_status == 'paid' ? 'success' : ($purchase->payment_status == 'partial' ? 'warning' : 'danger') }}">
                        {{ ucfirst($purchase->payment_status) }}
                    </span>
                </td>
            </tr>
            <tr>
                <th>Payment Method:</th>
                <td>{{ ucfirst($purchase->payment_method ?? 'Not specified') }}</td>
            </tr>
            <tr>
                <th>Paid Amount:</th>
                <td class="text-success">KES {{ number_format($purchase->paid_amount, 2) }}</td>
            </tr>
            <tr>
                <th>Balance Due:</th>
                <td class="{{ $purchase->grand_total - $purchase->paid_amount > 0 ? 'text-warning' : 'text-success' }}">
                    KES {{ number_format($purchase->grand_total - $purchase->paid_amount, 2) }}
                </td>
            </tr>
        </table>
    </div>
    <div class="col-md-6">
        <h6 class="text-muted">Financial Summary</h6>
        <table class="table table-sm">
            <tr>
                <th width="40%">Subtotal:</th>
                <td>KES {{ number_format($purchase->subtotal, 2) }}</td>
            </tr>
            <tr>
                <th>Tax Amount:</th>
                <td>KES {{ number_format($purchase->tax_amount, 2) }}</td>
            </tr>
            <tr>
                <th>Grand Total:</th>
                <td class="text-primary"><strong>KES {{ number_format($purchase->grand_total, 2) }}</strong></td>
            </tr>
        </table>
    </div>
</div>

<!-- Purchase Items Summary -->
<div class="row mt-3">
    <div class="col-12">
        <h6 class="text-muted">Purchase Items</h6>
        <div class="table-responsive">
            <table class="table table-sm table-bordered">
                <thead>
                    <tr>
                        <th>Item</th>
                        <th class="text-center">Qty</th>
                        <th class="text-end">Unit Price</th>
                        <th class="text-end">Total</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($purchase->items as $item)
                    <tr>
                        <td>
                            <strong>{{ $item->description ?? ($item->product->name ?? 'Product') }}</strong>
                            <br><small class="text-muted">{{ $item->item_type == 'product' ? 'Product' : 'Service' }}</small>
                        </td>
                        <td class="text-center">{{ $item->quantity }}</td>
                        <td class="text-end">KES {{ number_format($item->unit_price, 2) }}</td>
                        <td class="text-end">KES {{ number_format($item->total, 2) }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Action Buttons -->
<div class="row mt-3" id="modalActionButtons">
    <div class="col-12">
        <div class="d-flex gap-2 flex-wrap">
            @if($purchase->status == 'pending')
                <form action="{{ route('purchases.complete', $purchase) }}" method="POST" class="d-inline modal-form">
                    @csrf
                    @method('PUT')
                    <button type="submit" class="btn btn-success btn-sm">
                        <i class="bx bx-check"></i> Complete
                    </button>
                </form>
                
                <a href="{{ route('purchases.edit', $purchase) }}" class="btn btn-warning btn-sm">
                    <i class="bx bx-edit"></i> Edit
                </a>
                
                <form action="{{ route('purchases.cancel', $purchase) }}" method="POST" class="d-inline modal-form">
                    @csrf
                    @method('PUT')
                    <button type="submit" class="btn btn-danger btn-sm">
                        <i class="bx bx-x"></i> Cancel
                    </button>
                </form>
                
                <form action="{{ route('purchases.add-to-stock', $purchase) }}" method="POST" class="d-inline modal-form">
                    @csrf
                    <button type="submit" class="btn btn-info btn-sm">
                        <i class="bx bx-package"></i> Add to Stock
                    </button>
                </form>
                
                @if($purchase->items()->where('added_to_stock', false)->count() == $purchase->items()->count())
                    <form action="{{ route('purchases.destroy', $purchase) }}" method="POST" class="d-inline modal-form">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-outline-danger btn-sm">
                            <i class="bx bx-trash"></i> Delete
                        </button>
                    </form>
                @endif
            @endif
            
            @if($purchase->status == 'completed' && $purchase->grand_total > $purchase->paid_amount)
                <a href="{{ route('purchases.payment', $purchase) }}" class="btn btn-primary btn-sm">
                    <i class="bx bx-money"></i> Record Payment
                </a>
            @endif
            
            <a href="{{ route('purchases.show', $purchase) }}" class="btn btn-outline-info btn-sm">
                <i class="bx bx-show"></i> View Full Details
            </a>
            
            @if($purchase->status == 'cancelled' && $purchase->items()->where('added_to_stock', false)->count() == $purchase->items()->count())
                <form action="{{ route('purchases.destroy', $purchase) }}" method="POST" class="d-inline modal-form">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-outline-danger btn-sm">
                        <i class="bx bx-trash"></i> Delete
                    </button>
                </form>
            @endif
        </div>
    </div>
</div>