<div class="row">
    <div class="col-md-6">
        <h6 class="text-muted">Purchase Information</h6>
        <table class="table table-sm">
            <tr>
                <th width="40%">Invoice No:</th>
                <td>{{ $purchase->invoice_no }}</td>
            </tr>
            <tr>
                <th>Date:</th>
                <td>{{ $purchase->purchase_date->format('M d, Y h:i A') }}</td>
            </tr>
            <tr>
                <th>Reference:</th>
                <td>{{ $purchase->reference_number ?? 'N/A' }}</td>
            </tr>
            <tr>
                <th>Status:</th>
                <td>
                    <span class="badge bg-{{ $purchase->status == 'completed' ? 'success' : ($purchase->status == 'pending' ? 'warning' : 'danger') }}">
                        {{ ucfirst($purchase->status) }}
                    </span>
                </td>
            </tr>
            <tr>
                <th>Inventory Status:</th>
                <td>
                    @if($purchase->status == 'completed')
                        <span class="badge bg-success">
                            <i class="bx bx-check"></i> Added to Stock
                        </span>
                    @elseif($purchase->status == 'pending')
                        <span class="badge bg-warning">
                            <i class="bx bx-time"></i> Not Added to Stock
                        </span>
                    @else
                        <span class="badge bg-secondary">
                            <i class="bx bx-x"></i> Cancelled
                        </span>
                    @endif
                </td>
            </tr>
            @if($purchase->is_credit_purchase)
            <tr>
                <th>Credit Purchase:</th>
                <td>
                    <span class="badge bg-info">Yes</span>
                    @if($purchase->due_date)
                        <br><small>Due: {{ \Carbon\Carbon::parse($purchase->due_date)->format('M d, Y') }}</small>
                    @endif
                </td>
            </tr>
            @endif
        </table>
    </div>
    
    <div class="col-md-6">
        <h6 class="text-muted">Supplier Information</h6>
        <table class="table table-sm">
            <tr>
                <th width="40%">Supplier:</th>
                <td>{{ $purchase->supplier->name ?? 'N/A' }}</td>
            </tr>
            <tr>
                <th>Phone:</th>
                <td>{{ $purchase->supplier->phone ?? 'N/A' }}</td>
            </tr>
            <tr>
                <th>Email:</th>
                <td>{{ $purchase->supplier->email ?? 'N/A' }}</td>
            </tr>
            <tr>
                <th>Address:</th>
                <td>{{ $purchase->supplier->address ?? 'N/A' }}</td>
            </tr>
            @if($purchase->supplier && $purchase->supplier->credit_limit > 0)
            <tr>
                <th>Credit Limit:</th>
                <td>
                    KES {{ number_format($purchase->supplier->credit_limit, 2) }}
                    @if($purchase->is_credit_purchase)
                        <br><small class="text-info">Used: KES {{ number_format($purchase->grand_total, 2) }}</small>
                    @endif
                </td>
            </tr>
            @endif
        </table>
    </div>
</div>

<!-- Payment Information -->
<div class="row mt-3">
    <div class="col-md-6">
        <h6 class="text-muted">Payment Information</h6>
        <table class="table table-sm">
            <tr>
                <th width="40%">Payment Status:</th>
                <td>
                    <span class="badge bg-{{ $purchase->payment_status == 'paid' ? 'success' : ($purchase->payment_status == 'partial' ? 'warning' : 'danger') }}">
                        {{ ucfirst($purchase->payment_status) }}
                    </span>
                </td>
            </tr>
            <tr>
                <th>Payment Method:</th>
                <td>{{ ucfirst($purchase->payment_method ?? 'Not specified') }}</td>
            </tr>
            <tr>
                <th>Paid Amount:</th>
                <td class="text-success">KES {{ number_format($purchase->paid_amount, 2) }}</td>
            </tr>
            <tr>
                <th>Balance Due:</th>
                <td class="{{ $purchase->grand_total - $purchase->paid_amount > 0 ? 'text-warning' : 'text-success' }}">
                    KES {{ number_format($purchase->grand_total - $purchase->paid_amount, 2) }}
                </td>
            </tr>
        </table>
    </div>
    <div class="col-md-6">
        <h6 class="text-muted">Financial Summary</h6>
        <table class="table table-sm">
            <tr>
                <th width="40%">Subtotal:</th>
                <td>KES {{ number_format($purchase->subtotal, 2) }}</td>
            </tr>
            <tr>
                <th>Tax Amount:</th>
                <td>KES {{ number_format($purchase->tax_amount, 2) }}</td>
            </tr>
            <tr>
                <th>Grand Total:</th>
                <td class="text-primary"><strong>KES {{ number_format($purchase->grand_total, 2) }}</strong></td>
            </tr>
        </table>
    </div>
</div>

<!-- Action Buttons -->
<div class="row mt-3">
    <div class="col-12">
        <div class="d-flex gap-2 flex-wrap">
            @if($purchase->status == 'pending')
                <form action="{{ route('purchases.complete', $purchase) }}" method="POST" class="d-inline">
                    @csrf
                    @method('PUT')
                    <button type="submit" class="btn btn-success btn-sm" 
                            onclick="return confirm('Mark as completed and add items to stock?')">
                        <i class="bx bx-check"></i> Complete & Add to Stock
                    </button>
                </form>
                
                <a href="{{ route('purchases.edit', $purchase) }}" class="btn btn-warning btn-sm">
                    <i class="bx bx-edit"></i> Edit
                </a>
                
                <form action="{{ route('purchases.cancel', $purchase) }}" method="POST" class="d-inline">
                    @csrf
                    @method('PUT')
                    <button type="submit" class="btn btn-danger btn-sm" 
                            onclick="return confirm('Cancel this purchase?')">
                        <i class="bx bx-x"></i> Cancel
                    </button>
                </form>
                
                @if($purchase->items()->where('added_to_stock', false)->count() == $purchase->items()->count())
                    <form action="{{ route('purchases.destroy', $purchase) }}" method="POST" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-outline-danger btn-sm" 
                                onclick="return confirm('Delete this purchase permanently?')">
                            <i class="bx bx-trash"></i> Delete
                        </button>
                    </form>
                @endif
            @endif
            
            @if($purchase->status == 'completed' && $purchase->grand_total > $purchase->paid_amount)
                <a href="{{ route('purchases.payment', $purchase) }}" class="btn btn-primary btn-sm">
                    <i class="bx bx-money"></i> Record Payment
                </a>
            @endif
            
            <a href="{{ route('purchases.show', $purchase) }}" class="btn btn-info btn-sm">
                <i class="bx bx-show"></i> View Full Details
            </a>
            
            @if($purchase->status == 'cancelled' && $purchase->items()->where('added_to_stock', false)->count() == $purchase->items()->count())
                <form action="{{ route('purchases.destroy', $purchase) }}" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-outline-danger btn-sm" 
                            onclick="return confirm('Delete this cancelled purchase permanently?')">
                        <i class="bx bx-trash"></i> Delete
                    </button>
                </form>
            @endif
        </div>
    </div>
</div>

<!-- Purchase Items -->
<div class="row mt-3">
    <div class="col-12">
        <h6 class="text-muted">Purchase Items</h6>
        <div class="alert alert-info">
            <i class="bx bx-info-circle"></i>
            <small>All items are inventory products that affect stock levels when purchase is completed.</small>
        </div>
        
        <div class="table-responsive">
            <table class="table table-sm table-bordered">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Product/Service</th>
                        <th>Type</th>
                        <th class="text-center">SKU</th>
                        <th class="text-center">Qty</th>
                        <th class="text-end">Unit Price</th>
                        <th class="text-end">Tax %</th>
                        <th class="text-end">Tax Amount</th>
                        <th class="text-end">Total</th>
                        <th>Stock Status</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($purchase->items as $item)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>
                            <div class="d-flex align-items-center">
                                @if($item->item_type == 'product')
                                    <i class="bx bx-package text-success me-2"></i>
                                @else
                                    <i class="bx bx-cog text-info me-2"></i>
                                @endif
                                <div>
                                    <strong>{{ $item->description ?? ($item->product->name ?? 'Product Deleted') }}</strong>
                                    <div class="text-muted small">
                                        @if($item->item_type == 'product' && $item->product)
                                            <span class="badge bg-light text-dark">Stock: {{ $item->product->stock ?? 0 }}</span>
                                        @endif
                                        @if($item->batch_number)
                                            <span class="badge bg-secondary">Batch: {{ $item->batch_number }}</span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </td>
                        <td>
                            <span class="badge bg-{{ $item->item_type == 'product' ? 'success' : 'info' }}">
                                {{ ucfirst($item->item_type) }}
                            </span>
                        </td>
                        <td class="text-center">
                            <code>{{ $item->product->sku ?? ($item->item_type == 'service' ? 'SERVICE' : 'N/A') }}</code>
                        </td>
                        <td class="text-center">{{ $item->quantity }}</td>
                        <td class="text-end">KES {{ number_format($item->unit_price, 2) }}</td>
                        <td class="text-end">{{ number_format($item->tax_percent ?? 0, 2) }}%</td>
                        <td class="text-end">KES {{ number_format($item->tax_amount ?? 0, 2) }}</td>
                        <td class="text-end">KES {{ number_format($item->total, 2) }}</td>
                        <td>
                            @if($item->item_type == 'product')
                                @if($item->added_to_stock)
                                    <span class="badge bg-success">Added</span>
                                @else
                                    <span class="badge bg-warning">Pending</span>
                                @endif
                            @else
                                <span class="badge bg-secondary">N/A</span>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <td colspan="7" class="text-end"><strong>Subtotal:</strong></td>
                        <td class="text-end">KES {{ number_format($purchase->subtotal, 2) }}</td>
                        <td></td>
                    </tr>
                    <tr>
                        <td colspan="7" class="text-end"><strong>Tax:</strong></td>
                        <td class="text-end">KES {{ number_format($purchase->tax_amount, 2) }}</td>
                        <td></td>
                    </tr>
                    <tr class="table-active">
                        <td colspan="7" class="text-end"><strong>Grand Total:</strong></td>
                        <td class="text-end"><strong>KES {{ number_format($purchase->grand_total, 2) }}</strong></td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>

<!-- Additional Information -->
<div class="row mt-3">
    <div class="col-md-6">
        <h6 class="text-muted">Additional Information</h6>
        <table class="table table-sm">
            <tr>
                <th width="40%">Created By:</th>
                <td>{{ $purchase->creator->name ?? 'System' }}</td>
            </tr>
            <tr>
                <th>Created At:</th>
                <td>{{ $purchase->created_at->format('M d, Y h:i A') }}</td>
            </tr>
            @if($purchase->expected_delivery_date)
            <tr>
                <th>Expected Delivery:</th>
                <td>{{ \Carbon\Carbon::parse($purchase->expected_delivery_date)->format('M d, Y') }}</td>
            </tr>
            @endif
        </table>
    </div>
    
    @if($purchase->notes || $purchase->terms_conditions)
    <div class="col-md-6">
        <h6 class="text-muted">Notes & Terms</h6>
        <div class="card bg-light">
            <div class="card-body">
                @if($purchase->notes)
                    <strong>Notes:</strong>
                    <p>{{ $purchase->notes }}</p>
                @endif
                
                @if($purchase->terms_conditions)
                    <strong>Terms & Conditions:</strong>
                    <p>{{ $purchase->terms_conditions }}</p>
                @endif
            </div>
        </div>
    </div>
    @endif
</div>

<!-- Inventory Status Notice -->
@if($purchase->status == 'completed')
<div class="row mt-3">
    <div class="col-12">
        <div class="alert alert-success">
            <i class="bx bx-check-circle"></i>
            <small>
                <strong>Inventory Status:</strong> All {{ $purchase->items->where('item_type', 'product')->count() }} product item(s) have been added to stock.
                @php
                    $productItems = $purchase->items->where('item_type', 'product');
                    $totalQuantity = $productItems->sum('quantity');
                    $totalValue = $productItems->sum(function($item) {
                        return $item->quantity * $item->unit_price;
                    });
                @endphp
                <br><strong>Stock Added:</strong> {{ $totalQuantity }} units worth KES {{ number_format($totalValue, 2) }}
            </small>
        </div>
    </div>
</div>
@elseif($purchase->status == 'pending')
<div class="row mt-3">
    <div class="col-12">
        <div class="alert alert-warning">
            <i class="bx bx-time"></i>
            <small>
                <strong>Inventory Status:</strong> Purchase is pending. Product items will be added to stock when marked as completed.
                @php
                    $productItems = $purchase->items->where('item_type', 'product');
                    $totalQuantity = $productItems->sum('quantity');
                @endphp
                <br><strong>Pending Stock:</strong> {{ $totalQuantity }} units awaiting addition to inventory
            </small>
        </div>
    </div>
</div>
@endif

<style>
    .table-sm td, .table-sm th {
        padding: 8px;
        vertical-align: middle;
    }
    
    .badge-pending {
        background-color: #F59E0B;
        color: white;
    }
    
    .badge-completed {
        background-color: #10B981;
        color: white;
    }
    
    .badge-cancelled {
        background-color: #EF4444;
        color: white;
    }
    
    .btn-group-sm .btn {
        padding: 5px 10px;
        font-size: 12px;
    }
</style>