@extends('layouts.app')

@section('style')
<style>
    /* Syndron Edit Theme - Mobile Responsive */
    .edit-header-syndron {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 15px 15px 0 0;
        padding: 20px;
        color: white;
        margin-bottom: 20px;
    }
    
    @media (max-width: 768px) {
        .edit-header-syndron {
            padding: 15px;
            border-radius: 10px 10px 0 0;
            margin-bottom: 15px;
        }
        
        .edit-header-syndron h4 {
            font-size: 18px;
        }
    }
    
    .edit-card-syndron {
        border: none;
        border-radius: 15px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        overflow: hidden;
        margin-bottom: 20px;
    }
    
    @media (max-width: 768px) {
        .edit-card-syndron {
            border-radius: 10px;
            margin-bottom: 15px;
        }
    }
    
    .form-section-syndron {
        padding: 20px;
        border-bottom: 1px solid #dee2e6;
    }
    
    @media (max-width: 768px) {
        .form-section-syndron {
            padding: 15px;
        }
        
        .form-section-syndron h5 {
            font-size: 16px;
        }
    }
    
    .form-section-syndron:last-child {
        border-bottom: none;
    }
    
    /* Item Cards */
    .item-card-edit {
        background: #f8f9fa;
        border-radius: 10px;
        padding: 15px;
        margin-bottom: 15px;
        border-left: 4px solid #667eea;
        transition: all 0.3s ease;
        position: relative;
    }
    
    @media (max-width: 768px) {
        .item-card-edit {
            padding: 12px;
            margin-bottom: 10px;
        }
    }
    
    .item-card-edit:hover {
        background: #f0f4ff;
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(102, 126, 234, 0.1);
    }
    
    .item-card-edit.service {
        border-left-color: #3B82F6;
        background: #f0f9ff;
    }
    
    .item-card-edit.inventory {
        border-left-color: #10B981;
        background: #f0fff4;
    }
    
    .remove-item-btn {
        position: absolute;
        top: 10px;
        right: 10px;
        width: 30px;
        height: 30px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        background: #EF4444;
        color: white;
        border: none;
        font-size: 14px;
        cursor: pointer;
        transition: all 0.3s;
    }
    
    .remove-item-btn:hover {
        background: #DC2626;
        transform: scale(1.1);
    }
    
    /* Batch Fields */
    .batch-fields-edit {
        background: white;
        border-radius: 8px;
        padding: 15px;
        margin-top: 15px;
        border: 1px solid #dee2e6;
    }
    
    @media (max-width: 768px) {
        .batch-fields-edit {
            padding: 12px;
        }
    }
    
    /* Add Item Button */
    .add-item-btn-syndron {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border: none;
        border-radius: 10px;
        padding: 12px 20px;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 10px;
        margin: 20px auto;
        transition: all 0.3s;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    @media (max-width: 768px) {
        .add-item-btn-syndron {
            width: 100%;
            justify-content: center;
            margin: 15px auto;
            padding: 15px;
        }
    }
    
    .add-item-btn-syndron:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 20px rgba(102, 126, 234, 0.3);
    }
    
    /* Summary Card */
    .summary-card-edit {
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
        border-radius: 10px;
        padding: 20px;
        border: 2px solid #e2e8f0;
    }
    
    @media (max-width: 768px) {
        .summary-card-edit {
            padding: 15px;
            margin-top: 15px;
        }
    }
    
    .summary-row {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 10px 0;
        border-bottom: 1px solid #e2e8f0;
    }
    
    .summary-row:last-child {
        border-bottom: none;
    }
    
    .summary-row.total {
        font-size: 18px;
        font-weight: 700;
        color: #667eea;
    }
    
    /* Action Buttons */
    .action-buttons-edit {
        display: flex;
        gap: 15px;
        margin-top: 30px;
        padding-top: 20px;
        border-top: 1px solid #dee2e6;
    }
    
    @media (max-width: 768px) {
        .action-buttons-edit {
            flex-direction: column;
            gap: 10px;
            margin-top: 20px;
            padding-top: 15px;
        }
        
        .action-buttons-edit .btn {
            width: 100%;
            justify-content: center;
        }
    }
    
    .action-buttons-edit .btn {
        padding: 12px 30px;
        font-weight: 600;
        border-radius: 10px;
        border: none;
        display: flex;
        align-items: center;
        gap: 10px;
        transition: all 0.3s;
    }
    
    /* Status Badge */
    .status-badge-edit {
        padding: 8px 15px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .badge-pending-edit {
        background: linear-gradient(135deg, #F59E0B, #D97706);
        color: white;
    }
    
    /* Tax Info */
    .tax-info-edit {
        font-size: 11px;
        color: #6c757d;
        margin-top: 5px;
    }
    
    /* Mobile Form Groups */
    @media (max-width: 768px) {
        .mobile-form-group {
            margin-bottom: 15px;
        }
        
        .mobile-form-group label {
            font-size: 14px;
            font-weight: 500;
            margin-bottom: 5px;
            display: block;
        }
    }
</style>
@endsection

@section('content')
<div class="page-wrapper">
    <div class="page-content">
        <!-- Edit Header -->
        <div class="edit-header-syndron">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <h4 class="mb-1"><i class="bx bx-edit me-2"></i> Edit Purchase</h4>
                    <p class="mb-0 opacity-75">{{ $purchase->invoice_no }}</p>
                </div>
                <div>
                    <span class="status-badge-edit badge-pending-edit">
                        {{ ucfirst($purchase->status) }}
                    </span>
                </div>
            </div>
        </div>

        <form action="{{ route('purchases.update', $purchase) }}" method="POST" id="editPurchaseForm">
            @csrf
            @method('PUT')
            
            <div class="row">
                <!-- Left Column - Main Form -->
                <div class="col-lg-8">
                    <div class="edit-card-syndron">
                        <!-- Supplier & Basic Info -->
                        <div class="form-section-syndron">
                            <h5 class="mb-3"><i class="bx bx-user me-2"></i> Supplier & Basic Information</h5>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Supplier *</label>
                                    <select name="supplier_id" class="form-select" required>
                                        <option value="">Select Supplier</option>
                                        @foreach($suppliers as $supplier)
                                            <option value="{{ $supplier->id }}" {{ $purchase->supplier_id == $supplier->id ? 'selected' : '' }}>
                                                {{ $supplier->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Purchase Date *</label>
                                    <input type="date" name="purchase_date" class="form-control" 
                                           value="{{ $purchase->purchase_date->format('Y-m-d') }}" required>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Reference Number</label>
                                    <input type="text" name="reference_number" class="form-control" 
                                           value="{{ $purchase->reference_number }}" placeholder="Optional">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Expected Delivery</label>
                                    <input type="date" name="expected_delivery_date" class="form-control" 
                                           value="{{ $purchase->expected_delivery_date ? $purchase->expected_delivery_date->format('Y-m-d') : '' }}">
                                </div>
                            </div>
                        </div>
                        
                        <!-- Purchase Items -->
                        <div class="form-section-syndron">
                            <h5 class="mb-3"><i class="bx bx-package me-2"></i> Purchase Items</h5>
                            <div id="purchaseItemsContainer">
                                @foreach($purchase->items as $index => $item)
                                    <div class="item-card-edit {{ $item->item_type === 'service' ? 'service' : 'inventory' }}" data-index="{{ $index }}">
                                        <button type="button" class="remove-item-btn" onclick="removeItem(this)">
                                            <i class="bx bx-trash"></i>
                                        </button>
                                        
                                        @if($item->item_type === 'product')
                                            <div class="row">
                                                <div class="col-md-5 mb-3">
                                                    <label class="form-label">Product *</label>
                                                    <select name="items[{{ $index }}][product_id]" class="form-select product-select" required>
                                                        <option value="">Select Product</option>
                                                        @foreach($products as $product)
                                                            <option value="{{ $product->id }}" 
                                                                    data-cost="{{ $product->cost_price }}"
                                                                    data-stock="{{ $product->stock }}"
                                                                    data-has-expiry="{{ $product->has_expiry }}"
                                                                    data-track-batches="{{ $product->track_batches }}"
                                                                    {{ $item->product_id == $product->id ? 'selected' : '' }}>
                                                                {{ $product->name }} ({{ $product->sku }})
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="col-md-2 mb-3">
                                                    <label class="form-label">Quantity *</label>
                                                    <input type="number" name="items[{{ $index }}][quantity]" 
                                                           class="form-control quantity-input" min="0.001" step="0.001" 
                                                           value="{{ $item->quantity }}" required>
                                                </div>
                                                <div class="col-md-3 mb-3">
                                                    <label class="form-label">Unit Price *</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">KES</span>
                                                        <input type="number" name="items[{{ $index }}][unit_price]" 
                                                               class="form-control price-input" min="0" step="0.01" 
                                                               value="{{ $item->unit_price }}" required>
                                                    </div>
                                                </div>
                                                <div class="col-md-2 mb-3">
                                                    <label class="form-label">Total</label>
                                                    <input type="text" class="form-control item-total" 
                                                           value="KES {{ number_format($item->total, 2) }}" readonly>
                                                </div>
                                            </div>
                                            
                                            <!-- Batch Fields for Product -->
                                            <div class="batch-fields-edit">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        <label class="form-label">Batch Number</label>
                                                        <input type="text" name="items[{{ $index }}][batch_number]" 
                                                               class="form-control" value="{{ $item->batch_number }}" 
                                                               placeholder="Optional">
                                                    </div>
                                                    <div class="col-md-6 mb-3">
                                                        <label class="form-label">Expiry Date</label>
                                                        <input type="date" name="items[{{ $index }}][expiry_date]" 
                                                               class="form-control" 
                                                               value="{{ $item->expiry_date ? $item->expiry_date->format('Y-m-d') : '' }}">
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <input type="hidden" name="items[{{ $index }}][type]" value="product">
                                            <input type="hidden" name="items[{{ $index }}][description]" value="">
                                            <input type="hidden" name="items[{{ $index }}][id]" value="{{ $item->id }}">
                                            
                                        @else
                                            <!-- Service Item -->
                                            <div class="row">
                                                <div class="col-md-5 mb-3">
                                                    <label class="form-label">Service Description *</label>
                                                    <input type="text" name="items[{{ $index }}][description]" 
                                                           class="form-control service-description" 
                                                           value="{{ $item->description }}" required>
                                                </div>
                                                <div class="col-md-2 mb-3">
                                                    <label class="form-label">Quantity *</label>
                                                    <input type="number" name="items[{{ $index }}][quantity]" 
                                                           class="form-control quantity-input" min="0.001" step="0.001" 
                                                           value="{{ $item->quantity }}" required>
                                                </div>
                                                <div class="col-md-3 mb-3">
                                                    <label class="form-label">Unit Price *</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">KES</span>
                                                        <input type="number" name="items[{{ $index }}][unit_price]" 
                                                               class="form-control price-input" min="0" step="0.01" 
                                                               value="{{ $item->unit_price }}" required>
                                                    </div>
                                                </div>
                                                <div class="col-md-2 mb-3">
                                                    <label class="form-label">Total</label>
                                                    <input type="text" class="form-control item-total" 
                                                           value="KES {{ number_format($item->total, 2) }}" readonly>
                                                </div>
                                            </div>
                                            
                                            <input type="hidden" name="items[{{ $index }}][type]" value="service">
                                            <input type="hidden" name="items[{{ $index }}][id]" value="{{ $item->id }}">
                                        @endif
                                        
                                        <div class="row">
                                            <div class="col-md-12">
                                                <label class="form-label">Notes (Optional)</label>
                                                <textarea name="items[{{ $index }}][notes]" class="form-control" rows="2">{{ $item->notes }}</textarea>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            
                            <div class="text-center">
                                <button type="button" class="btn add-item-btn-syndron" onclick="addNewItem()">
                                    <i class="bx bx-plus"></i> Add New Item
                                </button>
                            </div>
                        </div>
                        
                        <!-- Payment & Status -->
                        <div class="form-section-syndron">
                            <h5 class="mb-3"><i class="bx bx-money me-2"></i> Payment & Status</h5>
                            <div class="row">
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Payment Status *</label>
                                    <select name="payment_status" class="form-select" required>
                                        <option value="pending" {{ $purchase->payment_status == 'pending' ? 'selected' : '' }}>Pending</option>
                                        <option value="partial" {{ $purchase->payment_status == 'partial' ? 'selected' : '' }}>Partial</option>
                                        <option value="paid" {{ $purchase->payment_status == 'paid' ? 'selected' : '' }}>Paid</option>
                                    </select>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Payment Method</label>
                                    <select name="payment_method" class="form-select">
                                        <option value="">Select Method</option>
                                        <option value="cash" {{ $purchase->payment_method == 'cash' ? 'selected' : '' }}>Cash</option>
                                        <option value="bank" {{ $purchase->payment_method == 'bank' ? 'selected' : '' }}>Bank Transfer</option>
                                        <option value="mpesa" {{ $purchase->payment_method == 'mpesa' ? 'selected' : '' }}>M-Pesa</option>
                                        <option value="cheque" {{ $purchase->payment_method == 'cheque' ? 'selected' : '' }}>Cheque</option>
                                        <option value="credit" {{ $purchase->payment_method == 'credit' ? 'selected' : '' }}>Credit</option>
                                    </select>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Amount Paid *</label>
                                    <div class="input-group">
                                        <span class="input-group-text">KES</span>
                                        <input type="number" name="paid_amount" class="form-control" 
                                               value="{{ $purchase->paid_amount }}" min="0" step="0.01" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Order Status *</label>
                                    <select name="status" class="form-select" required>
                                        <option value="draft" {{ $purchase->status == 'draft' ? 'selected' : '' }}>Draft</option>
                                        <option value="pending" {{ $purchase->status == 'pending' ? 'selected' : '' }}>Pending</option>
                                        <option value="completed" {{ $purchase->status == 'completed' ? 'selected' : '' }}>Completed</option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <div class="form-check mt-4">
                                        <input type="checkbox" name="add_to_stock" id="addToStock" 
                                               class="form-check-input" {{ $purchase->items()->where('added_to_stock', true)->exists() ? 'checked disabled' : '' }}>
                                        <label class="form-check-label" for="addToStock">
                                            Add items to inventory stock
                                        </label>
                                        @if($purchase->items()->where('added_to_stock', true)->exists())
                                            <small class="text-muted d-block">Some items are already in stock</small>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Notes -->
                        <div class="form-section-syndron">
                            <h5 class="mb-3"><i class="bx bx-note me-2"></i> Additional Information</h5>
                            <div class="mb-3">
                                <label class="form-label">Notes</label>
                                <textarea name="notes" class="form-control" rows="4" placeholder="Any special notes about this purchase...">{{ $purchase->notes }}</textarea>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Terms & Conditions</label>
                                <textarea name="terms_conditions" class="form-control" rows="3" placeholder="Terms and conditions...">{{ $purchase->terms_conditions }}</textarea>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Right Column - Summary & Actions -->
                <div class="col-lg-4">
                    <!-- Order Summary -->
                    <div class="edit-card-syndron">
                        <div class="form-section-syndron">
                            <h5 class="mb-3"><i class="bx bx-calculator me-2"></i> Order Summary</h5>
                            <div class="summary-card-edit">
                                <div class="summary-row">
                                    <span>Subtotal:</span>
                                    <span id="summarySubtotal">KES {{ number_format($purchase->subtotal, 2) }}</span>
                                </div>
                                <div class="summary-row">
                                    <span>Tax:</span>
                                    <span id="summaryTax">KES {{ number_format($purchase->tax_amount, 2) }}</span>
                                </div>
                                <div class="summary-row">
                                    <span>Discount:</span>
                                    <span id="summaryDiscount">KES 0.00</span>
                                </div>
                                <div class="summary-row total">
                                    <span>Grand Total:</span>
                                    <span id="summaryGrandTotal">KES {{ number_format($purchase->grand_total, 2) }}</span>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Action Buttons -->
                        <div class="form-section-syndron">
                            <h5 class="mb-3"><i class="bx bx-cog me-2"></i> Actions</h5>
                            <div class="action-buttons-edit">
                                <button type="submit" class="btn btn-primary">
                                    <i class="bx bx-save"></i> Update Purchase
                                </button>
                                <a href="{{ route('purchases.show', $purchase) }}" class="btn btn-secondary">
                                    <i class="bx bx-x"></i> Cancel
                                </a>
                                <button type="button" class="btn btn-danger" onclick="showDeleteModal()">
                                    <i class="bx bx-trash"></i> Delete
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Quick Info -->
                    <div class="edit-card-syndron mt-3">
                        <div class="form-section-syndron">
                            <h5 class="mb-3"><i class="bx bx-info-circle me-2"></i> Quick Information</h5>
                            <div class="mb-3">
                                <label class="form-label">Created By</label>
                                <input type="text" class="form-control" 
                                       value="{{ $purchase->creator->name ?? 'System' }}" readonly>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Created Date</label>
                                <input type="text" class="form-control" 
                                       value="{{ $purchase->created_at->format('M d, Y h:i A') }}" readonly>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Last Updated</label>
                                <input type="text" class="form-control" 
                                       value="{{ $purchase->updated_at->format('M d, Y h:i A') }}" readonly>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="bx bx-trash me-2"></i> Delete Purchase</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete purchase <strong>{{ $purchase->invoice_no }}</strong>?</p>
                <p class="text-danger"><strong>Warning:</strong> This action cannot be undone.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form action="{{ route('purchases.destroy', $purchase) }}" method="POST" style="display: inline;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Delete Purchase</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Item Template (Hidden) -->
<div id="itemTemplate" style="display: none;">
    <div class="item-card-edit inventory" data-index="__INDEX__">
        <button type="button" class="remove-item-btn" onclick="removeItem(this)">
            <i class="bx bx-trash"></i>
        </button>
        
        <div class="row">
            <div class="col-md-5 mb-3">
                <label class="form-label">Product *</label>
                <select name="items[__INDEX__][product_id]" class="form-select product-select" required>
                    <option value="">Select Product</option>
                    @foreach($products as $product)
                        <option value="{{ $product->id }}" 
                                data-cost="{{ $product->cost_price }}"
                                data-stock="{{ $product->stock }}"
                                data-has-expiry="{{ $product->has_expiry }}"
                                data-track-batches="{{ $product->track_batches }}">
                            {{ $product->name }} ({{ $product->sku }})
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-2 mb-3">
                <label class="form-label">Quantity *</label>
                <input type="number" name="items[__INDEX__][quantity]" 
                       class="form-control quantity-input" min="0.001" step="0.001" value="1" required>
            </div>
            <div class="col-md-3 mb-3">
                <label class="form-label">Unit Price *</label>
                <div class="input-group">
                    <span class="input-group-text">KES</span>
                    <input type="number" name="items[__INDEX__][unit_price]" 
                           class="form-control price-input" min="0" step="0.01" required>
                </div>
            </div>
            <div class="col-md-2 mb-3">
                <label class="form-label">Total</label>
                <input type="text" class="form-control item-total" value="KES 0.00" readonly>
            </div>
        </div>
        
        <!-- Batch Fields -->
        <div class="batch-fields-edit" style="display: none;">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Batch Number</label>
                    <input type="text" name="items[__INDEX__][batch_number]" 
                           class="form-control" placeholder="Optional">
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Expiry Date</label>
                    <input type="date" name="items[__INDEX__][expiry_date]" 
                           class="form-control" min="{{ date('Y-m-d', strtotime('+1 day')) }}">
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-12">
                <label class="form-label">Notes (Optional)</label>
                <textarea name="items[__INDEX__][notes]" class="form-control" rows="2"></textarea>
            </div>
        </div>
        
        <input type="hidden" name="items[__INDEX__][type]" value="product">
        <input type="hidden" name="items[__INDEX__][description]" value="">
    </div>
</div>

<!-- Service Item Template (Hidden) -->
<div id="serviceItemTemplate" style="display: none;">
    <div class="item-card-edit service" data-index="__INDEX__">
        <button type="button" class="remove-item-btn" onclick="removeItem(this)">
            <i class="bx bx-trash"></i>
        </button>
        
        <div class="row">
            <div class="col-md-5 mb-3">
                <label class="form-label">Service Description *</label>
                <input type="text" name="items[__INDEX__][description]" 
                       class="form-control service-description" required placeholder="Enter service description">
            </div>
            <div class="col-md-2 mb-3">
                <label class="form-label">Quantity *</label>
                <input type="number" name="items[__INDEX__][quantity]" 
                       class="form-control quantity-input" min="0.001" step="0.001" value="1" required>
            </div>
            <div class="col-md-3 mb-3">
                <label class="form-label">Unit Price *</label>
                <div class="input-group">
                    <span class="input-group-text">KES</span>
                    <input type="number" name="items[__INDEX__][unit_price]" 
                           class="form-control price-input" min="0" step="0.01" required>
                </div>
            </div>
            <div class="col-md-2 mb-3">
                <label class="form-label">Total</label>
                <input type="text" class="form-control item-total" value="KES 0.00" readonly>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-12">
                <label class="form-label">Notes (Optional)</label>
                <textarea name="items[__INDEX__][notes]" class="form-control" rows="2"></textarea>
            </div>
        </div>
        
        <input type="hidden" name="items[__INDEX__][type]" value="service">
    </div>
</div>
@endsection

@section('script')
<script>
let itemIndex = {{ $purchase->items->count() }};

$(document).ready(function() {
    // Initialize Select2 if available
    if (typeof $.fn.select2 !== 'undefined') {
        $('.product-select').select2({
            theme: 'bootstrap4',
            placeholder: 'Select product'
        });
        
        $('select[name="supplier_id"]').select2({
            theme: 'bootstrap4',
            placeholder: 'Select supplier'
        });
    }
    
    // Calculate initial totals
    calculateAllTotals();
    
    // Set up event listeners
    $(document).on('change keyup', '.quantity-input, .price-input, .product-select', function() {
        const itemCard = $(this).closest('.item-card-edit');
        const index = itemCard.data('index');
        calculateItemTotal(index);
        calculateSummary();
    });
    
    $(document).on('change', '.product-select', function() {
        const itemCard = $(this).closest('.item-card-edit');
        const batchFields = itemCard.find('.batch-fields-edit');
        const selectedOption = $(this).find('option:selected');
        const hasExpiry = selectedOption.data('has-expiry') === '1' || selectedOption.data('has-expiry') === 1;
        const trackBatches = selectedOption.data('track-batches') === '1' || selectedOption.data('track-batches') === 1;
        const costPrice = selectedOption.data('cost') || 0;
        
        // Show/hide batch fields
        if (hasExpiry || trackBatches) {
            batchFields.show();
        } else {
            batchFields.hide();
        }
        
        // Set default price
        const priceInput = itemCard.find('.price-input');
        if (!priceInput.val() || priceInput.val() === '0' || priceInput.val() === '0.00') {
            priceInput.val(costPrice);
            calculateItemTotal(itemCard.data('index'));
        }
    });
    
    // Form submission
    $('#editPurchaseForm').on('submit', function(e) {
        e.preventDefault();
        
        if (!validateForm()) {
            return false;
        }
        
        Swal.fire({
            title: 'Updating Purchase...',
            text: 'Please wait while we update your purchase',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });
        
        // Submit form via AJAX for better UX
        const formData = new FormData(this);
        
        fetch(this.action, {
            method: 'POST',
            body: formData,
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            }
        })
        .then(response => response.json())
        .then(data => {
            Swal.close();
            
            if (data.success || data.redirect) {
                Swal.fire({
                    title: 'Success!',
                    text: 'Purchase updated successfully',
                    icon: 'success',
                    confirmButtonColor: '#10B981',
                }).then(() => {
                    window.location.href = data.redirect || '{{ route("purchases.show", $purchase) }}';
                });
            } else {
                Swal.fire({
                    title: 'Error!',
                    text: data.message || 'Failed to update purchase',
                    icon: 'error',
                    confirmButtonColor: '#EF4444',
                });
            }
        })
        .catch(error => {
            Swal.close();
            Swal.fire({
                title: 'Error!',
                text: 'Failed to update purchase. Please try again.',
                icon: 'error',
                confirmButtonColor: '#EF4444',
            });
        });
    });
});

function addNewItem() {
    Swal.fire({
        title: 'Add Item Type',
        text: 'Select the type of item to add',
        icon: 'question',
        showCancelButton: true,
        showDenyButton: true,
        confirmButtonText: 'Product',
        denyButtonText: 'Service',
        cancelButtonText: 'Cancel',
        confirmButtonColor: '#10B981',
        denyButtonColor: '#3B82F6',
        cancelButtonColor: '#6c757d'
    }).then((result) => {
        if (result.isConfirmed) {
            addProductItem();
        } else if (result.isDenied) {
            addServiceItem();
        }
    });
}

function addProductItem() {
    const template = $('#itemTemplate').html();
    const html = template.replace(/__INDEX__/g, itemIndex);
    
    $('#purchaseItemsContainer').append(html);
    
    // Initialize Select2 for new select
    if (typeof $.fn.select2 !== 'undefined') {
        $(`[name="items[${itemIndex}][product_id]"]`).select2({
            theme: 'bootstrap4',
            placeholder: 'Select product'
        });
    }
    
    itemIndex++;
}

function addServiceItem() {
    const template = $('#serviceItemTemplate').html();
    const html = template.replace(/__INDEX__/g, itemIndex);
    
    $('#purchaseItemsContainer').append(html);
    itemIndex++;
}

function removeItem(button) {
    const items = $('#purchaseItemsContainer .item-card-edit');
    
    if (items.length > 1) {
        Swal.fire({
            title: 'Remove Item',
            text: 'Are you sure you want to remove this item?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#EF4444',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, remove it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $(button).closest('.item-card-edit').remove();
                calculateSummary();
            }
        });
    } else {
        Swal.fire({
            title: 'Cannot Remove',
            text: 'At least one item is required in the purchase',
            icon: 'warning',
            confirmButtonColor: '#F59E0B',
        });
    }
}

function calculateItemTotal(index) {
    const itemCard = $(`.item-card-edit[data-index="${index}"]`);
    const quantity = parseFloat(itemCard.find('.quantity-input').val()) || 0;
    const price = parseFloat(itemCard.find('.price-input').val()) || 0;
    const total = quantity * price;
    
    itemCard.find('.item-total').val('KES ' + total.toFixed(2));
}

function calculateAllTotals() {
    $('.item-card-edit').each(function() {
        const index = $(this).data('index');
        calculateItemTotal(index);
    });
    calculateSummary();
}

function calculateSummary() {
    let subtotal = 0;
    
    $('.item-card-edit').each(function() {
        const quantity = parseFloat($(this).find('.quantity-input').val()) || 0;
        const price = parseFloat($(this).find('.price-input').val()) || 0;
        subtotal += quantity * price;
    });
    
    // For now, assume 16% tax
    const taxRate = 16;
    const tax = subtotal * (taxRate / 100);
    const grandTotal = subtotal + tax;
    
    $('#summarySubtotal').text('KES ' + subtotal.toFixed(2));
    $('#summaryTax').text('KES ' + tax.toFixed(2));
    $('#summaryGrandTotal').text('KES ' + grandTotal.toFixed(2));
}

function validateForm() {
    let isValid = true;
    const errors = [];
    
    // Check supplier
    if (!$('select[name="supplier_id"]').val()) {
        errors.push('Please select a supplier');
        $('select[name="supplier_id"]').addClass('is-invalid');
        isValid = false;
    }
    
    // Check items
    $('.item-card-edit').each(function() {
        const productSelect = $(this).find('.product-select');
        const serviceDesc = $(this).find('.service-description');
        const quantity = $(this).find('.quantity-input');
        const price = $(this).find('.price-input');
        
        if (productSelect.length > 0 && !productSelect.val()) {
            errors.push('Please select a product for all items');
            productSelect.addClass('is-invalid');
            isValid = false;
        }
        
        if (serviceDesc.length > 0 && !serviceDesc.val()) {
            errors.push('Please enter description for all service items');
            serviceDesc.addClass('is-invalid');
            isValid = false;
        }
        
        if (!quantity.val() || parseFloat(quantity.val()) <= 0) {
            errors.push('Please enter valid quantity for all items');
            quantity.addClass('is-invalid');
            isValid = false;
        }
        
        if (!price.val() || parseFloat(price.val()) < 0) {
            errors.push('Please enter valid price for all items');
            price.addClass('is-invalid');
            isValid = false;
        }
    });
    
    if (!isValid) {
        Swal.fire({
            title: 'Validation Error',
            html: errors.map(error => `<p>• ${error}</p>`).join(''),
            icon: 'error',
            confirmButtonColor: '#EF4444',
        });
    }
    
    return isValid;
}

function showDeleteModal() {
    const modal = new bootstrap.Modal(document.getElementById('deleteModal'));
    modal.show();
}
</script>
@endsection