@extends('layouts.app')

@section('content')
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Batches</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item"><a href="{{ route('batches.index') }}">All Batches</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Batch Details</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                    <a href="{{ route('batches.edit', $batch) }}" class="btn btn-outline-primary">
                        <i class="bx bx-edit"></i> Edit
                    </a>
                    <a href="{{ route('batches.index') }}" class="btn btn-outline-secondary">
                        <i class="bx bx-arrow-back"></i> Back
                    </a>
                </div>
            </div>
        </div>
        <!--end breadcrumb-->

        <!-- Batch Details -->
        <div class="row">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title mb-4">Batch Information</h5>
                        
                        @if(session('success'))
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <i class="bx bx-check-circle"></i> {{ session('success') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        @endif

                        @if(session('error'))
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <i class="bx bx-error-circle"></i> {{ session('error') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        @endif

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Batch Number</label>
                                <div class="form-control bg-light">{{ $batch->batch_number }}</div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Product</label>
                                <div class="form-control bg-light">
                                    <a href="{{ route('products.show', $batch->product) }}" class="text-primary">
                                        {{ $batch->product->name }} ({{ $batch->product->sku }})
                                    </a>
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Supplier</label>
                                <div class="form-control bg-light">{{ $batch->supplier->name ?? 'N/A' }}</div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Warehouse Location</label>
                                <div class="form-control bg-light">{{ $batch->warehouse_location ?? 'Default' }}</div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Manufacture Date</label>
                                <div class="form-control bg-light">
                                    {{ $batch->manufacture_date ? $batch->manufacture_date->format('Y-m-d') : 'N/A' }}
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Expiry Date</label>
                                <div class="form-control bg-light">
                                    @if($batch->expiry_date)
                                        {{ $batch->expiry_date->format('Y-m-d') }}
                                        @if($batch->expiry_date < now())
                                            <span class="badge bg-danger ms-2">Expired</span>
                                        @elseif($batch->expiry_date <= now()->addDays(30))
                                            <span class="badge bg-warning ms-2">Expiring Soon</span>
                                        @endif
                                    @else
                                        No expiry
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Cost Price</label>
                                <div class="form-control bg-light">${{ number_format($batch->batch_cost_price, 2) }}</div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Sale Price</label>
                                <div class="form-control bg-light">${{ number_format($batch->batch_sale_price, 2) }}</div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Initial Quantity</label>
                                <div class="form-control bg-light">{{ $batch->initial_quantity }}</div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Current Quantity</label>
                                <div class="form-control bg-light">
                                    {{ $batch->current_quantity }}
                                    @if($batch->initial_quantity > 0)
                                        <div class="progress mt-2" style="height: 8px;">
                                            <div class="progress-bar 
                                                @if($batch->current_quantity == 0) bg-secondary
                                                @elseif($batch->current_quantity <= $batch->initial_quantity * 0.2) bg-danger
                                                @elseif($batch->current_quantity <= $batch->initial_quantity * 0.5) bg-warning
                                                @else bg-success @endif" 
                                                style="width: {{ ($batch->current_quantity / $batch->initial_quantity) * 100 }}%">
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>
                            @if($batch->notes)
                            <div class="col-12 mb-3">
                                <label class="form-label">Notes</label>
                                <div class="form-control bg-light">{{ $batch->notes }}</div>
                            </div>
                            @endif
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Created By</label>
                                <div class="form-control bg-light">{{ $batch->creator->name ?? 'System' }}</div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Created At</label>
                                <div class="form-control bg-light">{{ $batch->created_at->format('Y-m-d H:i:s') }}</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Batch Statistics -->
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title mb-4">Batch Statistics</h5>
                        <div class="row">
                            <div class="col-12 mb-3">
                                <div class="d-flex justify-content-between">
                                    <span>Total Movements:</span>
                                    <strong>{{ $batchStats['total_movements'] }}</strong>
                                </div>
                            </div>
                            <div class="col-12 mb-3">
                                <div class="d-flex justify-content-between">
                                    <span>Total Stock In:</span>
                                    <strong class="text-success">{{ $batchStats['total_in'] }}</strong>
                                </div>
                            </div>
                            <div class="col-12 mb-3">
                                <div class="d-flex justify-content-between">
                                    <span>Total Stock Out:</span>
                                    <strong class="text-danger">{{ $batchStats['total_out'] }}</strong>
                                </div>
                            </div>
                            <div class="col-12 mb-3">
                                <div class="d-flex justify-content-between">
                                    <span>Remaining Stock:</span>
                                    <strong>{{ $batchStats['remaining_quantity'] }}</strong>
                                </div>
                            </div>
                            <div class="col-12 mb-3">
                                <div class="d-flex justify-content-between">
                                    <span>Stock Usage:</span>
                                    <strong>{{ number_format($batchStats['remaining_percentage'], 1) }}%</strong>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="card mt-4">
                    <div class="card-body">
                        <h5 class="card-title mb-4">Quick Actions</h5>
                        <div class="d-grid gap-2">
                            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#adjustStockModal">
                                <i class="bx bx-transfer"></i> Adjust Stock
                            </button>
                            <a href="{{ route('batches.edit', $batch) }}" class="btn btn-outline-primary">
                                <i class="bx bx-edit"></i> Edit Batch
                            </a>
                            @if($batch->current_quantity > 0)
                            <button type="button" class="btn btn-warning" id="setExpiryDiscount">
                                <i class="bx bx-tag"></i> Set Expiry Discount
                            </button>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Stock Movements -->
        <div class="card mt-4">
            <div class="card-body">
                <h5 class="card-title mb-4">Recent Stock Movements</h5>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Type</th>
                                <th>Quantity</th>
                                <th>Before</th>
                                <th>After</th>
                                <th>Reason</th>
                                <th>User</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($stockMovements as $movement)
                                <tr>
                                    <td>{{ $movement->created_at->format('Y-m-d H:i') }}</td>
                                    <td>
                                        @if($movement->movement_type == 'in')
                                            <span class="badge bg-success">IN</span>
                                        @else
                                            <span class="badge bg-danger">OUT</span>
                                        @endif
                                    </td>
                                    <td>{{ $movement->quantity }}</td>
                                    <td>{{ $movement->quantity_before }}</td>
                                    <td>{{ $movement->quantity_before + $movement->quantity }}</td>
                                    <td>{{ $movement->reason }}</td>
                                    <td>{{ $movement->user->name ?? 'System' }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="text-center py-4">No stock movements found</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Adjust Stock Modal -->
<div class="modal fade" id="adjustStockModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Adjust Stock - {{ $batch->batch_number }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('batches.adjust-stock', $batch) }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Current Quantity</label>
                        <input type="text" class="form-control" value="{{ $batch->current_quantity }}" readonly>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Adjustment Type</label>
                        <select name="adjustment_type" class="form-select" required>
                            <option value="add">Add Stock</option>
                            <option value="remove">Remove Stock</option>
                            <option value="set">Set to Exact Value</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Quantity</label>
                        <input type="number" name="quantity" class="form-control" min="0" step="1" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Reason</label>
                        <input type="text" name="reason" class="form-control" placeholder="Physical count, damage, etc." required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Notes (Optional)</label>
                        <textarea name="notes" class="form-control" rows="2"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Save Adjustment</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('script')
<script>
    $(document).ready(function() {
        // Set expiry discount
        $('#setExpiryDiscount').click(function() {
            Swal.fire({
                title: 'Set Expiry Discount',
                input: 'number',
                inputLabel: 'Discount Percentage',
                inputPlaceholder: 'Enter discount %',
                inputAttributes: {
                    step: '0.01',
                    min: '0',
                    max: '100'
                },
                showCancelButton: true,
                confirmButtonText: 'Apply Discount',
                cancelButtonText: 'Cancel',
                inputValidator: (value) => {
                    if (!value || parseFloat(value) <= 0 || parseFloat(value) > 100) {
                        return 'Please enter a valid percentage (0-100)';
                    }
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '{{ route("products.set-expiry-discount", ":id") }}'.replace(':id', '{{ $batch->product_id }}'),
                        type: 'POST',
                        data: {
                            _token: '{{ csrf_token() }}',
                            discount_type: 'percent',
                            discount_value: result.value,
                            discount_reason: 'Batch expiry discount',
                            batch_id: '{{ $batch->id }}'
                        },
                        success: function(response) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Discount Applied',
                                text: response.message
                            }).then(() => {
                                location.reload();
                            });
                        },
                        error: function(xhr) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: xhr.responseJSON?.message || 'Failed to apply discount'
                            });
                        }
                    });
                }
            });
        });
    });
</script>
@endsection