@extends('layouts.app')

@section('style')
<style>
    .batch-detail-card {
        background: white;
        border-radius: 8px;
        padding: 20px;
        border: 1px solid #e2e8f0;
        margin-bottom: 20px;
    }
    .detail-label {
        color: #718096;
        font-size: 13px;
        font-weight: 500;
        margin-bottom: 4px;
    }
    .detail-value {
        color: #2d3748;
        font-weight: 500;
        font-size: 16px;
    }
    .status-badge {
        padding: 4px 10px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 500;
    }
    .status-active {
        background-color: #d1fae5;
        color: #065f46;
    }
    .status-expired {
        background-color: #fee2e2;
        color: #991b1b;
    }
    .status-expiring {
        background-color: #fef3c7;
        color: #92400e;
    }
    .status-empty {
        background-color: #e5e7eb;
        color: #6b7280;
    }
    .status-pending {
        background-color: #e0e7ff;
        color: #3730a3;
    }
    .status-rejected {
        background-color: #fee2e2;
        color: #991b1b;
    }
    .status-quarantine {
        background-color: #fef3c7;
        color: #92400e;
    }
    .stock-progress {
        height: 8px;
        border-radius: 4px;
        background-color: #e2e8f0;
        overflow: hidden;
    }
    .stock-progress-bar {
        height: 100%;
        transition: width 0.3s;
    }
    .movement-type-badge {
        padding: 3px 8px;
        border-radius: 4px;
        font-size: 11px;
        font-weight: 500;
    }
    .type-in {
        background-color: #d1fae5;
        color: #065f46;
    }
    .type-out {
        background-color: #fee2e2;
        color: #991b1b;
    }
    .type-adjustment {
        background-color: #e0e7ff;
        color: #3730a3;
    }
    .type-transfer {
        background-color: #f3e8ff;
        color: #6b21a8;
    }
    .action-buttons {
        position: sticky;
        top: 20px;
    }
</style>
@endsection

@section('content')
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Batches</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item"><a href="{{ route('batches.index') }}">Product Batches</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Batch Details</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                    <a href="{{ route('batches.index') }}" class="btn btn-outline-secondary">
                        <i class="bx bx-arrow-back"></i> Back to List
                    </a>
                    <button type="button" class="btn btn-primary dropdown-toggle dropdown-toggle-split" 
                            data-bs-toggle="dropdown" aria-expanded="false">
                        <span class="visually-hidden">Toggle Dropdown</span>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li>
                            <a class="dropdown-item" href="{{ route('batches.edit', $batch) }}">
                                <i class="bx bx-edit"></i> Edit Batch
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#adjustStockModal">
                                <i class="bx bx-transfer"></i> Adjust Stock
                            </a>
                        </li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <a class="dropdown-item text-danger" href="#" onclick="deleteBatch()">
                                <i class="bx bx-trash"></i> Delete Batch
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <!--end breadcrumb-->

        <div class="row">
            <!-- Left Column: Batch Details -->
            <div class="col-lg-8">
                <!-- Batch Header -->
                <div class="card mb-4">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-start">
                            <div>
                                <h4 class="mb-1">{{ $batch->batch_number }}</h4>
                                <div class="d-flex align-items-center gap-2 mb-3">
                                    <span class="status-badge status-{{ $batch->expiry_status }}">
                                        @if($batch->current_quantity <= 0)
                                            Empty
                                        @elseif($batch->is_expired)
                                            Expired
                                        @elseif($batch->is_expiring_soon)
                                            Expiring Soon
                                        @else
                                            Active
                                        @endif
                                    </span>
                                    <span class="status-badge status-{{ $batch->quality_status }}">
                                        {{ ucfirst($batch->quality_status) }}
                                    </span>
                                </div>
                            </div>
                            <div class="text-end">
                                <div class="h3 mb-0">${{ number_format($batch->batch_cost_price * $batch->current_quantity, 2) }}</div>
                                <small class="text-muted">Batch Value</small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Batch Details Grid -->
                <div class="row">
                    <!-- Product Information -->
                    <div class="col-md-6 mb-4">
                        <div class="batch-detail-card">
                            <h6 class="mb-3 border-bottom pb-2"><i class="bx bx-package me-2"></i>Product Information</h6>
                            <div class="mb-3">
                                <div class="detail-label">Product Name</div>
                                <div class="detail-value">
                                    <a href="{{ route('products.show', $batch->product) }}" class="text-dark">
                                        {{ $batch->product->name }}
                                    </a>
                                </div>
                                <small class="text-muted">SKU: {{ $batch->product->sku }}</small>
                            </div>
                            <div class="row">
                                <div class="col-6">
                                    <div class="detail-label">Category</div>
                                    <div class="detail-value">{{ $batch->product->category->name ?? 'N/A' }}</div>
                                </div>
                                <div class="col-6">
                                    <div class="detail-label">Brand</div>
                                    <div class="detail-value">{{ $batch->product->brand->name ?? 'N/A' }}</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Stock Information -->
                    <div class="col-md-6 mb-4">
                        <div class="batch-detail-card">
                            <h6 class="mb-3 border-bottom pb-2"><i class="bx bx-bar-chart me-2"></i>Stock Information</h6>
                            <div class="mb-3">
                                <div class="detail-label">Current Quantity</div>
                                <div class="detail-value">{{ $batch->current_quantity }} units</div>
                                <div class="stock-progress mt-2">
                                    <div class="stock-progress-bar bg-{{ $batch->current_quantity <= 0 ? 'secondary' : ($batch->is_expired ? 'danger' : ($batch->is_expiring_soon ? 'warning' : 'success')) }}" 
                                         style="width: {{ $batch->initial_quantity > 0 ? ($batch->current_quantity / $batch->initial_quantity) * 100 : 0 }}%">
                                    </div>
                                </div>
                                <small class="text-muted">{{ $batch->current_quantity }} of {{ $batch->initial_quantity }} remaining</small>
                            </div>
                            <div class="row">
                                <div class="col-6">
                                    <div class="detail-label">Reserved</div>
                                    <div class="detail-value">{{ $batch->reserved_quantity }} units</div>
                                </div>
                                <div class="col-6">
                                    <div class="detail-label">Available</div>
                                    <div class="detail-value">{{ $batch->available_quantity }} units</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Dates Information -->
                    <div class="col-md-6 mb-4">
                        <div class="batch-detail-card">
                            <h6 class="mb-3 border-bottom pb-2"><i class="bx bx-calendar me-2"></i>Dates Information</h6>
                            <div class="row">
                                <div class="col-6">
                                    <div class="detail-label">Manufacture Date</div>
                                    <div class="detail-value">
                                        {{ $batch->manufacture_date ? $batch->manufacture_date->format('Y-m-d') : 'N/A' }}
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="detail-label">Expiry Date</div>
                                    <div class="detail-value">
                                        {{ $batch->expiry_date ? $batch->expiry_date->format('Y-m-d') : 'No Expiry' }}
                                    </div>
                                    @if($batch->expiry_date)
                                        <small class="text-{{ $batch->is_expired ? 'danger' : ($batch->is_expiring_soon ? 'warning' : 'muted') }}">
                                            {{ $batch->days_to_expiry >= 0 ? $batch->days_to_expiry . ' days remaining' : 'Expired ' . abs($batch->days_to_expiry) . ' days ago' }}
                                        </small>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Pricing Information -->
                    <div class="col-md-6 mb-4">
                        <div class="batch-detail-card">
                            <h6 class="mb-3 border-bottom pb-2"><i class="bx bx-dollar-circle me-2"></i>Pricing Information</h6>
                            <div class="row">
                                <div class="col-6">
                                    <div class="detail-label">Cost Price</div>
                                    <div class="detail-value">${{ number_format($batch->batch_cost_price, 2) }}</div>
                                    <small class="text-muted">per unit</small>
                                </div>
                                <div class="col-6">
                                    <div class="detail-label">Sale Price</div>
                                    <div class="detail-value">
                                        @if($batch->batch_sale_price)
                                            ${{ number_format($batch->batch_sale_price, 2) }}
                                        @else
                                            N/A
                                        @endif
                                    </div>
                                </div>
                            </div>
                            @if($batch->batch_sale_price && $batch->batch_cost_price > 0)
                                @php
                                    $profitMargin = (($batch->batch_sale_price - $batch->batch_cost_price) / $batch->batch_sale_price) * 100;
                                @endphp
                                <div class="mt-3">
                                    <div class="detail-label">Profit Margin</div>
                                    <div class="detail-value">{{ number_format($profitMargin, 1) }}%</div>
                                    <small class="text-muted">
                                        ${{ number_format($batch->batch_sale_price - $batch->batch_cost_price, 2) }} per unit
                                    </small>
                                </div>
                            @endif
                        </div>
                    </div>

                    <!-- Supplier & Location -->
                    <div class="col-md-6 mb-4">
                        <div class="batch-detail-card">
                            <h6 class="mb-3 border-bottom pb-2"><i class="bx bx-store me-2"></i>Supplier Information</h6>
                            @if($batch->supplier)
                                <div class="mb-3">
                                    <div class="detail-label">Supplier Name</div>
                                    <div class="detail-value">
                                        <a href="{{ route('suppliers.show', $batch->supplier) }}" class="text-dark">
                                            {{ $batch->supplier->name }}
                                        </a>
                                    </div>
                                    <small class="text-muted">{{ $batch->supplier->email }} | {{ $batch->supplier->phone }}</small>
                                </div>
                            @else
                                <div class="text-center py-3">
                                    <i class="bx bx-store text-muted display-6"></i>
                                    <p class="text-muted mt-2">No supplier assigned</p>
                                </div>
                            @endif
                        </div>
                    </div>

                    <!-- Warehouse Location -->
                    <div class="col-md-6 mb-4">
                        <div class="batch-detail-card">
                            <h6 class="mb-3 border-bottom pb-2"><i class="bx bx-map me-2"></i>Warehouse Location</h6>
                            @if($batch->warehouse_location)
                                <div class="mb-3">
                                    <div class="detail-label">Storage Location</div>
                                    <div class="detail-value">{{ $batch->warehouse_location }}</div>
                                </div>
                            @else
                                <div class="text-center py-3">
                                    <i class="bx bx-map text-muted display-6"></i>
                                    <p class="text-muted mt-2">No location specified</p>
                                </div>
                            @endif
                        </div>
                    </div>

                    <!-- Quality Control -->
                    <div class="col-12 mb-4">
                        <div class="batch-detail-card">
                            <h6 class="mb-3 border-bottom pb-2"><i class="bx bx-check-shield me-2"></i>Quality Control</h6>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="detail-label">Status</div>
                                    <div class="mb-2">
                                        <span class="status-badge status-{{ $batch->quality_status }}">
                                            {{ ucfirst($batch->quality_status) }}
                                        </span>
                                    </div>
                                </div>
                                <div class="col-md-8">
                                    <div class="detail-label">Notes</div>
                                    <div class="detail-value">
                                        @if($batch->quality_notes)
                                            {{ $batch->quality_notes }}
                                        @else
                                            <span class="text-muted">No quality notes</span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Additional Notes -->
                    @if($batch->notes)
                    <div class="col-12 mb-4">
                        <div class="batch-detail-card">
                            <h6 class="mb-3 border-bottom pb-2"><i class="bx bx-note me-2"></i>Additional Notes</h6>
                            <div class="detail-value">{{ $batch->notes }}</div>
                        </div>
                    </div>
                    @endif
                </div>

                <!-- Stock Movements -->
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <h5 class="card-title mb-0">Stock Movements</h5>
                            <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#adjustStockModal">
                                <i class="bx bx-plus"></i> Add Movement
                            </button>
                        </div>

                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Date</th>
                                        <th>Type</th>
                                        <th>Quantity Before</th>
                                        <th>Quantity Change</th>
                                        <th>Quantity After</th>
                                        <th>Reason</th>
                                        <th>User</th>
                                        <th>Reference</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($stockMovements as $movement)
                                        <tr>
                                            <td>{{ $movement->created_at->format('Y-m-d H:i') }}</td>
                                            <td>
                                                <span class="movement-type-badge type-{{ $movement->movement_type }}">
                                                    {{ ucfirst($movement->movement_type) }}
                                                </span>
                                            </td>
                                            <td>{{ $movement->quantity_before }}</td>
                                            <td class="{{ $movement->quantity >= 0 ? 'text-success' : 'text-danger' }}">
                                                {{ $movement->formatted_quantity }}
                                            </td>
                                            <td>{{ $movement->quantity_after }}</td>
                                            <td>{{ $movement->reason ?? 'N/A' }}</td>
                                            <td>{{ $movement->user->name ?? 'System' }}</td>
                                            <td>{{ $movement->reference_number ?? 'N/A' }}</td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="8" class="text-center py-4">
                                                <i class="bx bx-package display-4 text-muted mb-2"></i>
                                                <p class="text-muted">No stock movements found</p>
                                            </td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>

                        @if($stockMovements->hasPages())
                            <div class="d-flex justify-content-center mt-3">
                                {{ $stockMovements->links() }}
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Right Column: Actions & Statistics -->
            <div class="col-lg-4">
                <div class="action-buttons">
                    <!-- Quick Actions -->
                    <div class="card mb-4">
                        <div class="card-body">
                            <h6 class="card-title mb-3">Quick Actions</h6>
                            <div class="d-grid gap-2">
                                <a href="{{ route('batches.edit', $batch) }}" class="btn btn-outline-primary">
                                    <i class="bx bx-edit"></i> Edit Batch Details
                                </a>
                                <button type="button" class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#adjustStockModal">
                                    <i class="bx bx-transfer"></i> Adjust Stock
                                </button>
                                <a href="{{ route('products.batches', $batch->product) }}" class="btn btn-outline-info">
                                    <i class="bx bx-list-ul"></i> View All Product Batches
                                </a>
                                @if($batch->is_expiring_soon || $batch->is_expired)
                                    <button type="button" class="btn btn-outline-warning" onclick="setExpiryDiscount()">
                                        <i class="bx bx-tag"></i> Set Expiry Discount
                                    </button>
                                @endif
                                <button type="button" class="btn btn-outline-danger" onclick="deleteBatch()">
                                    <i class="bx bx-trash"></i> Delete Batch
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Batch Statistics -->
                    <div class="card mb-4">
                        <div class="card-body">
                            <h6 class="card-title mb-3">Batch Statistics</h6>
                            <div class="row g-2">
                                <div class="col-6">
                                    <div class="text-center p-2 border rounded">
                                        <div class="h5 mb-1">{{ $batchStats['total_movements'] ?? 0 }}</div>
                                        <small class="text-muted">Total Movements</small>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="text-center p-2 border rounded">
                                        <div class="h5 mb-1">{{ $batchStats['total_in'] ?? 0 }}</div>
                                        <small class="text-muted">Stock In</small>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="text-center p-2 border rounded">
                                        <div class="h5 mb-1">{{ $batchStats['total_out'] ?? 0 }}</div>
                                        <small class="text-muted">Stock Out</small>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="text-center p-2 border rounded">
                                        <div class="h5 mb-1">{{ number_format($batchStats['remaining_percentage'] ?? 0, 1) }}%</div>
                                        <small class="text-muted">Remaining</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Audit Information -->
                    <div class="card">
                        <div class="card-body">
                            <h6 class="card-title mb-3">Audit Information</h6>
                            <div class="mb-3">
                                <div class="detail-label">Created By</div>
                                <div class="detail-value">{{ $batch->creator->name ?? 'System' }}</div>
                            </div>
                            <div class="mb-3">
                                <div class="detail-label">Created At</div>
                                <div class="detail-value">{{ $batch->created_at->format('Y-m-d H:i') }}</div>
                            </div>
                            <div class="mb-3">
                                <div class="detail-label">Last Updated</div>
                                <div class="detail-value">{{ $batch->updated_at->format('Y-m-d H:i') }}</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Adjust Stock Modal -->
<div class="modal fade" id="adjustStockModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Adjust Stock - {{ $batch->batch_number }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('batches.adjust-stock', $batch) }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Current Quantity</label>
                        <input type="text" class="form-control" 
                               value="{{ $batch->current_quantity }}" readonly>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Adjustment Type</label>
                        <select name="adjustment_type" class="form-select" required>
                            <option value="add">Add Stock</option>
                            <option value="remove">Remove Stock</option>
                            <option value="set">Set to Exact Value</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Quantity</label>
                        <input type="number" name="quantity" class="form-control" 
                               min="0" step="1" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Reason</label>
                        <input type="text" name="reason" class="form-control" 
                               placeholder="Physical count, damage, etc." required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Notes (Optional)</label>
                        <textarea name="notes" class="form-control" rows="2"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Save Adjustment</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Delete Form -->
<form id="deleteForm" action="{{ route('batches.destroy', $batch) }}" method="POST" class="d-none">
    @csrf
    @method('DELETE')
</form>
@endsection

@section('script')
<script>
    $(document).ready(function() {
        // Delete batch confirmation
        window.deleteBatch = function() {
            Swal.fire({
                title: 'Delete Batch?',
                html: `
                    <p>Are you sure you want to delete batch <strong>{{ $batch->batch_number }}</strong>?</p>
                    <div class="alert alert-warning text-start">
                        <i class="bx bx-error"></i>
                        <strong>Warning:</strong> This action cannot be undone.
                        @if($batch->current_quantity > 0)
                            This batch has {{ $batch->current_quantity }} units in stock. Deleting it will also remove this stock from the product.
                        @endif
                    </div>
                `,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    $('#deleteForm').submit();
                }
            });
        };

        // Set expiry discount
        window.setExpiryDiscount = function() {
            Swal.fire({
                title: 'Set Expiry Discount',
                input: 'number',
                inputLabel: 'Discount Percentage',
                inputPlaceholder: 'Enter discount %',
                inputAttributes: {
                    step: '0.01',
                    min: '0',
                    max: '100'
                },
                showCancelButton: true,
                confirmButtonText: 'Apply Discount',
                cancelButtonText: 'Cancel',
                inputValidator: (value) => {
                    if (!value || parseFloat(value) <= 0 || parseFloat(value) > 100) {
                        return 'Please enter a valid percentage (0-100)';
                    }
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '{{ route("products.set-expiry-discount", $batch->product) }}',
                        type: 'POST',
                        data: {
                            _token: '{{ csrf_token() }}',
                            discount_type: 'percent',
                            discount_value: result.value,
                            discount_reason: 'Batch expiry discount',
                            batch_id: {{ $batch->id }}
                        },
                        success: function(response) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Discount Applied',
                                text: response.message
                            }).then(() => {
                                location.reload();
                            });
                        },
                        error: function(xhr) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: xhr.responseJSON?.message || 'Failed to apply discount'
                            });
                        }
                    });
                }
            });
        };

        // Auto-fill quantity based on adjustment type
        $('select[name="adjustment_type"]').change(function() {
            const adjustmentType = $(this).val();
            const currentQty = {{ $batch->current_quantity }};
            const quantityInput = $('input[name="quantity"]');
            
            switch(adjustmentType) {
                case 'add':
                    quantityInput.val(1);
                    quantityInput.attr('min', 1);
                    break;
                case 'remove':
                    quantityInput.val(1);
                    quantityInput.attr('min', 1);
                    quantityInput.attr('max', currentQty);
                    break;
                case 'set':
                    quantityInput.val(currentQty);
                    quantityInput.attr('min', 0);
                    quantityInput.removeAttr('max');
                    break;
            }
        });
    });
</script>
@endsection