@extends('layouts.app')

@section('style')
    <style>
        .stat-card {
            text-align: center;
            padding: 20px;
            border-radius: 10px;
            background: white;
            box-shadow: 0 4px 6px rgba(0,0,0,0.05);
            border: 1px solid #e5e7eb;
            transition: transform 0.2s;
        }
        .stat-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 12px rgba(0,0,0,0.1);
        }
        .stat-card .stat-value {
            font-size: 28px;
            font-weight: 700;
            color: #2d3748;
        }
        .stat-card .stat-label {
            font-size: 14px;
            color: #718096;
            margin-top: 5px;
        }
        .movement-card {
            border-left: 4px solid;
            border-radius: 8px;
            margin-bottom: 15px;
            transition: all 0.3s;
        }
        .movement-card:hover {
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }
        .movement-in {
            border-left-color: #10b981;
            background-color: rgba(16, 185, 129, 0.05);
        }
        .movement-out {
            border-left-color: #ef4444;
            background-color: rgba(239, 68, 68, 0.05);
        }
        .movement-type-badge {
            padding: 4px 8px;
            border-radius: 20px;
            font-size: 11px;
            font-weight: 600;
        }
        .badge-in {
            background-color: #d1fae5;
            color: #065f46;
        }
        .badge-out {
            background-color: #fee2e2;
            color: #991b1b;
        }
        .chart-container {
            background: white;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.05);
            border: 1px solid #e5e7eb;
        }
        .chart-title {
            font-size: 16px;
            font-weight: 600;
            margin-bottom: 15px;
            color: #374151;
        }
        .summary-table th {
            background-color: #f9fafb;
            font-weight: 600;
            color: #374151;
            border-bottom: 2px solid #e5e7eb;
        }
        .trend-indicator {
            display: inline-flex;
            align-items: center;
            padding: 4px 8px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 500;
        }
        .trend-up {
            background-color: #d1fae5;
            color: #065f46;
        }
        .trend-down {
            background-color: #fee2e2;
            color: #991b1b;
        }
        .trend-neutral {
            background-color: #f3f4f6;
            color: #6b7280;
        }
        .sparkline-container {
            height: 40px;
            width: 100px;
        }
        .filter-section {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 25px;
            border-left: 4px solid #667eea;
        }
        .export-btn {
            display: inline-flex;
            align-items: center;
            gap: 5px;
        }
        .timeline {
            position: relative;
            padding-left: 30px;
        }
        .timeline:before {
            content: '';
            position: absolute;
            left: 10px;
            top: 0;
            bottom: 0;
            width: 2px;
            background: linear-gradient(to bottom, #667eea, #10b981);
        }
        .timeline-item {
            position: relative;
            margin-bottom: 20px;
        }
        .timeline-item:before {
            content: '';
            position: absolute;
            left: -22px;
            top: 5px;
            width: 10px;
            height: 10px;
            border-radius: 50%;
            background: #667eea;
        }
        .legend-item {
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 14px;
        }
        .legend-color {
            width: 12px;
            height: 12px;
            border-radius: 2px;
        }
    </style>
@endsection

@section('content')
<div class="page-wrapper">
    <div class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Products</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}"><i class="bx bx-home-alt"></i></a></li>
                        <li class="breadcrumb-item"><a href="{{ route('products.index') }}">Products</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('products.show', $product) }}">{{ $product->name }}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Inventory History</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                    <a href="{{ route('products.stock-movements', $product) }}" class="btn btn-outline-secondary">
                        <i class="bx bx-transfer"></i> Stock Movements
                    </a>
                    <a href="{{ route('products.inventory-history.export', $product) }}" class="btn btn-success export-btn">
                        <i class="bx bx-download"></i> Export
                    </a>
                    <a href="{{ route('products.show', $product) }}" class="btn btn-primary">
                        <i class="bx bx-arrow-back"></i> Back to Product
                    </a>
                </div>
            </div>
        </div>
        <!--end breadcrumb-->

        <!-- Product Header -->
        <div class="card mb-4">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-8">
                        <h4 class="mb-2">{{ $product->name }}</h4>
                        <div class="row g-3">
                            <div class="col-sm-6 col-md-3">
                                <small class="text-muted d-block">SKU</small>
                                <strong>{{ $product->sku }}</strong>
                            </div>
                            <div class="col-sm-6 col-md-3">
                                <small class="text-muted d-block">Current Stock</small>
                                <strong class="h5">{{ $product->stock }}</strong>
                            </div>
                            <div class="col-sm-6 col-md-3">
                                <small class="text-muted d-block">Stock Value</small>
                                <strong class="h5">KES {{ number_format($stats['stock_value'], 2) }}</strong>
                            </div>
                            <div class="col-sm-6 col-md-3">
                                <small class="text-muted d-block">Inventory Age</small>
                                @php
                                    $firstMovement = $stats['first_movement_date'];
                                    $age = $firstMovement != 'No movements' ? 
                                           Carbon\Carbon::parse($firstMovement)->diffForHumans() : 
                                           'N/A';
                                @endphp
                                <strong>{{ $age }}</strong>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="d-flex justify-content-end">
                            <div class="text-end">
                                <div class="h3 mb-1">KES {{ number_format($product->sale_price, 2) }}</div>
                                <small class="text-muted">Current Price</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistics -->
        <div class="row row-cols-1 row-cols-md-4 row-cols-xl-4 mb-4">
            <div class="col">
                <div class="stat-card">
                    <div class="stat-value">{{ $stats['total_movements'] }}</div>
                    <div class="stat-label">Total Movements</div>
                </div>
            </div>
            <div class="col">
                <div class="stat-card">
                    <div class="stat-value text-success">{{ $stats['total_in'] }}</div>
                    <div class="stat-label">Total Stock In</div>
                </div>
            </div>
            <div class="col">
                <div class="stat-card">
                    <div class="stat-value text-danger">{{ $stats['total_out'] }}</div>
                    <div class="stat-label">Total Stock Out</div>
                </div>
            </div>
            <div class="col">
                <div class="stat-card">
                    <div class="stat-value {{ $stats['net_movement'] >= 0 ? 'text-success' : 'text-danger' }}">
                        {{ $stats['net_movement'] >= 0 ? '+' : '' }}{{ $stats['net_movement'] }}
                    </div>
                    <div class="stat-label">Net Movement</div>
                </div>
            </div>
        </div>

        <!-- Additional Statistics -->
        <div class="row row-cols-1 row-cols-md-3 row-cols-xl-3 mb-4">
            <div class="col">
                <div class="stat-card">
                    <div class="stat-value">{{ $stats['active_days'] }}</div>
                    <div class="stat-label">Active Days</div>
                </div>
            </div>
            <div class="col">
                <div class="stat-card">
                    <div class="stat-value">{{ $stats['daily_average'] }}</div>
                    <div class="stat-label">Avg Daily Movements</div>
                </div>
            </div>
            <div class="col">
                <div class="stat-card">
                    <div class="stat-value">{{ $stats['batches_involved'] }}</div>
                    <div class="stat-label">Batches Involved</div>
                </div>
            </div>
        </div>

        <!-- Charts Section -->
        <div class="row mb-4">
            <div class="col-lg-8">
                <div class="chart-container">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h6 class="chart-title mb-0">Stock Level Timeline (Last 90 Days)</h6>
                        <div class="d-flex gap-2">
                            <div class="legend-item">
                                <div class="legend-color" style="background-color: #10b981;"></div>
                                <span>Stock In</span>
                            </div>
                            <div class="legend-item">
                                <div class="legend-color" style="background-color: #ef4444;"></div>
                                <span>Stock Out</span>
                            </div>
                            <div class="legend-item">
                                <div class="legend-color" style="background-color: #667eea;"></div>
                                <span>Cumulative Stock</span>
                            </div>
                        </div>
                    </div>
                    <canvas id="stockChart" height="250"></canvas>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="chart-container">
                    <h6 class="chart-title">Movement Type Distribution</h6>
                    <canvas id="typeChart" height="250"></canvas>
                </div>
            </div>
        </div>

        <!-- Trends Section -->
        <div class="row mb-4">
            <div class="col-lg-6">
                <div class="chart-container">
                    <h6 class="chart-title">Monthly Trends</h6>
                    <div class="table-responsive">
                        <table class="table summary-table">
                            <thead>
                                <tr>
                                    <th>Month</th>
                                    <th>In</th>
                                    <th>Out</th>
                                    <th>Net</th>
                                    <th>Trend</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($trends['monthly'] as $month)
                                <tr>
                                    <td>{{ $month['month'] }}</td>
                                    <td class="text-success">{{ $month['in'] }}</td>
                                    <td class="text-danger">{{ $month['out'] }}</td>
                                    <td class="{{ $month['net'] >= 0 ? 'text-success' : 'text-danger' }}">
                                        {{ $month['net'] >= 0 ? '+' : '' }}{{ $month['net'] }}
                                    </td>
                                    <td>
                                        @if($month['net'] > 0)
                                            <span class="trend-indicator trend-up">
                                                <i class="bx bx-up-arrow-alt"></i> Increasing
                                            </span>
                                        @elseif($month['net'] < 0)
                                            <span class="trend-indicator trend-down">
                                                <i class="bx bx-down-arrow-alt"></i> Decreasing
                                            </span>
                                        @else
                                            <span class="trend-indicator trend-neutral">
                                                <i class="bx bx-minus"></i> Stable
                                            </span>
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="chart-container">
                    <h6 class="chart-title">Inventory Turnover Analysis</h6>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="text-center py-4">
                                <div class="display-4 text-primary">{{ $trends['turnover_rate']['rate'] }}</div>
                                <p class="text-muted">Turnover Rate</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="py-4">
                                <div class="mb-3">
                                    <small class="text-muted">Times per Year</small>
                                    <div class="h5">{{ $trends['turnover_rate']['times_per_year'] }}x</div>
                                </div>
                                <div class="mb-3">
                                    <small class="text-muted">Days Inventory</small>
                                    <div class="h5">{{ $trends['turnover_rate']['days_inventory'] }} days</div>
                                </div>
                                <div>
                                    <small class="text-muted">Average Stock</small>
                                    <div class="h5">{{ $trends['turnover_rate']['avg_stock'] }}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters -->
        <div class="filter-section">
            <form method="GET" action="{{ route('products.inventory-history', $product) }}" id="filterForm">
                <div class="row g-3">
                    <div class="col-md-3">
                        <label class="form-label">Movement Type</label>
                        <select name="movement_type" class="form-select">
                            <option value="">All Types</option>
                            <option value="in" {{ request('movement_type') == 'in' ? 'selected' : '' }}>Stock In</option>
                            <option value="out" {{ request('movement_type') == 'out' ? 'selected' : '' }}>Stock Out</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Date From</label>
                        <input type="date" name="start_date" class="form-control" 
                               value="{{ request('start_date') }}">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Date To</label>
                        <input type="date" name="end_date" class="form-control" 
                               value="{{ request('end_date') }}">
                    </div>
                    <div class="col-md-3 d-flex align-items-end">
                        <div class="d-flex gap-2 w-100">
                            <button type="submit" class="btn btn-outline-primary">
                                <i class="bx bx-filter"></i> Filter
                            </button>
                            <a href="{{ route('products.inventory-history', $product) }}" class="btn btn-outline-secondary">
                                <i class="bx bx-reset"></i> Reset
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <!-- Inventory Movements -->
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h5 class="card-title mb-0">Inventory Movement History</h5>
                    <div class="text-muted">
                        Showing {{ $movements->firstItem() }} to {{ $movements->lastItem() }} of {{ $movements->total() }} entries
                    </div>
                </div>

                @if($movements->isEmpty())
                    <div class="text-center py-5">
                        <i class="bx bx-history display-4 text-muted"></i>
                        <h5 class="mt-3 text-muted">No inventory history found</h5>
                        <p class="text-muted">This product hasn't had any inventory movements yet.</p>
                    </div>
                @else
                    <div class="timeline">
                        @foreach($movements as $movement)
                            <div class="timeline-item">
                                <div class="movement-card p-3 {{ strtolower($movement->movement_type) == 'in' ? 'movement-in' : 'movement-out' }}">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div class="flex-grow-1">
                                            <div class="d-flex align-items-center mb-2">
                                                <span class="movement-type-badge badge-{{ strtolower($movement->movement_type) }}">
                                                    {{ strtoupper($movement->movement_type) }}
                                                    <small class="ms-1">({{ $movement->movement_source }})</small>
                                                </span>
                                                <span class="ms-2 fw-bold {{ strtolower($movement->movement_type) == 'in' ? 'text-success' : 'text-danger' }}">
                                                    {{ strtolower($movement->movement_type) == 'in' ? '+' : '-' }}{{ $movement->quantity }}
                                                </span>
                                                @if($movement->quantity_before)
                                                    <span class="ms-3 text-muted small">
                                                        Stock: {{ $movement->quantity_before }} → {{ $movement->quantity_before + $movement->quantity }}
                                                    </span>
                                                @endif
                                            </div>
                                            <h6 class="mb-1">{{ $movement->reason }}</h6>
                                            @if($movement->movement_source == 'batch' && $movement->batch)
                                                <p class="mb-1 small">
                                                    <i class="bx bx-package"></i> Batch: {{ $movement->batch->batch_number }}
                                                </p>
                                            @endif
                                            @if($movement->reference_number)
                                                <p class="mb-1 small">
                                                    <i class="bx bx-hash"></i> Reference: {{ $movement->reference_number }}
                                                </p>
                                            @endif
                                            @if($movement->notes)
                                                <p class="mb-1 small text-muted">
                                                    <i class="bx bx-note"></i> {{ $movement->notes }}
                                                </p>
                                            @endif
                                            <p class="mb-0 small">
                                                <i class="bx bx-user"></i> {{ $movement->user->name ?? 'System' }}
                                            </p>
                                        </div>
                                        <div class="text-end">
                                            <div class="text-muted small">
                                                {{ $movement->created_at->format('M d, Y') }}
                                            </div>
                                            <div class="text-muted small">
                                                {{ $movement->created_at->format('H:i') }}
                                            </div>
                                            <div class="mt-1">
                                                <small class="badge bg-light text-dark">{{ $movement->movement_source }}</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-between align-items-center mt-4">
                        <div class="pagination-info">
                            Page {{ $movements->currentPage() }} of {{ $movements->lastPage() }}
                        </div>
                        <nav>
                            {{ $movements->withQueryString()->links() }}
                        </nav>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
$(document).ready(function() {
    // Stock Chart
    const stockCtx = document.getElementById('stockChart').getContext('2d');
    const stockChart = new Chart(stockCtx, {
        type: 'line',
        data: {
            labels: @json($chartData['daily']['labels']),
            datasets: [
                {
                    label: 'Stock In',
                    data: @json($chartData['daily']['in']),
                    borderColor: '#10b981',
                    backgroundColor: 'rgba(16, 185, 129, 0.1)',
                    borderWidth: 2,
                    fill: false,
                    tension: 0.4
                },
                {
                    label: 'Stock Out',
                    data: @json($chartData['daily']['out']),
                    borderColor: '#ef4444',
                    backgroundColor: 'rgba(239, 68, 68, 0.1)',
                    borderWidth: 2,
                    fill: false,
                    tension: 0.4
                },
                {
                    label: 'Cumulative Stock',
                    data: @json($chartData['daily']['cumulative']),
                    borderColor: '#667eea',
                    backgroundColor: 'rgba(102, 126, 234, 0.1)',
                    borderWidth: 3,
                    fill: true,
                    tension: 0.4
                }
            ]
        },
        options: {
            responsive: true,
            interaction: {
                intersect: false,
                mode: 'index'
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: {
                        drawBorder: false
                    }
                },
                x: {
                    grid: {
                        display: false
                    }
                }
            },
            plugins: {
                legend: {
                    display: false
                },
                tooltip: {
                    mode: 'index',
                    intersect: false
                }
            }
        }
    });

    // Type Distribution Chart
    const typeCtx = document.getElementById('typeChart').getContext('2d');
    const typeChart = new Chart(typeCtx, {
        type: 'doughnut',
        data: {
            labels: ['Stock In', 'Stock Out'],
            datasets: [{
                data: [
                    {{ $chartData['typeDistribution']['in'] }},
                    {{ $chartData['typeDistribution']['out'] }}
                ],
                backgroundColor: [
                    '#10b981',
                    '#ef4444'
                ],
                borderWidth: 1,
                borderColor: '#fff'
            }]
        },
        options: {
            responsive: true,
            cutout: '70%',
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 20,
                        usePointStyle: true,
                    }
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            let label = context.label || '';
                            let value = context.raw || 0;
                            let total = context.dataset.data.reduce((a, b) => a + b, 0);
                            let percentage = total > 0 ? Math.round((value / total) * 100) : 0;
                            return `${label}: ${value} (${percentage}%)`;
                        }
                    }
                }
            }
        }
    });

    // Auto-submit filters on change
    $('select[name="movement_type"], input[name="start_date"], input[name="end_date"]').change(function() {
        if ($(this).val()) {
            setTimeout(() => {
                $('#filterForm').submit();
            }, 300);
        }
    });

    // Refresh charts every 30 seconds
    setInterval(() => {
        $.ajax({
            url: '{{ route("products.inventory-summary", $product) }}',
            method: 'GET',
            success: function(response) {
                if (response.success) {
                    // Update stock chart
                    stockChart.data.labels = response.daily_chart.labels;
                    stockChart.data.datasets[0].data = response.daily_chart.in;
                    stockChart.data.datasets[1].data = response.daily_chart.out;
                    stockChart.data.datasets[2].data = response.daily_chart.cumulative;
                    stockChart.update('none');
                    
                    // Update type chart
                    typeChart.data.datasets[0].data = [
                        response.type_distribution.in,
                        response.type_distribution.out
                    ];
                    typeChart.update('none');
                    
                    // Update statistics display
                    $('.stat-value').eq(0).text(response.stats.total_movements);
                    $('.stat-value').eq(1).text(response.stats.total_in).addClass('text-success');
                    $('.stat-value').eq(2).text(response.stats.total_out).addClass('text-danger');
                    $('.stat-value').eq(3).text(response.stats.net_movement >= 0 ? '+' + response.stats.net_movement : response.stats.net_movement)
                        .toggleClass('text-success', response.stats.net_movement >= 0)
                        .toggleClass('text-danger', response.stats.net_movement < 0);
                }
            }
        });
    }, 30000);

    // Keyboard shortcuts
    $(document).keydown(function(e) {
        // Ctrl/Cmd + E to export
        if ((e.ctrlKey || e.metaKey) && e.key === 'e') {
            e.preventDefault();
            window.location.href = '{{ route("products.inventory-history.export", $product) }}';
        }
        // Ctrl/Cmd + R to reset filters
        if ((e.ctrlKey || e.metaKey) && e.key === 'r') {
            e.preventDefault();
            window.location.href = '{{ route("products.inventory-history", $product) }}';
        }
    });
});
</script>
@endsection