<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Receipt Error</title>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .error-container {
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            max-width: 600px;
            width: 100%;
            text-align: center;
        }
        
        .error-icon {
            font-size: 80px;
            color: #ef4444;
            margin-bottom: 20px;
        }
        
        .error-title {
            color: #1f2937;
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 15px;
        }
        
        .error-message {
            color: #6b7280;
            font-size: 16px;
            margin-bottom: 25px;
            line-height: 1.6;
        }
        
        .error-details {
            background: #f9fafb;
            border-radius: 10px;
            padding: 20px;
            margin: 25px 0;
            text-align: left;
            font-family: 'Courier New', monospace;
            font-size: 14px;
        }
        
        .action-buttons {
            display: flex;
            gap: 15px;
            justify-content: center;
            flex-wrap: wrap;
            margin-top: 30px;
        }
        
        .btn {
            padding: 12px 24px;
            border-radius: 10px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            transition: all 0.3s;
        }
        
        .btn-primary {
            background: #3b82f6;
            color: white;
            border: none;
        }
        
        .btn-primary:hover {
            background: #2563eb;
            transform: translateY(-2px);
        }
        
        .btn-secondary {
            background: #f3f4f6;
            color: #4b5563;
            border: 1px solid #d1d5db;
        }
        
        .btn-secondary:hover {
            background: #e5e7eb;
        }
        
        .identifier {
            background: #fef3c7;
            color: #92400e;
            padding: 4px 12px;
            border-radius: 6px;
            font-weight: 600;
        }
    </style>
</head>
<body>
    <div class="error-container">
        <div class="error-icon">⚠️</div>
        
        <h1 class="error-title">Receipt Not Found</h1>
        
        <p class="error-message">
            We couldn't find the receipt for identifier: 
            <span class="identifier">{{ $identifier }}</span>
        </p>
        
        <div class="error-details">
            <strong>Error Details:</strong><br>
            {{ $error }}<br><br>
            
            <strong>Time:</strong> {{ $timestamp }}<br>
            <strong>URL:</strong> {{ url()->current() }}
        </div>
        
        <div class="action-buttons">
            <a href="{{ $retry_url }}" class="btn btn-primary">
                🔄 Retry Loading Receipt
            </a>
            
            <a href="{{ $home_url }}" class="btn btn-secondary">
                🏠 Back to POS
            </a>
            
            <button onclick="window.print()" class="btn btn-secondary">
                🖨️ Print This Page
            </button>
            
            <button onclick="window.close()" class="btn btn-secondary">
                ❌ Close Window
            </button>
        </div>
        
        <div style="margin-top: 30px; font-size: 12px; color: #9ca3af;">
            <p>If this error persists, please contact support with the error details above.</p>
        </div>
    </div>
    
    <script>
        // Auto-close after 30 seconds if it's a popup
        setTimeout(() => {
            if (window.opener && !window.opener.closed) {
                window.close();
            }
        }, 30000);
    </script>
</body>
</html>