<div class="stats-sidebar h-100">
    <!-- Today's Summary -->
    <div class="card mb-3">
        <div class="card-header bg-primary text-white">
            <h6 class="mb-0">
                <i class="bx bx-bar-chart me-2"></i>Today's Summary
            </h6>
        </div>
        <div class="card-body"><!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Receipt - {{ $receiptData['invoice_no'] }}</title>
    <style>
        @page { margin: 0; }
        body {
            font-family: 'Courier New', monospace;
            font-size: 12px;
            margin: 0;
            padding: 10px;
            color: #000;
        }
        .receipt {
            width: 280px;
            margin: 0 auto;
        }
        .header {
            text-align: center;
            margin-bottom: 10px;
            border-bottom: 2px dashed #000;
            padding-bottom: 10px;
        }
        .header h1 {
            font-size: 18px;
            font-weight: bold;
            margin: 5px 0;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        .header h2 {
            font-size: 14px;
            margin: 3px 0;
            font-weight: normal;
        }
        .store-info {
            font-size: 10px;
            line-height: 1.3;
            margin-bottom: 8px;
        }
        .store-info strong {
            font-weight: bold;
        }
        .divider {
            border-top: 1px dashed #000;
            margin: 5px 0;
        }
        .bold-divider {
            border-top: 2px solid #000;
            margin: 8px 0;
        }
        .receipt-info {
            display: flex;
            justify-content: space-between;
            margin-bottom: 8px;
        }
        .receipt-info .label {
            font-weight: bold;
        }
        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin: 10px 0;
        }
        .items-table th {
            text-align: left;
            border-bottom: 1px solid #000;
            padding: 3px 0;
            font-weight: bold;
            text-transform: uppercase;
            font-size: 11px;
        }
        .items-table td {
            padding: 3px 0;
            border-bottom: 1px dashed #ccc;
        }
        .items-table .qty {
            text-align: center;
            width: 40px;
        }
        .items-table .price {
            text-align: right;
            width: 60px;
        }
        .items-table .total {
            text-align: right;
            width: 70px;
        }
        .items-table .desc {
            max-width: 120px;
            word-break: break-word;
        }
        .totals {
            margin-top: 10px;
        }
        .total-row {
            display: flex;
            justify-content: space-between;
            padding: 2px 0;
        }
        .total-row strong {
            font-weight: bold;
        }
        .total-row.total-amount {
            font-size: 14px;
            font-weight: bold;
            padding: 5px 0;
            border-top: 2px solid #000;
            border-bottom: 2px solid #000;
            margin: 5px 0;
        }
        .payment-info {
            margin: 10px 0;
            padding: 8px;
            background: #f5f5f5;
            border-radius: 4px;
        }
        .payment-details {
            display: flex;
            justify-content: space-between;
            margin: 3px 0;
        }
        .customer-info {
            margin: 10px 0;
            padding: 8px;
            border: 1px dashed #000;
            border-radius: 4px;
        }
        .barcode {
            text-align: center;
            margin: 15px 0;
        }
        .barcode-text {
            font-family: monospace;
            letter-spacing: 2px;
            margin-top: 5px;
        }
        .footer {
            text-align: center;
            margin-top: 15px;
            font-size: 10px;
            line-height: 1.3;
        }
        .footer .thank-you {
            font-size: 12px;
            font-weight: bold;
            margin: 8px 0;
        }
        .footer .legal {
            font-size: 9px;
            color: #666;
            margin-top: 10px;
        }
        .vat-breakdown {
            background: #f9f9f9;
            padding: 8px;
            margin: 10px 0;
            border-radius: 4px;
            font-size: 11px;
        }
        .vat-row {
            display: flex;
            justify-content: space-between;
            margin: 2px 0;
        }
        .warning {
            color: #ff0000;
            font-weight: bold;
            text-align: center;
            margin: 5px 0;
        }
        .center {
            text-align: center;
        }
        .right {
            text-align: right;
        }
        .left {
            text-align: left;
        }
        @media print {
            body { padding: 0; }
            .receipt { width: 100%; }
            .no-print { display: none !important; }
            .print-button { display: none !important; }
        }

        .vat-section {
    margin: 10px 0;
    padding: 8px;
    border: 1px solid #000;
    border-radius: 4px;
}

.vat-title {
    text-align: center;
    font-weight: bold;
    margin-bottom: 5px;
    text-transform: uppercase;
    font-size: 11px;
}

.vat-details {
    display: flex;
    justify-content: space-between;
    margin: 3px 0;
    font-size: 11px;
}

.vat-details .label {
    font-weight: bold;
}

.vat-details .value {
    text-align: right;
}

.tax-warning {
    background: #fff3cd;
    border: 1px solid #ffc107;
    border-radius: 4px;
    padding: 5px;
    margin: 5px 0;
    font-size: 10px;
    text-align: center;
}
    </style>
</head>
<body>
    <div class="receipt">
        <!-- Header -->
        <div class="header">
            <h1>{{ $receiptData['store']['name'] }}</h1>
            <h2>{{ $receiptData['store']['location'] ?? 'POINT OF SALE' }}</h2>
            <div class="divider"></div>
            <div class="store-info">
                @if(!empty($receiptData['store']['address']))
                    <div><strong>Address:</strong> {{ $receiptData['store']['address'] }}</div>
                @endif
                @if(!empty($receiptData['store']['phone']))
                    <div><strong>Tel:</strong> {{ $receiptData['store']['phone'] }}</div>
                @endif
                @if(!empty($receiptData['store']['email']))
                    <div><strong>Email:</strong> {{ $receiptData['store']['email'] }}</div>
                @endif
                @if(!empty($receiptData['store']['pin']))
                    <div><strong>KRA PIN:</strong> {{ $receiptData['store']['pin'] }}</div>
                @endif
                @if(!empty($receiptData['store']['vat_number']))
                    <div><strong>VAT NO:</strong> {{ $receiptData['store']['vat_number'] }}</div>
                @endif
            </div>
            <div class="bold-divider"></div>
        </div>

        <!-- Receipt Info -->
        <div class="receipt-info">
            <div>
                <span class="label">RECEIPT NO:</span> {{ $receiptData['invoice_no'] }}
            </div>
            <div>
                <span class="label">DATE:</span> {{ $receiptData['date'] }}
            </div>
        </div>
        <div class="receipt-info">
            <div>
                <span class="label">TIME:</span> {{ $receiptData['time'] }}
            </div>
            <div>
                <span class="label">CASHIER:</span> {{ $receiptData['cashier'] }}
            </div>
        </div>

        <!-- Customer Info -->
        
        @if(!empty($receiptData['customer']))
            <div class="customer-info">
                <div style="margin-bottom: 5px;"><strong>CUSTOMER DETAILS</strong></div>
                <div><strong>Name:</strong> {{ $receiptData['customer']['name'] ?? 'Walk-in Customer' }}</div>
                @if(!empty($receiptData['customer']['phone']))
                    <div><strong>Phone:</strong> {{ $receiptData['customer']['phone'] }}</div>
                @endif
                
                <!-- ADD THESE LINES FOR VAT/TAX INFORMATION -->
                @if(!empty($receiptData['customer']['vat_number']))
                    <div><strong>VAT Number:</strong> {{ $receiptData['customer']['vat_number'] }}</div>
                @endif
                
                @if(!empty($receiptData['customer']['pin']))
                    <div><strong>Tax PIN:</strong> {{ $receiptData['customer']['pin'] }}</div>
                @endif
                
                @if(!empty($receiptData['customer']['company_name']))
                    <div><strong>Company:</strong> {{ $receiptData['customer']['company_name'] }}</div>
                @endif
                
                @if(!empty($receiptData['customer']['address']))
                    <div><strong>Address:</strong> {{ $receiptData['customer']['address'] }}</div>
                @endif
            </div>
        @endif
        <!-- Items Table -->
        <table class="items-table">
            <thead>
                <tr>
                    <th class="qty">QTY</th>
                    <th class="desc">DESCRIPTION</th>
                    <th class="price">PRICE</th>
                    <th class="total">AMOUNT</th>
                </tr>
            </thead>
            <tbody>
                @foreach($receiptData['items'] as $item)
                    <tr>
                        <td class="qty">{{ number_format($item['quantity'], 2) }}</td>
                        <td class="desc">
                            {{ $item['name'] }}
                            @if($item['vat_included'] ?? false)
                                <span style="font-size: 9px; color: #666;">(VAT Inc.)</span>
                            @endif
                        </td>
                        <td class="price">{{ number_format($item['unit_price'], 2) }}</td>
                        <td class="total">{{ number_format($item['total'], 2) }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
        <div class="bold-divider"></div>

        <!-- Totals -->
        <div class="totals">
            <div class="total-row">
                <span>SUB-TOTAL:</span>
                <span>{{ number_format($receiptData['totals']['subtotal'], 2) }}</span>
            </div>
            
            @if($receiptData['totals']['vat_amount'] > 0)
                <div class="total-row">
                    <span>VAT (16%):</span>
                    <span>{{ number_format($receiptData['totals']['vat_amount'], 2) }}</span>
                </div>
            @endif
            
            @if($receiptData['totals']['discount'] > 0)
                <div class="total-row">
                    <span>DISCOUNT:</span>
                    <span>-{{ number_format($receiptData['totals']['discount'], 2) }}</span>
                </div>
            @endif
            
            <div class="total-row total-amount">
                <span>TOTAL:</span>
                <span>{{ number_format($receiptData['totals']['grand_total'], 2) }}</span>
            </div>
        </div>

        <!-- VAT Breakdown -->
        @if($receiptData['totals']['vat_amount'] > 0)
            <div class="vat-breakdown">
                <div style="text-align: center; margin-bottom: 5px;"><strong>VAT BREAKDOWN</strong></div>
                <div class="vat-row">
                    <span>Taxable Amount:</span>
                    <span>{{ number_format($receiptData['totals']['vatable_amount'], 2) }}</span>
                </div>
                <div class="vat-row">
                    <span>VAT Rate:</span>
                    <span>16%</span>
                </div>
                <div class="vat-row">
                    <span>VAT Amount:</span>
                    <span>{{ number_format($receiptData['totals']['vat_amount'], 2) }}</span>
                </div>
            </div>
        @endif

        <!-- Payment Information -->
        <div class="payment-info">
            <div style="text-align: center; margin-bottom: 5px;"><strong>PAYMENT DETAILS</strong></div>
            <div class="payment-details">
                <span>Method:</span>
                <span style="font-weight: bold;">{{ strtoupper($receiptData['payment']['method']) }}</span>
            </div>
            <div class="payment-details">
                <span>Amount Paid:</span>
                <span>{{ number_format($receiptData['payment']['amount_paid'], 2) }}</span>
            </div>
            
            @if($receiptData['payment']['method'] == 'cash')
                <div class="payment-details">
                    <span>Cash Tendered:</span>
                    <span>{{ number_format($receiptData['payment']['cash_tendered'], 2) }}</span>
                </div>
                <div class="payment-details">
                    <span>Change:</span>
                    <span style="font-weight: bold;">{{ number_format($receiptData['payment']['change'], 2) }}</span>
                </div>
            @endif
            
            @if($receiptData['payment']['method'] == 'mpesa' && !empty($receiptData['payment']['mpesa_details']))
                <div class="bold-divider" style="margin: 5px 0;"></div>
                <div class="payment-details">
                    <span>Phone No:</span>
                    <span>{{ $receiptData['payment']['mpesa_details']['phone'] }}</span>
                </div>
                @if(!empty($receiptData['payment']['mpesa_details']['transaction_id']))
                    <div class="payment-details">
                        <span>Transaction ID:</span>
                        <span>{{ $receiptData['payment']['mpesa_details']['transaction_id'] }}</span>
                    </div>
                @endif
            @endif
            
            @if($receiptData['payment']['method'] == 'card' && !empty($receiptData['payment']['card_details']))
                <div class="bold-divider" style="margin: 5px 0;"></div>
                <div class="payment-details">
                    <span>Card Type:</span>
                    <span>{{ $receiptData['payment']['card_details']['type'] }}</span>
                </div>
                <div class="payment-details">
                    <span>Last 4 Digits:</span>
                    <span>**** **** **** {{ $receiptData['payment']['card_details']['last4'] }}</span>
                </div>
                @if(!empty($receiptData['payment']['card_details']['transaction_id']))
                    <div class="payment-details">
                        <span>Auth Code:</span>
                        <span>{{ $receiptData['payment']['card_details']['transaction_id'] }}</span>
                    </div>
                @endif
            @endif
        </div>

        <!-- Barcode -->
        <div class="barcode">
            <div class="barcode-text">*{{ $receiptData['invoice_no'] }}*</div>
            <div class="divider"></div>
        </div>

        <!-- Footer -->
        <div class="footer">
            <div class="thank-you">THANK YOU FOR YOUR BUSINESS!</div>
            <div style="margin: 5px 0;">
                Items sold are not returnable unless defective<br>
                Goods once sold cannot be returned or exchanged<br>
                Please check goods before leaving the counter
            </div>
            <div class="legal">
                <strong>LEGAL NOTICE:</strong><br>
                This receipt is computer generated and requires no signature.<br>
                Keep this receipt for warranty claims and returns.<br>
                Valid for 7 days from date of purchase for exchanges only.
            </div>
            <div class="divider" style="margin: 10px 0;"></div>
            <div>
                <strong>For Complaints Contact:</strong><br>
                {{ $receiptData['store']['phone'] ?? 'N/A' }} | {{ $receiptData['store']['email'] ?? 'N/A' }}
            </div>
        </div>

        <!-- Print button (only visible on screen) -->
        <div class="no-print center" style="margin-top: 20px;">
            <button class="print-button" onclick="window.print()" 
                    style="padding: 10px 20px; background: #2a4365; color: white; 
                           border: none; border-radius: 5px; cursor: pointer;">
                <i class="bx bx-printer"></i> Print Receipt
            </button>
            <button onclick="window.close()" 
                    style="padding: 10px 20px; background: #6c757d; color: white; 
                           border: none; border-radius: 5px; cursor: pointer; margin-left: 10px;">
                Close
            </button>
        </div>
    </div>

    <script>
        // Auto-print if requested
        @if(request('autoprint') || $receiptData['autoprint'] ?? false)
            window.onload = function() {
                setTimeout(function() {
                    window.print();
                }, 500);
            };
        @endif
        
        // Auto-close after printing
        window.onafterprint = function() {
            setTimeout(function() {
                window.close();
            }, 1000);
        };
    </script>
</body>
</html>
            <div class="today-stats">
                <div class="stat-item d-flex justify-content-between align-items-center mb-3">
                    <div>
                        <div class="stat-label text-muted small">Total Sales</div>
                        <div class="stat-value fw-bold" id="todayTotalSales">0</div>
                    </div>
                    <div class="stat-icon text-primary">
                        <i class="bx bx-receipt fs-4"></i>
                    </div>
                </div>
                
                <div class="stat-item d-flex justify-content-between align-items-center mb-3">
                    <div>
                        <div class="stat-label text-muted small">Revenue</div>
                        <div class="stat-value fw-bold" id="todayRevenue">KES 0</div>
                    </div>
                    <div class="stat-icon text-success">
                        <i class="bx bx-money fs-4"></i>
                    </div>
                </div>
                
                <div class="stat-item d-flex justify-content-between align-items-center mb-3">
                    <div>
                        <div class="stat-label text-muted small">Average Sale</div>
                        <div class="stat-value fw-bold" id="todayAvgSale">KES 0</div>
                    </div>
                    <div class="stat-icon text-info">
                        <i class="bx bx-trending-up fs-4"></i>
                    </div>
                </div>
                
                <div class="stat-item d-flex justify-content-between align-items-center mb-3">
                    <div>
                        <div class="stat-label text-muted small">Customers</div>
                        <div class="stat-value fw-bold" id="todayCustomers">0</div>
                    </div>
                    <div class="stat-icon text-warning">
                        <i class="bx bx-user fs-4"></i>
                    </div>
                </div>
                
                <div class="stat-item d-flex justify-content-between align-items-center">
                    <div>
                        <div class="stat-label text-muted small">Items Sold</div>
                        <div class="stat-value fw-bold" id="todayItemsSold">0</div>
                    </div>
                    <div class="stat-icon text-danger">
                        <i class="bx bx-package fs-4"></i>
                    </div>
                </div>
            </div>
            
            <!-- Progress Bars -->
            <div class="progress-stats mt-4">
                <div class="mb-3">
                    <div class="d-flex justify-content-between small text-muted mb-1">
                        <span>Daily Target</span>
                        <span id="dailyTargetProgress">0%</span>
                    </div>
                    <div class="progress" style="height: 6px;">
                        <div class="progress-bar bg-success" id="dailyTargetBar" 
                             style="width: 0%" role="progressbar"></div>
                    </div>
                </div>
                
                <div class="mb-3">
                    <div class="d-flex justify-content-between small text-muted mb-1">
                        <span>Monthly Target</span>
                        <span id="monthlyTargetProgress">0%</span>
                    </div>
                    <div class="progress" style="height: 6px;">
                        <div class="progress-bar bg-info" id="monthlyTargetBar" 
                             style="width: 0%" role="progressbar"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Top Products -->
    <div class="card mb-3">
        <div class="card-header bg-info text-white">
            <h6 class="mb-0">
                <i class="bx bx-star me-2"></i>Top Products Today
            </h6>
        </div>
        <div class="card-body">
            <div class="top-products" id="topProducts">
                <!-- Top products will be loaded here -->
                <div class="text-center py-3">
                    <div class="spinner-border spinner-border-sm text-primary" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Recent Sales -->
    <div class="card">
        <div class="card-header bg-success text-white">
            <h6 class="mb-0">
                <i class="bx bx-time me-2"></i>Recent Sales
            </h6>
        </div>
        <div class="card-body">
            <div class="recent-sales" id="recentSales">
                <!-- Recent sales will be loaded here -->
                <div class="text-center py-3">
                    <div class="spinner-border spinner-border-sm text-primary" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .stats-sidebar {
        overflow-y: auto;
    }
    
    .stat-item {
        padding: 8px 0;
        border-bottom: 1px solid #f1f5f9;
    }
    
    .stat-item:last-child {
        border-bottom: none;
    }
    
    .stat-label {
        font-size: 12px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .stat-value {
        font-size: 18px;
        color: #1e293b;
    }
    
    .stat-icon {
        width: 40px;
        height: 40px;
        border-radius: 8px;
        background: #f8fafc;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .progress-stats .progress {
        background-color: #e2e8f0;
    }
    
    .top-products {
        max-height: 200px;
        overflow-y: auto;
    }
    
    .top-product-item {
        display: flex;
        align-items: center;
        gap: 10px;
        padding: 8px 0;
        border-bottom: 1px solid #f1f5f9;
    }
    
    .top-product-item:last-child {
        border-bottom: none;
    }
    
    .product-rank {
        width: 24px;
        height: 24px;
        border-radius: 50%;
        background: #2a4365;
        color: white;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 12px;
        font-weight: bold;
    }
    
    .rank-1 {
        background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
    }
    
    .rank-2 {
        background: linear-gradient(135deg, #94a3b8 0%, #64748b 100%);
    }
    
    .rank-3 {
        background: linear-gradient(135deg, #f97316 0%, #ea580c 100%);
    }
    
    .product-info {
        flex: 1;
    }
    
    .product-name {
        font-size: 13px;
        font-weight: 500;
        color: #1e293b;
        margin-bottom: 2px;
    }
    
    .product-sales {
        font-size: 11px;
        color: #64748b;
    }
    
    .product-revenue {
        font-size: 12px;
        font-weight: 600;
        color: #10b981;
    }
    
    .recent-sales {
        max-height: 200px;
        overflow-y: auto;
    }
    
    .recent-sale-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 8px 0;
        border-bottom: 1px solid #f1f5f9;
        cursor: pointer;
        transition: background-color 0.2s;
    }
    
    .recent-sale-item:hover {
        background-color: #f8fafc;
    }
    
    .recent-sale-item:last-child {
        border-bottom: none;
    }
    
    .sale-info {
        flex: 1;
    }
    
    .sale-invoice {
        font-size: 12px;
        font-weight: 600;
        color: #1e293b;
        margin-bottom: 2px;
    }
    
    .sale-time {
        font-size: 11px;
        color: #64748b;
    }
    
    .sale-amount {
        font-size: 14px;
        font-weight: 600;
        color: #10b981;
    }
    
    @media (max-width: 768px) {
        .stats-sidebar {
            display: none;
        }
    }
</style>

<script>
    function loadTodayStats() {
        fetch('/api/stats/today')
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    updateTodayStats(data.stats);
                    updateTargetProgress(data.targets);
                }
            })
            .catch(error => {
                console.error('Stats error:', error);
            });
    }
    
    function updateTodayStats(stats) {
        document.getElementById('todayTotalSales').textContent = stats.total_sales || 0;
        document.getElementById('todayRevenue').textContent = 'KES ' + (stats.revenue || 0).toFixed(2);
        document.getElementById('todayAvgSale').textContent = 'KES ' + (stats.avg_sale || 0).toFixed(2);
        document.getElementById('todayCustomers').textContent = stats.customers || 0;
        document.getElementById('todayItemsSold').textContent = stats.items_sold || 0;
        
        // Update main header stats
        document.getElementById('todaySalesCount').textContent = stats.total_sales || 0;
        document.getElementById('todayRevenue').textContent = 'KES ' + (stats.revenue || 0).toFixed(2);
        document.getElementById('avgSale').textContent = 'KES ' + (stats.avg_sale || 0).toFixed(2);
        document.getElementById('todayCustomers').textContent = stats.customers || 0;
    }
    
    function updateTargetProgress(targets) {
        const dailyProgress = Math.min((targets.daily_actual / targets.daily_target) * 100, 100);
        const monthlyProgress = Math.min((targets.monthly_actual / targets.monthly_target) * 100, 100);
        
        document.getElementById('dailyTargetProgress').textContent = dailyProgress.toFixed(1) + '%';
        document.getElementById('monthlyTargetProgress').textContent = monthlyProgress.toFixed(1) + '%';
        document.getElementById('dailyTargetBar').style.width = dailyProgress + '%';
        document.getElementById('monthlyTargetBar').style.width = monthlyProgress + '%';
    }
    
    function loadTopProducts() {
        fetch('/api/stats/top-products')
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    renderTopProducts(data.products);
                }
            })
            .catch(error => {
                console.error('Top products error:', error);
            });
    }
    
    function renderTopProducts(products) {
        const container = document.getElementById('topProducts');
        
        if (!products || products.length === 0) {
            container.innerHTML = `
                <div class="text-center py-3 text-muted">
                    <i class="bx bx-package fs-1 mb-2"></i>
                    <p class="small">No sales today</p>
                </div>
            `;
            return;
        }
        
        let html = '';
        products.forEach((product, index) => {
            const rankClass = `rank-${index + 1}`;
            html += `
                <div class="top-product-item">
                    <div class="product-rank ${rankClass}">${index + 1}</div>
                    <div class="product-info">
                        <div class="product-name">${product.name}</div>
                        <div class="product-sales">${product.quantity} units sold</div>
                    </div>
                    <div class="product-revenue">
                        KES ${product.revenue.toFixed(2)}
                    </div>
                </div>
            `;
        });
        
        container.innerHTML = html;
    }
    
    function loadRecentSales() {
        fetch('/api/stats/recent-sales')
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    renderRecentSales(data.sales);
                }
            })
            .catch(error => {
                console.error('Recent sales error:', error);
            });
    }
    
    function renderRecentSales(sales) {
        const container = document.getElementById('recentSales');
        
        if (!sales || sales.length === 0) {
            container.innerHTML = `
                <div class="text-center py-3 text-muted">
                    <i class="bx bx-receipt fs-1 mb-2"></i>
                    <p class="small">No recent sales</p>
                </div>
            `;
            return;
        }
        
        let html = '';
        sales.forEach(sale => {
            const timeAgo = getTimeAgo(sale.created_at);
            html += `
                <div class="recent-sale-item" onclick="viewSaleDetails(${sale.id})">
                    <div class="sale-info">
                        <div class="sale-invoice">${sale.invoice_no}</div>
                        <div class="sale-time">${timeAgo} • ${sale.customer || 'Walk-in'}</div>
                    </div>
                    <div class="sale-amount">
                        KES ${sale.total.toFixed(2)}
                    </div>
                </div>
            `;
        });
        
        container.innerHTML = html;
    }
    
    function getTimeAgo(dateString) {
        const now = new Date();
        const past = new Date(dateString);
        const diffMs = now - past;
        const diffMins = Math.floor(diffMs / (1000 * 60));
        const diffHours = Math.floor(diffMs / (1000 * 60 * 60));
        
        if (diffMins < 1) return 'Just now';
        if (diffMins < 60) return `${diffMins}m ago`;
        if (diffHours < 24) return `${diffHours}h ago`;
        return `${Math.floor(diffHours / 24)}d ago`;
    }
    
    function viewSaleDetails(saleId) {
        // Implement sale details view
        console.log('View sale details:', saleId);
    }
    
    // Auto-refresh stats every 30 seconds
    setInterval(() => {
        if (!document.hidden) {
            loadTodayStats();
            loadTopProducts();
            loadRecentSales();
        }
    }, 30000);
    
    // Initial load
    document.addEventListener('DOMContentLoaded', function() {
        loadTodayStats();
        loadTopProducts();
        loadRecentSales();
    });
</script>