<div class="modal fade" id="receiptModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title">
                    <i class="bx bx-receipt me-2"></i>Sale Receipt
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            
            <!-- Modal Body -->
            <div class="modal-body">
                <div class="receipt-container">
                    <!-- Modern Kenyan Supermarket Receipt -->
                    <div class="receipt modern-kenyan" id="modernReceipt">
                        <!-- Receipt content will be loaded via JavaScript -->
                    </div>
                    
                    <!-- Receipt Actions -->
                    <div class="receipt-actions mt-4">
                        <div class="d-grid gap-2 d-md-flex justify-content-md-center">
                            <button class="btn btn-primary" onclick="printReceipt()">
                                <i class="bx bx-printer me-2"></i>Print Receipt
                            </button>
                            <button class="btn btn-outline-primary" onclick="printThermalReceipt()">
                                <i class="bx bx-printer me-2"></i>Thermal Print
                            </button>
                            <button class="btn btn-success" onclick="emailReceipt()">
                                <i class="bx bx-envelope me-2"></i>Email Receipt
                            </button>
                            <button class="btn btn-info" onclick="shareWhatsApp()">
                                <i class="bx bxl-whatsapp me-2"></i>WhatsApp
                            </button>
                            <button class="btn btn-secondary" onclick="downloadReceiptPDF()">
                                <i class="bx bx-download me-2"></i>PDF
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Modal Footer -->
            <div class="modal-footer">
                <div class="d-flex justify-content-between w-100">
                    <div>
                        <button class="btn btn-outline-secondary" onclick="reprintReceipt()">
                            <i class="bx bx-revision me-2"></i>Reprint
                        </button>
                        <button class="btn btn-outline-secondary" onclick="voidReceipt()">
                            <i class="bx bx-x-circle me-2"></i>Void Sale
                        </button>
                    </div>
                    <div>
                        <button class="btn btn-success" onclick="startNewSale()">
                            <i class="bx bx-plus-circle me-2"></i>New Sale
                        </button>
                        <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .receipt-container {
        max-height: 70vh;
        overflow-y: auto;
    }
    
    .receipt.modern-kenyan {
        width: 100%;
        max-width: 400px;
        margin: 0 auto;
        font-family: 'Courier New', monospace;
        font-size: 12px;
        line-height: 1.2;
        border: 1px solid #e2e8f0;
        border-radius: 8px;
        padding: 20px;
        background: #fff;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    }
    
    .receipt-header {
        text-align: center;
        border-bottom: 2px dashed #000;
        padding-bottom: 10px;
        margin-bottom: 10px;
    }
    
    .store-name {
        font-weight: bold;
        font-size: 14px;
        text-transform: uppercase;
        margin-bottom: 5px;
    }
    
    .store-details {
        font-size: 10px;
        color: #666;
    }
    
    .store-details div {
        margin-bottom: 2px;
    }
    
    .receipt-info {
        margin-bottom: 10px;
        padding-bottom: 10px;
        border-bottom: 1px dashed #ddd;
    }
    
    .info-row {
        display: flex;
        justify-content: space-between;
        margin-bottom: 3px;
        font-size: 11px;
    }
    
    .info-label {
        font-weight: bold;
    }
    
    .items-table {
        width: 100%;
        margin: 10px 0;
        border-collapse: collapse;
    }
    
    .items-table th {
        text-align: left;
        padding: 5px 0;
        border-bottom: 1px dashed #000;
        font-size: 11px;
        text-transform: uppercase;
    }
    
    .items-table td {
        padding: 6px 0;
        vertical-align: top;
        border-bottom: 1px dotted #eee;
        font-size: 11px;
    }
    
    .item-name {
        width: 40%;
    }
    
    .item-qty {
        width: 15%;
        text-align: center;
    }
    
    .item-price {
        width: 20%;
        text-align: right;
    }
    
    .item-total {
        width: 25%;
        text-align: right;
    }
    
    .vat-badge {
        font-size: 8px;
        background: #dbeafe;
        color: #1e40af;
        padding: 1px 4px;
        border-radius: 2px;
        margin-left: 3px;
    }
    
    .totals-section {
        margin: 10px 0;
        padding-top: 10px;
        border-top: 2px dashed #000;
    }
    
    .total-row {
        display: flex;
        justify-content: space-between;
        margin-bottom: 5px;
        font-size: 12px;
    }
    
    .grand-total {
        font-weight: bold;
        font-size: 14px;
        border-top: 1px solid #000;
        padding-top: 5px;
        margin-top: 5px;
    }
    
    .payment-info {
        background: #f8fafc;
        padding: 10px;
        border-radius: 5px;
        margin: 10px 0;
        border: 1px solid #e2e8f0;
    }
    
    .payment-row {
        display: flex;
        justify-content: space-between;
        margin-bottom: 3px;
        font-size: 11px;
    }
    
    .receipt-footer {
        text-align: center;
        margin-top: 15px;
        padding-top: 10px;
        border-top: 1px dashed #ddd;
        font-size: 10px;
        color: #666;
    }
    
    .thank-you {
        font-weight: bold;
        margin: 5px 0;
        color: #000;
    }
    
    .legal-text {
        font-size: 9px;
        line-height: 1.3;
        margin-top: 8px;
    }
    
    .qr-section {
        text-align: center;
        margin: 15px 0;
        padding: 10px;
        background: #f8fafc;
        border-radius: 5px;
    }
    
    .qr-placeholder {
        width: 100px;
        height: 100px;
        background: #e2e8f0;
        margin: 0 auto 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 5px;
    }
    
    .qr-placeholder i {
        font-size: 24px;
        color: #94a3b8;
    }
    
    .mpesa-details {
        font-size: 11px;
        color: #1e40af;
        background: #dbeafe;
        padding: 5px;
        border-radius: 3px;
        margin-top: 5px;
    }
    
    @media print {
        body * {
            visibility: hidden;
        }
        .receipt.modern-kenyan,
        .receipt.modern-kenyan * {
            visibility: visible;
        }
        .receipt.modern-kenyan {
            position: absolute;
            left: 0;
            top: 0;
            width: 80mm;
            border: none;
            box-shadow: none;
            padding: 10px;
        }
        .receipt-actions,
        .modal-footer,
        .modal-header {
            display: none !important;
        }
    }
</style>

<script>
    function showReceipt(receiptData) {
        renderReceipt(receiptData);
        const modal = new bootstrap.Modal(document.getElementById('receiptModal'));
        modal.show();
    }
    
    function renderReceipt(data) {
        const receiptDiv = document.getElementById('modernReceipt');
        
        let itemsHtml = '';
        data.items.forEach(item => {
            itemsHtml += `
                <tr>
                    <td class="item-name">
                        ${item.name}
                        ${item.is_vatable ? '<span class="vat-badge">VAT</span>' : ''}
                    </td>
                    <td class="item-qty">${item.quantity}</td>
                    <td class="item-price">${formatCurrency(item.unit_price)}</td>
                    <td class="item-total">${formatCurrency(item.total)}</td>
                </tr>
            `;
        });
        
        let paymentHtml = '';
        if (data.payment.method === 'mpesa') {
            paymentHtml = `
                <div class="mpesa-details">
                    <div>M-Pesa Receipt: ${data.payment.receipt_number || 'N/A'}</div>
                    <div>Phone: ${data.payment.phone || 'N/A'}</div>
                    <div>Transaction ID: ${data.payment.transaction_id || 'N/A'}</div>
                </div>
            `;
        }
        
        receiptDiv.innerHTML = `
            <div class="receipt-header">
                <div class="store-name">${data.store.name}</div>
                <div class="store-details">
                    <div>${data.store.address}</div>
                    <div>Tel: ${data.store.phone}</div>
                    <div>PIN: ${data.store.pin || 'P051234567N'}</div>
                </div>
            </div>
            
            <div class="receipt-info">
                <div class="info-row">
                    <span class="info-label">INVOICE NO:</span>
                    <span>${data.invoice_number}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">DATE:</span>
                    <span>${data.date}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">TIME:</span>
                    <span>${data.time}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">CASHIER:</span>
                    <span>${data.cashier}</span>
                </div>
                ${data.customer ? `
                    <div class="info-row">
                        <span class="info-label">CUSTOMER:</span>
                        <span>${data.customer.name}</span>
                    </div>
                    ${data.customer.phone ? `
                        <div class="info-row">
                            <span class="info-label">PHONE:</span>
                            <span>${data.customer.phone}</span>
                        </div>
                    ` : ''}
                ` : ''}
            </div>
            
            <table class="items-table">
                <thead>
                    <tr>
                        <th class="item-name">ITEM</th>
                        <th class="item-qty">QTY</th>
                        <th class="item-price">PRICE</th>
                        <th class="item-total">TOTAL</th>
                    </tr>
                </thead>
                <tbody>
                    ${itemsHtml}
                </tbody>
            </table>
            
            <div class="totals-section">
                <div class="total-row">
                    <span>SUB TOTAL</span>
                    <span>${formatCurrency(data.subtotal)}</span>
                </div>
                ${data.vat > 0 ? `
                    <div class="total-row">
                        <span>VAT (16%)</span>
                        <span>${formatCurrency(data.vat)}</span>
                    </div>
                ` : ''}
                ${data.discount > 0 ? `
                    <div class="total-row text-danger">
                        <span>DISCOUNT</span>
                        <span>-${formatCurrency(data.discount)}</span>
                    </div>
                ` : ''}
                <div class="total-row grand-total">
                    <span>TOTAL</span>
                    <span>${formatCurrency(data.total)}</span>
                </div>
            </div>
            
            <div class="payment-info">
                <div class="payment-row">
                    <span>PAYMENT METHOD:</span>
                    <span>${data.payment.method.toUpperCase()}</span>
                </div>
                <div class="payment-row">
                    <span>AMOUNT PAID:</span>
                    <span>${formatCurrency(data.payment.amount_paid)}</span>
                </div>
                ${data.payment.change > 0 ? `
                    <div class="payment-row">
                        <span>CHANGE:</span>
                        <span>${formatCurrency(data.payment.change)}</span>
                    </div>
                ` : ''}
                ${paymentHtml}
            </div>
            
            ${data.payment.method === 'mpesa' ? `
                <div class="qr-section">
                    <div class="qr-placeholder">
                        <i class="bx bx-qr-scan"></i>
                    </div>
                    <div>Scan for M-Pesa receipt</div>
                </div>
            ` : ''}
            
            <div class="receipt-footer">
                <div class="thank-you">ASANTE SANA - THANK YOU!</div>
                <div>Goods sold are not returnable without receipt</div>
                <div>Please retain your receipt</div>
                <div class="legal-text">
                    This is a computer generated receipt.<br>
                    Valid without stamp and signature.<br>
                    VAT Invoice: ${data.vat > 0 ? 'YES' : 'NO'}
                </div>
            </div>
        `;
    }
    
    function printReceipt() {
        const printWindow = window.open('', '_blank');
        const receiptHtml = document.getElementById('modernReceipt').innerHTML;
        
        printWindow.document.write(`
            <html>
                <head>
                    <title>Receipt - ${document.querySelector('.invoice-number').textContent}</title>
                    <style>
                        body { font-family: 'Courier New', monospace; font-size: 12px; }
                        .receipt { width: 80mm; margin: 0 auto; }
                        @media print { .no-print { display: none; } }
                    </style>
                </head>
                <body>
                    <div class="receipt">
                        ${receiptHtml}
                    </div>
                    <div class="no-print" style="text-align: center; margin-top: 20px;">
                        <button onclick="window.print()">Print</button>
                        <button onclick="window.close()">Close</button>
                    </div>
                </body>
            </html>
        `);
        printWindow.document.close();
    }
    
    function printThermalReceipt() {
        fetch('/pos/print-thermal-receipt', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({ receipt_data: getReceiptData() })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showToast('Receipt sent to thermal printer', 'success');
            } else {
                showToast('Print failed: ' + data.error, 'error');
            }
        })
        .catch(error => {
            console.error('Print error:', error);
            showToast('Print failed', 'error');
        });
    }
    
    function emailReceipt() {
        const email = prompt('Enter customer email address:');
        if (!email) return;
        
        fetch('/pos/email-receipt', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({ 
                email: email,
                receipt_data: getReceiptData() 
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showToast('Receipt sent to ' + email, 'success');
            } else {
                showToast('Email failed: ' + data.error, 'error');
            }
        })
        .catch(error => {
            console.error('Email error:', error);
            showToast('Email failed', 'error');
        });
    }
    
    function shareWhatsApp() {
        const receiptData = getReceiptData();
        const message = `Receipt from ${receiptData.store.name}%0A` +
                       `Invoice: ${receiptData.invoice_number}%0A` +
                       `Date: ${receiptData.date}%0A` +
                       `Total: KES ${receiptData.total}%0A` +
                       `Thank you for your purchase!`;
        
        window.open(`https://wa.me/?text=${message}`, '_blank');
    }
    
    function downloadReceiptPDF() {
        fetch('/pos/download-receipt-pdf', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({ receipt_data: getReceiptData() })
        })
        .then(response => response.blob())
        .then(blob => {
            const url = window.URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.href = url;
            a.download = `receipt-${getReceiptData().invoice_number}.pdf`;
            document.body.appendChild(a);
            a.click();
            window.URL.revokeObjectURL(url);
            document.body.removeChild(a);
        })
        .catch(error => {
            console.error('PDF download error:', error);
            showToast('PDF download failed', 'error');
        });
    }
    
    function reprintReceipt() {
        if (confirm('Reprint last receipt?')) {
            printThermalReceipt();
        }
    }
    
    function voidReceipt() {
        if (confirm('Are you sure you want to void this sale?')) {
            // Implement void sale logic
            showToast('Sale voided successfully', 'success');
            const modal = bootstrap.Modal.getInstance(document.getElementById('receiptModal'));
            modal.hide();
        }
    }
    
    function startNewSale() {
        clearCart();
        const modal = bootstrap.Modal.getInstance(document.getElementById('receiptModal'));
        modal.hide();
        showToast('New sale started', 'info');
    }
    
    function getReceiptData() {
        // This should return the current receipt data
        // You need to store this data when processing the sale
        return window.currentReceiptData || {};
    }
    
    function formatCurrency(amount) {
        return 'KES ' + parseFloat(amount).toFixed(2);
    }
</script>